/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.docstore;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.slider.core.registry.docstore.ConfigFormat;
import org.apache.slider.core.registry.docstore.PublishedExports;

public abstract class PublishedExportsOutputter {
    protected final PublishedExports exports;

    protected PublishedExportsOutputter(PublishedExports exports) {
        this.exports = exports;
    }

    public static PublishedExportsOutputter createOutputter(ConfigFormat format, PublishedExports exports) {
        Preconditions.checkNotNull(exports);
        switch (format) {
            case JSON: {
                return new JsonOutputter(exports);
            }
        }
        throw new RuntimeException("Unsupported format :" + (Object)((Object)format));
    }

    public void save(File dest) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            this.save(out);
            out.close();
        }
        catch (Throwable throwable) {
            org.apache.hadoop.io.IOUtils.closeStream(out);
            throw throwable;
        }
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)out);
    }

    public void save(OutputStream out) throws IOException {
        IOUtils.write((String)this.asString(), (OutputStream)out, (Charset)Charsets.UTF_8);
    }

    public abstract String asString() throws IOException;

    public static class JsonOutputter
    extends PublishedExportsOutputter {
        public JsonOutputter(PublishedExports exports) {
            super(exports);
        }

        @Override
        public void save(File dest) throws IOException {
            FileUtils.writeStringToFile((File)dest, (String)this.asString(), (Charset)Charsets.UTF_8);
        }

        @Override
        public String asString() throws IOException {
            return this.exports.asJson();
        }
    }
}

