/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.persist;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.params.AbstractClusterBuildingActionArgs;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDefinitionPersister {
    private static final Logger log = LoggerFactory.getLogger(AppDefinitionPersister.class);
    private final SliderFileSystem sliderFileSystem;
    private List<AppDefinition> appDefinitions;

    public AppDefinitionPersister(SliderFileSystem sliderFileSystem) {
        this.sliderFileSystem = sliderFileSystem;
        this.appDefinitions = new ArrayList<AppDefinition>();
    }

    private void persistDefinitionPackageOrFolder(AppDefinition appDefinition) throws BadConfigException, IOException {
        if (!appDefinition.appDefPkgOrFolder.canRead()) {
            throw new BadConfigException("Pkg/Folder cannot be accessed - " + appDefinition.appDefPkgOrFolder.getAbsolutePath());
        }
        File src = appDefinition.appDefPkgOrFolder;
        String targetName = appDefinition.pkgName;
        log.debug("Package name: " + targetName);
        if (appDefinition.appDefPkgOrFolder.isDirectory()) {
            log.info("Processing app package/folder {} for {}", (Object)appDefinition.appDefPkgOrFolder.getAbsolutePath(), (Object)appDefinition.pkgName);
            File tmpDir = Files.createTempDir();
            File zipFile = new File(tmpDir.getCanonicalPath(), String.valueOf(File.separator) + appDefinition.pkgName);
            SliderUtils.zipFolder(appDefinition.appDefPkgOrFolder, zipFile);
            src = zipFile;
        }
        this.sliderFileSystem.getFileSystem().copyFromLocalFile(false, false, new Path(src.toURI()), new Path(appDefinition.targetFolderInFs, targetName));
    }

    public void persistPackages() throws BadConfigException, IOException {
        for (AppDefinition appDefinition : this.appDefinitions) {
            this.persistDefinitionPackageOrFolder(appDefinition);
        }
    }

    public void processSuppliedDefinitions(String clustername, AbstractClusterBuildingActionArgs buildInfo, ConfTreeOperations appConf) throws BadConfigException, IOException, BadCommandArgumentsException {
        if (buildInfo.appMetaInfo != null) {
            if (!buildInfo.appMetaInfo.canRead() || !buildInfo.appMetaInfo.isFile()) {
                throw new BadConfigException("--metainfo file cannot be read.");
            }
            if (buildInfo.appDef != null) {
                throw new BadConfigException("both --metainfo and --appdef may not be specified.");
            }
            if (SliderUtils.isSet(appConf.getGlobalOptions().get("application.def"))) {
                throw new BadConfigException("application.def must not be set if --metainfo is provided.");
            }
            File tempDir = Files.createTempDir();
            File pkgSrcDir = new File(tempDir, "default");
            pkgSrcDir.mkdirs();
            Files.copy(buildInfo.appMetaInfo, new File(pkgSrcDir, "metainfo.json"));
            Path appDirPath = this.sliderFileSystem.buildAppDefDirPath(clustername);
            log.info("Using default app def path {}", (Object)appDirPath.toString());
            this.appDefinitions.add(new AppDefinition(appDirPath, pkgSrcDir, "appPkg.zip"));
            Path appDefPath = new Path(appDirPath, "appPkg.zip");
            appConf.getGlobalOptions().set("application.def", appDefPath);
            log.info("Setting app package to {}.", (Object)appDefPath);
        }
        if (buildInfo.appDef != null) {
            if (SliderUtils.isSet(appConf.getGlobalOptions().get("application.def"))) {
                throw new BadConfigException("application.def must not be set if --appdef is provided.");
            }
            if (!buildInfo.appDef.exists()) {
                throw new BadConfigException("--appdef is not a valid path.");
            }
            Path appDirPath = this.sliderFileSystem.buildAppDefDirPath(clustername);
            this.appDefinitions.add(new AppDefinition(appDirPath, buildInfo.appDef, "appPkg.zip"));
            Path appDefPath = new Path(appDirPath, "appPkg.zip");
            appConf.getGlobalOptions().set("application.def", appDefPath);
            log.info("Setting app package to {}.", (Object)appDefPath);
        }
        if (buildInfo.addonDelegate.getAddonMap().size() > 0) {
            if (SliderUtils.isUnset(appConf.getGlobalOptions().get("application.def"))) {
                throw new BadConfigException("addon package can only be specified if main app package is specified.");
            }
            ArrayList<String> addons = new ArrayList<String>();
            Map<String, String> addonMap = buildInfo.addonDelegate.getAddonMap();
            for (String key : addonMap.keySet()) {
                File defPath = new File(addonMap.get(key));
                if (SliderUtils.isUnset(addonMap.get(key))) {
                    throw new BadConfigException("Invalid path for addon package " + key);
                }
                if (!defPath.exists()) {
                    throw new BadConfigException("addon folder or package path is not valid.");
                }
                Path addonPath = this.sliderFileSystem.buildAddonDirPath(clustername, key);
                String addonPkgName = "addon_" + key + ".zip";
                log.debug("addonMap.get(key): {} addonPath: {} defPath: {} addonPkgName: {}", addonMap.get(key), addonPath, defPath, addonPkgName);
                this.appDefinitions.add(new AppDefinition(addonPath, defPath, addonPkgName));
                String addOnKey = "application.addon." + key;
                Path addonPkgPath = new Path(addonPath, addonPkgName);
                log.info("Setting addon package {} to {}.", (Object)addOnKey, (Object)addonPkgPath);
                appConf.getGlobalOptions().set(addOnKey, addonPkgPath);
                addons.add(addOnKey);
            }
            String existingList = appConf.getGlobalOptions().get("application.addons");
            if (SliderUtils.isUnset(existingList)) {
                existingList = "";
            }
            appConf.getGlobalOptions().set("application.addons", String.valueOf(existingList) + StringUtils.join(addons, ","));
        }
    }

    @VisibleForTesting
    public List<AppDefinition> getAppDefinitions() {
        return this.appDefinitions;
    }

    public class AppDefinition {
        public Path targetFolderInFs;
        public File appDefPkgOrFolder;
        public String pkgName;

        public AppDefinition(Path targetFolderInFs, File appDefPkgOrFolder, String pkgName) {
            this.targetFolderInFs = targetFolderInFs;
            this.appDefPkgOrFolder = appDefPkgOrFolder;
            this.pkgName = pkgName;
        }

        public String toString() {
            return "targetFolderInFs" + " : " + this.targetFolderInFs.toString() + ", " + "appDefPkgOrFolder" + " : " + this.appDefPkgOrFolder.toString() + ", " + "pkgName" + " : " + this.pkgName;
        }
    }
}

