/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.launch.CommandLineBuilder;

public class JavaCommandLineBuilder
extends CommandLineBuilder {
    public JavaCommandLineBuilder() {
        this.add(this.getJavaBinary());
    }

    protected String getJavaBinary() {
        return String.valueOf(ApplicationConstants.Environment.JAVA_HOME.$$()) + "/bin/java";
    }

    public void setJVMHeap(String heap) {
        if (SliderUtils.isSet(heap)) {
            this.add("-Xmx" + heap.trim());
        }
    }

    public void enableJavaAssertions() {
        this.add("-ea");
        this.add("-esa");
    }

    public void sysprop(String property, String value) {
        Preconditions.checkArgument(property != null, "null property name");
        Preconditions.checkArgument(value != null, "null value");
        this.add("-D" + property + "=" + value);
    }

    public JavaCommandLineBuilder forceIPv4() {
        this.sysprop("java.net.preferIPv4Stack", "true");
        return this;
    }

    public JavaCommandLineBuilder headless() {
        this.sysprop("java.awt.headless", "true");
        return this;
    }

    public boolean addConfOption(Configuration conf, String key) {
        return this.defineIfSet(key, conf.get(key));
    }

    public void addConfOptions(Configuration conf, String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.addConfOption(conf, key);
            ++n2;
        }
    }

    public int addPrefixedConfOptions(Configuration conf, String prefix) {
        int copied = 0;
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            this.define((String)entry.getKey(), (String)entry.getValue());
            ++copied;
        }
        return copied;
    }

    public String addConfOptionToCLI(Configuration conf, String key, String defVal) {
        Preconditions.checkArgument(key != null, "null key");
        String val = conf.get(key, defVal);
        this.define(key, val);
        return val;
    }

    public void define(String key, String val) {
        Preconditions.checkArgument(key != null, "null key");
        Preconditions.checkArgument(val != null, "null value");
        this.add("-D", String.valueOf(key) + "=" + val);
    }

    public boolean defineIfSet(String key, String val) {
        Preconditions.checkArgument(key != null, "null key");
        if (val != null) {
            this.define(key, val);
            return true;
        }
        return false;
    }

    public void addMandatoryConfOption(Configuration conf, String key) throws BadConfigException {
        if (!this.addConfOption(conf, key)) {
            throw new BadConfigException("Missing configuration option: " + key);
        }
    }
}

