/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.build;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.persist.ConfPersister;
import org.apache.slider.core.persist.LockAcquireFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceIO {
    protected static final Logger log = LoggerFactory.getLogger(InstanceIO.class);

    public static AggregateConf loadInstanceDefinitionUnresolved(CoreFileSystem sliderFileSystem, Path clusterDirectory) throws IOException, SliderException {
        AggregateConf instanceDefinition = new AggregateConf();
        ConfPersister persister = new ConfPersister(sliderFileSystem, clusterDirectory);
        try {
            persister.load(instanceDefinition);
        }
        catch (LockAcquireFailedException e) {
            log.debug("Lock acquisition failure of {}", (Object)clusterDirectory, (Object)e);
            throw new BadClusterStateException("Application at %s is locked for reading", clusterDirectory.toString());
        }
        return instanceDefinition;
    }

    public static void saveInstanceDefinition(CoreFileSystem coreFS, Path dir, AggregateConf instanceDefinition) throws SliderException, IOException, LockAcquireFailedException {
        ConfPersister persister = new ConfPersister(coreFS, dir);
        persister.save(instanceDefinition, null);
    }
}

