/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.tools;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConfigHelper {
    private static final Logger log = LoggerFactory.getLogger(ConfigHelper.class);
    private static AtomicBoolean sliderResourceInjected = new AtomicBoolean(false);
    private static AtomicBoolean sliderResourceInjectionAttempted = new AtomicBoolean(false);

    public static Set<String> dumpConf(Configuration conf) {
        Set<String> keys = ConfigHelper.sortedConfigKeys((Iterable<Map.Entry<String, String>>)conf);
        for (String key : keys) {
            log.info("{}={}", (Object)key, (Object)conf.get(key));
        }
        return keys;
    }

    public static Set<String> sortedConfigKeys(Iterable<Map.Entry<String, String>> conf) {
        TreeSet<String> sorted = new TreeSet<String>();
        for (Map.Entry<String, String> entry : conf) {
            sorted.add(entry.getKey());
        }
        return sorted;
    }

    public static void addConfigMap(Configuration config, Map<String, String> map, String origin) throws BadConfigException {
        ConfigHelper.addConfigMap(config, map.entrySet(), origin);
    }

    public static void addConfigMap(Configuration config, Iterable<Map.Entry<String, String>> map, String origin) throws BadConfigException {
        for (Map.Entry<String, String> mapEntry : map) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            if (value == null) {
                throw new BadConfigException("Null value for property " + key);
            }
            config.set(key, value, origin);
        }
    }

    public static Path saveConfig(Configuration systemConf, Configuration confToSave, Path confdir, String filename) throws IOException {
        FileSystem fs = FileSystem.get((URI)confdir.toUri(), (Configuration)systemConf);
        Path destPath = new Path(confdir, filename);
        ConfigHelper.saveConfig(fs, destPath, confToSave);
        return destPath;
    }

    public static void saveConfig(FileSystem fs, Path destPath, Configuration confToSave) throws IOException {
        FSDataOutputStream fos = fs.create(destPath);
        try {
            confToSave.writeXml((OutputStream)fos);
        }
        finally {
            IOUtils.closeStream((Closeable)fos);
        }
    }

    public static String toXml(Configuration conf) throws IOException {
        StringWriter writer = new StringWriter();
        conf.writeXml((Writer)writer);
        return writer.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parseConfiguration(FileSystem fs, Path path) throws IOException {
        Document document;
        byte[] data = ConfigHelper.loadBytes(fs, path);
        String s = new String(data, 0, data.length);
        log.debug("XML resource {} is \"{}\"", (Object)path, (Object)s);
        ByteArrayInputStream in = null;
        try {
            Document document2;
            in = new ByteArrayInputStream(data);
            document = document2 = ConfigHelper.parseConfigXML(in);
        }
        catch (ParserConfigurationException e) {
            try {
                throw new IOException(e);
                catch (SAXException e2) {
                    throw new IOException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
        }
        IOUtils.closeStream((Closeable)in);
        return document;
    }

    public static byte[] loadBytes(FileSystem fs, Path path) throws IOException {
        int len = (int)fs.getLength(path);
        byte[] data = new byte[len];
        FSDataInputStream in = null;
        in = fs.open(path);
        try {
            in.readFully(0L, data);
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
        return data;
    }

    public static Configuration loadConfiguration(FileSystem fs, Path path) throws IOException {
        byte[] data = ConfigHelper.loadBytes(fs, path);
        ByteArrayInputStream in2 = new ByteArrayInputStream(data);
        Configuration conf1 = new Configuration(false);
        conf1.addResource((InputStream)in2);
        Configuration conf2 = new Configuration(false);
        String src = path.toString();
        for (Map.Entry entry : conf1) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            conf2.set(key, value, src);
        }
        return conf2;
    }

    public static File saveConfig(Configuration generatingConf, File confdir, String filename) throws IOException {
        File destPath = new File(confdir, filename);
        FileOutputStream fos = new FileOutputStream(destPath);
        try {
            generatingConf.writeXml((OutputStream)fos);
        }
        finally {
            IOUtils.closeStream((Closeable)fos);
        }
        return destPath;
    }

    public static Document parseConfigXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setXIncludeAware(true);
        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static Configuration loadConfFromFile(File file) throws IOException {
        return ConfigHelper.loadConfFromFile(file, false);
    }

    public static Configuration loadConfFromFile(File file, boolean loadDefaults) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not found :" + file.getAbsoluteFile());
        }
        Configuration conf = new Configuration(loadDefaults);
        try {
            conf.addResource(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("File " + file.toURI() + " doesn't have a valid URL");
        }
        return conf;
    }

    public static Configuration addConfigurationFile(Configuration conf, File file, boolean overwrite) throws IOException {
        Configuration c2 = ConfigHelper.loadConfFromFile(file, false);
        ConfigHelper.mergeConfigurations(conf, (Iterable<Map.Entry<String, String>>)c2, file.getAbsolutePath(), overwrite);
        return conf;
    }

    public static void addEnvironmentVariables(Configuration conf, String prefix) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            conf.set(String.valueOf(prefix) + entry.getKey(), entry.getValue(), "env");
        }
    }

    public static Configuration loadTemplateConfiguration(Configuration systemConf, Path confdir, String templateFilename, String fallbackResource) throws IOException {
        FileSystem fs = FileSystem.get((URI)confdir.toUri(), (Configuration)systemConf);
        Path templatePath = new Path(confdir, templateFilename);
        return ConfigHelper.loadTemplateConfiguration(fs, templatePath, fallbackResource);
    }

    public static Configuration loadTemplateConfiguration(FileSystem fs, Path templatePath, String fallbackResource) throws IOException {
        String origin;
        Configuration conf;
        if (fs.exists(templatePath)) {
            log.debug("Loading template configuration {}", (Object)templatePath);
            conf = ConfigHelper.loadConfiguration(fs, templatePath);
            origin = templatePath.toString();
        } else {
            if (fallbackResource.isEmpty()) {
                throw new FileNotFoundException("No config file found at " + templatePath);
            }
            log.debug("Template {} not found -reverting to classpath resource {}", (Object)templatePath, (Object)fallbackResource);
            conf = new Configuration(false);
            conf.addResource(fallbackResource);
            origin = "Resource " + fallbackResource;
        }
        conf.get("slider.template.origin");
        conf.set("slider.template.origin", origin);
        return conf;
    }

    public static String dumpConfigToString(Configuration conf) {
        Set<String> sorted = ConfigHelper.sortedConfigKeys((Iterable<Map.Entry<String, String>>)conf);
        StringBuilder builder = new StringBuilder();
        for (String key : sorted) {
            builder.append(key).append("=").append(conf.get(key)).append("\n");
        }
        return builder.toString();
    }

    public static Configuration mergeConfigurations(Configuration base, Iterable<Map.Entry<String, String>> merge, String origin, boolean overwrite) {
        for (Map.Entry<String, String> entry : merge) {
            String key = entry.getKey();
            if (!overwrite && base.get(key) != null) continue;
            base.set(key, entry.getValue(), origin);
        }
        return base;
    }

    public static URL registerDefaultResource(String resource) {
        URL resURL = ConfigHelper.getResourceUrl(resource);
        if (resURL != null) {
            Configuration.addDefaultResource((String)resource);
        }
        return resURL;
    }

    public static Configuration loadFromResource(String resource) {
        Configuration conf = new Configuration(false);
        URL resURL = ConfigHelper.getResourceUrl(resource);
        if (resURL != null) {
            log.debug("loaded resources from {}", (Object)resURL);
            conf.addResource(resource);
        } else {
            log.debug("failed to find {} on the classpath", (Object)resource);
        }
        return conf;
    }

    public static URL getResourceUrl(String resource) {
        return ConfigHelper.class.getClassLoader().getResource(resource);
    }

    public static Configuration loadMandatoryResource(String resource) throws FileNotFoundException {
        Configuration conf = new Configuration(false);
        URL resURL = ConfigHelper.getResourceUrl(resource);
        if (resURL == null) {
            throw new FileNotFoundException(resource);
        }
        log.debug("loaded resources from {}", (Object)resURL);
        conf.addResource(resource);
        return conf;
    }

    public static boolean propagate(Configuration dest, Configuration src, String key) {
        String val = src.get(key);
        if (val != null) {
            String[] origin = src.getPropertySources(key);
            if (origin != null && origin.length > 0) {
                dest.set(key, val, origin[0]);
            } else {
                dest.set(key, val);
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> buildMapFromConfiguration(Configuration conf) {
        HashMap<String, String> map = new HashMap<String, String>();
        return SliderUtils.mergeEntries(map, (Iterable<Map.Entry<String, String>>)conf);
    }

    public static Configuration resolveConfiguration(Iterable<Map.Entry<String, String>> keysource, Configuration valuesource) {
        Configuration result = new Configuration(false);
        for (Map.Entry<String, String> entry : keysource) {
            String key = entry.getKey();
            String value = valuesource.get(key);
            Preconditions.checkState(value != null, "no reference for \"%s\" in values", key);
            result.set(key, value);
        }
        return result;
    }

    public static void registerDeprecatedConfigItems() {
        Configuration.addDeprecation((String)"slider.zookeeper.quorum", (String)"hadoop.registry.zk.quorum");
        Configuration.addDeprecation((String)"slider.registry.path", (String)"hadoop.registry.zk.root");
    }

    public static Configuration loadSliderConfiguration() {
        Configuration conf = new Configuration();
        conf.addResource("org/apache/slider/slider.xml");
        return conf;
    }

    public static synchronized boolean injectSliderXMLResource() {
        if (sliderResourceInjectionAttempted.getAndSet(true)) {
            return sliderResourceInjected.get();
        }
        URL resourceUrl = ConfigHelper.getResourceUrl("org/apache/slider/slider.xml");
        if (resourceUrl != null) {
            Configuration.addDefaultResource((String)"org/apache/slider/slider.xml");
            sliderResourceInjected.set(true);
        }
        return sliderResourceInjected.get();
    }
}

