/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.common.params;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.params.ArgOps;
import org.apache.slider.common.params.Arguments;
import org.apache.slider.common.params.PathArgumentConverter;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.UsageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionArgs
extends ArgOps
implements Arguments {
    protected static final Logger log = LoggerFactory.getLogger(AbstractActionArgs.class);
    @Parameter(names={"--fs", "--filesystem"}, description="Filesystem Binding")
    public String filesystemBinding;
    @Parameter(names={"--basepath"}, description="Slider base path on the filesystem", converter=PathArgumentConverter.class)
    public Path basePath;
    @Parameter
    public final List<String> parameters = new ArrayList<String>();
    @Parameter(names={"-D"}, arity=1, description="Definitions")
    public final List<String> definitions = new ArrayList<String>();
    @Parameter(names={"-S"}, arity=1, description="system properties in the form name value These are set after the JVM is started.")
    public final List<String> sysprops = new ArrayList<String>(0);
    @Parameter(names={"--m", "--manager"}, description="Binding (usually hostname:port) of the YARN resource manager")
    public String manager;
    @Parameter(names={"--debug"}, description="Debug mode")
    public boolean debug = false;
    @Parameter(names={"--help"}, description="Help", help=true)
    public boolean help = false;

    protected AbstractActionArgs() {
    }

    public String getClusterName() {
        return this.parameters.isEmpty() ? null : this.parameters.get(0);
    }

    public int getMinParams() {
        return 1;
    }

    public abstract String getActionName();

    public int getMaxParams() {
        return this.getMinParams();
    }

    public void validate() throws BadCommandArgumentsException, UsageException {
        int actionArgSize;
        int minArgs = this.getMinParams();
        if (minArgs > (actionArgSize = this.parameters.size())) {
            throw new BadCommandArgumentsException("Not enough arguments for action: " + this.getActionName() + " Expected minimum " + minArgs + " but got " + actionArgSize, new Object[0]);
        }
        int maxArgs = this.getMaxParams();
        if (maxArgs == -1) {
            maxArgs = minArgs;
        }
        if (actionArgSize > maxArgs) {
            String message = String.format("%s for action %s: limit is %d but saw %d: ", "Too many arguments", this.getActionName(), maxArgs, actionArgSize);
            log.error(message);
            int index = 1;
            for (String actionArg : this.parameters) {
                log.error("[{}] \"{}\"", (Object)index++, (Object)actionArg);
                message = String.valueOf(message) + " \"" + actionArg + "\" ";
            }
            throw new BadCommandArgumentsException(message, new Object[0]);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.getActionName();
    }

    public boolean getHadoopServicesRequired() {
        return true;
    }

    public boolean disableSecureLogin() {
        return false;
    }
}

