/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.api.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ComponentInformation {
    public String name;
    public int priority;
    public int desired;
    public int actual;
    public int releasing;
    public int placementPolicy;
    public int requested;
    public int failed;
    public int started;
    public int startFailed;
    public int completed;
    public int totalRequested;
    public int nodeFailed;
    public int failedRecently;
    public int preempted;
    public int pendingAntiAffineRequestCount;
    public boolean isAARequestOutstanding;
    public String failureMessage;
    public List<String> containers;

    public Map<String, Integer> buildStatistics() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        stats.put("containers.active.requests", this.requested);
        stats.put("containers.anti-affine.pending", this.pendingAntiAffineRequestCount);
        stats.put("containers.completed", this.completed);
        stats.put("containers.desired", this.desired);
        stats.put("containers.failed", this.failed);
        stats.put("containers.failed.node", this.nodeFailed);
        stats.put("containers.failed.recently", this.failedRecently);
        stats.put("containers.live", this.actual);
        stats.put("containers.failed.preempted", this.preempted);
        stats.put("containers.requested", this.totalRequested);
        stats.put("containers.start.started", this.started);
        stats.put("containers.start.failed", this.startFailed);
        return stats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ComponentInformation{");
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", actual=").append(this.actual);
        sb.append(", completed=").append(this.completed);
        sb.append(", desired=").append(this.desired);
        sb.append(", failed=").append(this.failed);
        sb.append(", failureMessage='").append(this.failureMessage).append('\'');
        sb.append(", placementPolicy=").append(this.placementPolicy);
        sb.append(", isAARequestOutstanding=").append(this.isAARequestOutstanding);
        sb.append(", pendingAntiAffineRequestCount=").append(this.pendingAntiAffineRequestCount);
        sb.append(", priority=").append(this.priority);
        sb.append(", releasing=").append(this.releasing);
        sb.append(", requested=").append(this.requested);
        sb.append(", started=").append(this.started);
        sb.append(", startFailed=").append(this.startFailed);
        sb.append(", totalRequested=").append(this.totalRequested);
        sb.append(", container count='").append(this.containers == null ? 0 : this.containers.size()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

