/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.List;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class InsertEvent
extends ListenerEvent {
    private final Table tableObj;
    private final Partition ptnObj;
    private final boolean replace;
    private final List<String> files;

    public InsertEvent(String db, String table, List<String> partVals, InsertEventRequestData insertData, boolean status, HiveMetaStore.HMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        this.replace = insertData.isSetReplace() ? insertData.isReplace() : true;
        this.files = insertData.getFilesAdded();
        try {
            this.tableObj = handler.get_table(db, table);
            this.ptnObj = partVals != null ? handler.get_partition(db, table, partVals) : null;
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw MetaStoreUtils.newMetaException(e);
        }
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.ptnObj;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<String> getFiles() {
        return this.files;
    }
}

