/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;

public class TableIterable
implements Iterable<Table> {
    private final IMetaStoreClient msc;
    private final String dbname;
    private final List<String> tableNames;
    private final int batch_size;

    @Override
    public Iterator<Table> iterator() {
        return new Iterator<Table>(){
            private final Iterator<String> tableNamesIter;
            private Iterator<Table> batchIter;
            {
                this.tableNamesIter = TableIterable.this.tableNames.iterator();
                this.batchIter = null;
            }

            @Override
            public boolean hasNext() {
                return this.batchIter != null && this.batchIter.hasNext() || this.tableNamesIter.hasNext();
            }

            @Override
            public Table next() {
                if (this.batchIter == null || !this.batchIter.hasNext()) {
                    this.getNextBatch();
                }
                return this.batchIter.next();
            }

            private void getNextBatch() {
                ArrayList<String> nameBatch = new ArrayList<String>();
                for (int batch_counter = 0; batch_counter < TableIterable.this.batch_size && this.tableNamesIter.hasNext(); ++batch_counter) {
                    nameBatch.add(this.tableNamesIter.next());
                }
                try {
                    this.batchIter = TableIterable.this.msc.getTableObjectsByName(TableIterable.this.dbname, nameBatch).iterator();
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new IllegalStateException("TableIterable is a read-only iterable and remove() is unsupported");
            }
        };
    }

    public TableIterable(IMetaStoreClient msc, String dbname, List<String> tableNames, int batch_size) throws TException {
        this.msc = msc;
        this.dbname = dbname;
        this.tableNames = tableNames;
        this.batch_size = batch_size;
    }
}

