/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.spark-project.org.eclipse.jetty.util.QuotedStringTokenizer;
import org.apache.spark-project.org.eclipse.jetty.util.TypeUtil;
import org.apache.spark-project.org.eclipse.jetty.util.log.Log;
import org.apache.spark-project.org.eclipse.jetty.util.log.Logger;

public class StringUtil {
    private static final Logger LOG = Log.getLogger(StringUtil.class);
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    public static final String __LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    public static final String __ISO_8859_1 = "ISO-8859-1";
    public static final String __UTF8 = "UTF-8";
    public static final String __UTF8Alt = "UTF8";
    public static final String __UTF16 = "UTF-16";
    public static final Charset __UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset __ISO_8859_1_CHARSET = Charset.forName("ISO-8859-1");
    private static char[] lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};

    public static String asciiToLowerCase(String s) {
        char[] c = null;
        int i = s.length();
        while (i-- > 0) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 > '\u007f' || c1 == (c2 = lowercases[c1])) continue;
            c = s.toCharArray();
            c[i] = c2;
            break;
        }
        while (i-- > 0) {
            if (c[i] > 127) continue;
            c[i] = lowercases[c[i]];
        }
        return c == null ? s : new String(c);
    }

    public static boolean startsWithIgnoreCase(String s, String w) {
        if (w == null) {
            return true;
        }
        if (s == null || s.length() < w.length()) {
            return false;
        }
        for (int i = 0; i < w.length(); ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s, String w) {
        int wl;
        if (w == null) {
            return true;
        }
        if (s == null) {
            return false;
        }
        int sl = s.length();
        if (sl < (wl = w.length())) {
            return false;
        }
        int i = wl;
        while (i-- > 0) {
            char c2;
            char c1;
            if ((c1 = s.charAt(--sl)) == (c2 = w.charAt(i))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s, String chars) {
        for (int i = 0; i < s.length(); ++i) {
            if (chars.indexOf(s.charAt(i)) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String replace(String s, String sub, String with) {
        int c = 0;
        int i = s.indexOf(sub, c);
        if (i == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length() + with.length());
        do {
            buf.append(s.substring(c, i));
            buf.append(with);
        } while ((i = s.indexOf(sub, c = i + sub.length())) != -1);
        if (c < s.length()) {
            buf.append(s.substring(c, s.length()));
        }
        return buf.toString();
    }

    public static String unquote(String s) {
        return QuotedStringTokenizer.unquote(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuilder buf, String s, int offset, int length) {
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int end = offset + length;
            for (int i = offset; i < end && i < s.length(); ++i) {
                buf.append(s.charAt(i));
            }
        }
    }

    public static void append(StringBuilder buf, byte b, int base) {
        int bi = 0xFF & b;
        int c = 48 + bi / base % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
        c = 48 + bi % base;
        if (c > 57) {
            c = 97 + (c - 48 - 10);
        }
        buf.append((char)c);
    }

    public static void append2digits(StringBuffer buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public static void append2digits(StringBuilder buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public static String nonNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static boolean equals(String s, char[] buf, int offset, int length) {
        if (s.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (buf[offset + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] b, int offset, int length) {
        try {
            return new String(b, offset, length, __UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(byte[] b, int offset, int length, String charset) {
        try {
            return new String(b, offset, length, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isUTF8(String charset) {
        return __UTF8.equalsIgnoreCase(charset) || __UTF8Alt.equalsIgnoreCase(charset);
    }

    public static String printable(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isISOControl(c)) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String printable(byte[] b) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            char c = (char)b[i];
            if (Character.isWhitespace(c) || c > ' ' && c < '\u007f') {
                buf.append(c);
                continue;
            }
            buf.append("0x");
            TypeUtil.toHex(b[i], buf);
        }
        return buf.toString();
    }

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes(__ISO_8859_1);
        }
        catch (Exception e) {
            LOG.warn(e);
            return s.getBytes();
        }
    }

    public static byte[] getBytes(String s, String charset) {
        try {
            return s.getBytes(charset);
        }
        catch (Exception e) {
            LOG.warn(e);
            return s.getBytes();
        }
    }

    public static String sidBytesToString(byte[] sidBytes) {
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(Byte.toString(sidBytes[0])).append('-');
        StringBuilder tmpBuilder = new StringBuilder();
        for (int i = 2; i <= 7; ++i) {
            tmpBuilder.append(Integer.toHexString(sidBytes[i] & 0xFF));
        }
        sidString.append(Long.parseLong(tmpBuilder.toString(), 16));
        int subAuthorityCount = sidBytes[1];
        for (int i = 0; i < subAuthorityCount; ++i) {
            int offset = i * 4;
            tmpBuilder.setLength(0);
            tmpBuilder.append(String.format("%02X%02X%02X%02X", sidBytes[11 + offset] & 0xFF, sidBytes[10 + offset] & 0xFF, sidBytes[9 + offset] & 0xFF, sidBytes[8 + offset] & 0xFF));
            sidString.append('-').append(Long.parseLong(tmpBuilder.toString(), 16));
        }
        return sidString.toString();
    }

    public static byte[] sidStringToBytes(String sidString) {
        int i;
        String[] sidTokens = sidString.split("-");
        int subAuthorityCount = sidTokens.length - 3;
        int byteCount = 0;
        byte[] sidBytes = new byte[8 + 4 * subAuthorityCount];
        sidBytes[byteCount++] = (byte)Integer.parseInt(sidTokens[1]);
        sidBytes[byteCount++] = (byte)subAuthorityCount;
        String hexStr = Long.toHexString(Long.parseLong(sidTokens[2]));
        while (hexStr.length() < 12) {
            hexStr = "0" + hexStr;
        }
        for (i = 0; i < hexStr.length(); i += 2) {
            sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(i, i + 2), 16);
        }
        for (i = 3; i < sidTokens.length; ++i) {
            hexStr = Long.toHexString(Long.parseLong(sidTokens[i]));
            while (hexStr.length() < 8) {
                hexStr = "0" + hexStr;
            }
            for (int j = hexStr.length(); j > 0; j -= 2) {
                sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(j - 2, j), 16);
            }
        }
        return sidBytes;
    }
}

