/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.apache.spark-project.org.eclipse.jetty.server.Handler;
import org.apache.spark-project.org.eclipse.jetty.server.Server;
import org.apache.spark-project.org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.apache.spark-project.org.eclipse.jetty.util.log.Log;
import org.apache.spark-project.org.eclipse.jetty.util.log.Logger;

public abstract class AbstractHandler
extends AggregateLifeCycle
implements Handler {
    private static final Logger LOG = Log.getLogger(AbstractHandler.class);
    private Server _server;

    protected void doStart() throws Exception {
        LOG.debug("starting {}", this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        LOG.debug("stopping {}", this);
        super.doStop();
    }

    public void setServer(Server server) {
        Server old_server = this._server;
        if (old_server != null && old_server != server) {
            old_server.getContainer().removeBean(this);
        }
        this._server = server;
        if (this._server != null && this._server != old_server) {
            this._server.getContainer().addBean(this);
        }
    }

    public Server getServer() {
        return this._server;
    }

    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        super.destroy();
        if (this._server != null) {
            this._server.getContainer().removeBean(this);
        }
    }

    public void dumpThis(Appendable out) throws IOException {
        out.append(this.toString()).append(" - ").append(this.getState()).append('\n');
    }
}

