/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.service.cli.operation;

import org.apache.spark-project.org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.spark-project.org.apache.hive.service.cli.FetchOrientation;
import org.apache.spark-project.org.apache.hive.service.cli.HiveSQLException;
import org.apache.spark-project.org.apache.hive.service.cli.OperationState;
import org.apache.spark-project.org.apache.hive.service.cli.OperationType;
import org.apache.spark-project.org.apache.hive.service.cli.RowSet;
import org.apache.spark-project.org.apache.hive.service.cli.RowSetFactory;
import org.apache.spark-project.org.apache.hive.service.cli.TableSchema;
import org.apache.spark-project.org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.spark-project.org.apache.hive.service.cli.session.HiveSession;

public class GetCatalogsOperation
extends MetadataOperation {
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_CAT", "Catalog name. NULL if not applicable.");
    private final RowSet rowSet = RowSetFactory.create(RESULT_SET_SCHEMA, this.getProtocolVersion());

    protected GetCatalogsOperation(HiveSession parentSession) {
        super(parentSession, OperationType.GET_CATALOGS);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            if (this.isAuthV2Enabled()) {
                this.authorizeMetaGets(HiveOperationType.GET_CATALOGS, null);
            }
            this.setState(OperationState.FINISHED);
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

