/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.service.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.spark-project.org.apache.hive.service.cli.Column;
import org.apache.spark-project.org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.spark-project.org.apache.hive.service.cli.RowSet;
import org.apache.spark-project.org.apache.hive.service.cli.TableSchema;
import org.apache.spark-project.org.apache.hive.service.cli.Type;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TColumn;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TRow;
import org.apache.spark-project.org.apache.hive.service.cli.thrift.TRowSet;

public class ColumnBasedSet
implements RowSet {
    private long startOffset;
    private final Type[] types;
    private final List<Column> columns;

    public ColumnBasedSet(TableSchema schema) {
        this.types = schema.toTypes();
        this.columns = new ArrayList<Column>();
        for (ColumnDescriptor colDesc : schema.getColumnDescriptors()) {
            this.columns.add(new Column(colDesc.getType()));
        }
    }

    public ColumnBasedSet(TRowSet tRowSet) {
        this.types = null;
        this.columns = new ArrayList<Column>();
        for (TColumn tvalue : tRowSet.getColumns()) {
            this.columns.add(new Column(tvalue));
        }
        this.startOffset = tRowSet.getStartRowOffset();
    }

    private ColumnBasedSet(Type[] types, List<Column> columns, long startOffset) {
        this.types = types;
        this.columns = columns;
        this.startOffset = startOffset;
    }

    @Override
    public ColumnBasedSet addRow(Object[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            this.columns.get(i).addValue(this.types[i], fields[i]);
        }
        return this;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public int numColumns() {
        return this.columns.size();
    }

    @Override
    public int numRows() {
        return this.columns.isEmpty() ? 0 : this.columns.get(0).size();
    }

    @Override
    public ColumnBasedSet extractSubset(int maxRows) {
        int numRows = Math.min(this.numRows(), maxRows);
        ArrayList<Column> subset = new ArrayList<Column>();
        for (int i = 0; i < this.columns.size(); ++i) {
            subset.add(this.columns.get(i).extractSubset(0, numRows));
        }
        ColumnBasedSet result = new ColumnBasedSet(this.types, subset, this.startOffset);
        this.startOffset += (long)numRows;
        return result;
    }

    @Override
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    @Override
    public TRowSet toTRowSet() {
        TRowSet tRowSet = new TRowSet(this.startOffset, new ArrayList<TRow>());
        for (int i = 0; i < this.columns.size(); ++i) {
            tRowSet.addToColumns(this.columns.get(i).toTColumn());
        }
        return tRowSet;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return new Iterator<Object[]>(){
            private int index;
            private final Object[] convey;
            {
                this.convey = new Object[ColumnBasedSet.this.numColumns()];
            }

            @Override
            public boolean hasNext() {
                return this.index < ColumnBasedSet.this.numRows();
            }

            @Override
            public Object[] next() {
                for (int i = 0; i < ColumnBasedSet.this.columns.size(); ++i) {
                    this.convey[i] = ((Column)ColumnBasedSet.this.columns.get(i)).get(this.index);
                }
                ++this.index;
                return this.convey;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public Object[] fill(int index, Object[] convey) {
        for (int i = 0; i < this.columns.size(); ++i) {
            convey[i] = this.columns.get(i).get(index);
        }
        return convey;
    }
}

