/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CookieSigner {
    private static final String SIGNATURE = "&s=";
    private static final String SHA_STRING = "SHA";
    private byte[] secretBytes;
    private static final Log LOG = LogFactory.getLog(CookieSigner.class);

    public CookieSigner(byte[] secret) {
        if (secret == null) {
            throw new IllegalArgumentException(" NULL Secret Bytes");
        }
        this.secretBytes = (byte[])secret.clone();
    }

    public String signCookie(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        String signature = this.getSignature(str);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature generated for " + str + " is " + signature);
        }
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) {
        int index = signedStr.lastIndexOf(SIGNATURE);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid input sign: " + signedStr);
        }
        String originalSignature = signedStr.substring(index + SIGNATURE.length());
        String rawValue = signedStr.substring(0, index);
        String currentSignature = this.getSignature(rawValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature generated for " + rawValue + " inside verify is " + currentSignature);
        }
        if (!originalSignature.equals(currentSignature)) {
            throw new IllegalArgumentException("Invalid sign, original = " + originalSignature + " current = " + currentSignature);
        }
        return rawValue;
    }

    private String getSignature(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_STRING);
            md.update(str.getBytes());
            md.update(this.secretBytes);
            byte[] digest = md.digest();
            return new Base64(0).encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Invalid SHA digest String: SHA " + ex.getMessage(), ex);
        }
    }
}

