/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hive.jdbc;

import java.util.Map;
import org.apache.spark-project.org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.spark-project.org.apache.http.Header;
import org.apache.spark-project.org.apache.http.HttpRequest;
import org.apache.spark-project.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.spark-project.org.apache.http.client.CookieStore;
import org.apache.spark-project.org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.spark-project.org.apache.http.impl.auth.BasicScheme;
import org.apache.spark-project.org.apache.http.protocol.HttpContext;

public class HttpBasicAuthInterceptor
extends HttpRequestInterceptorBase {
    UsernamePasswordCredentials credentials;
    AuthSchemeBase authScheme = new BasicScheme();

    public HttpBasicAuthInterceptor(String username, String password, CookieStore cookieStore, String cn, boolean isSSL, Map<String, String> additionalHeaders) {
        super(cookieStore, cn, isSSL, additionalHeaders);
        if (username != null) {
            this.credentials = new UsernamePasswordCredentials(username, password);
        }
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        Header basicAuthHeader = this.authScheme.authenticate(this.credentials, httpRequest, httpContext);
        httpRequest.addHeader(basicAuthHeader);
    }
}

