/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.SerDeStatsStruct;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryNonPrimitive;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryObject;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryUnionObjectInspector;

public class LazyBinaryUnion
extends LazyBinaryNonPrimitive<LazyBinaryUnionObjectInspector>
implements SerDeStatsStruct {
    private static Log LOG = LogFactory.getLog(LazyBinaryUnion.class.getName());
    boolean parsed;
    long serializedSize;
    LazyBinaryObject field;
    boolean fieldInited;
    int fieldStart;
    int fieldLength;
    byte tag;
    final LazyBinaryUtils.VInt vInt = new LazyBinaryUtils.VInt();
    LazyBinaryUtils.RecordInfo recordInfo = new LazyBinaryUtils.RecordInfo();
    boolean missingFieldWarned = false;
    boolean extraFieldWarned = false;
    Object cachedObject;

    protected LazyBinaryUnion(LazyBinaryUnionObjectInspector oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        this.parsed = false;
        this.serializedSize = length;
        this.fieldInited = false;
        this.field = null;
        this.cachedObject = null;
    }

    private void parse() {
        LazyBinaryUnionObjectInspector uoi = (LazyBinaryUnionObjectInspector)this.oi;
        int unionByteEnd = this.start + this.length;
        byte[] byteArr = this.bytes.getData();
        int tagEnd = this.start + 1;
        this.tag = byteArr[this.start];
        this.field = LazyBinaryFactory.createLazyBinaryObject(uoi.getObjectInspectors().get(this.tag));
        LazyBinaryUtils.checkObjectByteInfo(uoi.getObjectInspectors().get(this.tag), byteArr, tagEnd, this.recordInfo, this.vInt);
        this.fieldStart = tagEnd + this.recordInfo.elementOffset;
        this.fieldLength = this.recordInfo.elementSize;
        if (!this.extraFieldWarned && this.fieldStart + this.fieldLength < unionByteEnd) {
            this.extraFieldWarned = true;
            LOG.warn("Extra bytes detected at the end of the row! Ignoring similar problems.");
        }
        if (!this.missingFieldWarned && this.fieldStart + this.fieldLength > unionByteEnd) {
            this.missingFieldWarned = true;
            LOG.info("Missing fields! Expected 1 fields but only got " + this.field + "! Ignoring similar problems.");
        }
        this.parsed = true;
    }

    public Object getField() {
        if (!this.parsed) {
            this.parse();
        }
        if (this.cachedObject == null) {
            return this.uncheckedGetField();
        }
        return this.cachedObject;
    }

    private Object uncheckedGetField() {
        if (!this.fieldInited) {
            this.fieldInited = true;
            this.field.init(this.bytes, this.fieldStart, this.fieldLength);
        }
        this.cachedObject = this.field.getObject();
        return this.field.getObject();
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public long getRawDataSerializedSize() {
        return this.serializedSize;
    }

    public byte getTag() {
        if (!this.parsed) {
            this.parse();
        }
        return this.tag;
    }
}

