/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hadoop.hive.serde2.lazy;

import org.apache.hadoop.io.Text;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.spark-project.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class LazyNonPrimitive<OI extends ObjectInspector>
extends LazyObject<OI> {
    protected ByteArrayRef bytes = null;
    protected int start = 0;
    protected int length = 0;

    protected LazyNonPrimitive(OI oi) {
        super(oi);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        super.init(bytes, start, length);
        this.bytes = bytes;
        this.start = start;
        this.length = length;
        assert (start >= 0);
        assert (start + length <= bytes.getData().length);
    }

    protected final boolean isNull(Text nullSequence, ByteArrayRef ref, int fieldByteBegin, int fieldLength) {
        return ref == null || this.isNull(nullSequence, ref.getData(), fieldByteBegin, fieldLength);
    }

    protected final boolean isNull(Text nullSequence, byte[] bytes, int fieldByteBegin, int fieldLength) {
        return fieldLength < 0 || fieldLength == nullSequence.getLength() && LazyUtils.compare(bytes, fieldByteBegin, fieldLength, nullSequence.getBytes(), 0, nullSequence.getLength()) == 0;
    }

    @Override
    public int hashCode() {
        return LazyUtils.hashBytes(this.bytes.getData(), this.start, this.length);
    }
}

