/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.hadoop.hive.metastore;

public class ProtectMode {
    public static String PARAMETER_NAME = "PROTECT_MODE";
    public static String FLAG_OFFLINE = "OFFLINE";
    public static String FLAG_NO_DROP = "NO_DROP";
    public static String FLAG_NO_DROP_CASCADE = "NO_DROP_CASCADE";
    public static String FLAG_READ_ONLY = "READ_ONLY";
    public boolean offline = false;
    public boolean readOnly = false;
    public boolean noDrop = false;
    public boolean noDropCascade = false;

    public static ProtectMode getProtectModeFromString(String sourceString) {
        return new ProtectMode(sourceString);
    }

    private ProtectMode(String sourceString) {
        String[] tokens;
        for (String token : tokens = sourceString.split(",")) {
            if (token.equalsIgnoreCase(FLAG_OFFLINE)) {
                this.offline = true;
                continue;
            }
            if (token.equalsIgnoreCase(FLAG_NO_DROP)) {
                this.noDrop = true;
                continue;
            }
            if (token.equalsIgnoreCase(FLAG_NO_DROP_CASCADE)) {
                this.noDropCascade = true;
                continue;
            }
            if (!token.equalsIgnoreCase(FLAG_READ_ONLY)) continue;
            this.readOnly = true;
        }
    }

    public ProtectMode() {
    }

    public String toString() {
        String retString = null;
        if (this.offline) {
            retString = FLAG_OFFLINE;
        }
        if (this.noDrop) {
            retString = retString != null ? retString + "," + FLAG_NO_DROP : FLAG_NO_DROP;
        }
        if (this.noDropCascade) {
            retString = retString != null ? retString + "," + FLAG_NO_DROP_CASCADE : FLAG_NO_DROP_CASCADE;
        }
        if (this.readOnly) {
            retString = retString != null ? retString + "," + FLAG_READ_ONLY : FLAG_READ_ONLY;
        }
        return retString;
    }
}

