/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark-project.org.apache.avro.generic;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.spark-project.org.apache.avro.AvroRuntimeException;
import org.apache.spark-project.org.apache.avro.AvroTypeException;
import org.apache.spark-project.org.apache.avro.Schema;
import org.apache.spark-project.org.apache.avro.UnresolvedUnionException;
import org.apache.spark-project.org.apache.avro.generic.GenericArray;
import org.apache.spark-project.org.apache.avro.generic.GenericContainer;
import org.apache.spark-project.org.apache.avro.generic.GenericDatumReader;
import org.apache.spark-project.org.apache.avro.generic.GenericDatumWriter;
import org.apache.spark-project.org.apache.avro.generic.GenericEnumSymbol;
import org.apache.spark-project.org.apache.avro.generic.GenericFixed;
import org.apache.spark-project.org.apache.avro.generic.GenericRecord;
import org.apache.spark-project.org.apache.avro.generic.IndexedRecord;
import org.apache.spark-project.org.apache.avro.io.BinaryData;
import org.apache.spark-project.org.apache.avro.io.BinaryDecoder;
import org.apache.spark-project.org.apache.avro.io.BinaryEncoder;
import org.apache.spark-project.org.apache.avro.io.DatumReader;
import org.apache.spark-project.org.apache.avro.io.DatumWriter;
import org.apache.spark-project.org.apache.avro.io.DecoderFactory;
import org.apache.spark-project.org.apache.avro.io.EncoderFactory;
import org.apache.spark-project.org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import org.apache.spark-project.org.apache.avro.util.Utf8;
import org.apache.spark-project.org.codehaus.jackson.JsonNode;

public class GenericData {
    private static final GenericData INSTANCE = new GenericData();
    protected static final String STRING_PROP = "avro.java.string";
    protected static final String STRING_TYPE_STRING = "String";
    private final ClassLoader classLoader;
    private final Map<Schema.Field, Object> defaultValueCache = Collections.synchronizedMap(new WeakHashMap());
    private static final Schema STRINGS = Schema.create(Schema.Type.STRING);

    public static void setStringType(Schema s, StringType stringType) {
        if (stringType == StringType.String) {
            s.addProp(STRING_PROP, STRING_TYPE_STRING);
        }
    }

    public static GenericData get() {
        return INSTANCE;
    }

    public GenericData() {
        this(null);
    }

    public GenericData(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DatumReader createDatumReader(Schema schema) {
        return new GenericDatumReader(schema, schema, this);
    }

    public DatumReader createDatumReader(Schema writer, Schema reader) {
        return new GenericDatumReader(writer, reader, this);
    }

    public DatumWriter createDatumWriter(Schema schema) {
        return new GenericDatumWriter(schema, this);
    }

    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                for (Schema.Field f : schema.getFields()) {
                    if (this.validate(f.schema(), this.getField(datum, f.name(), f.pos()))) continue;
                    return false;
                }
                return true;
            }
            case ENUM: {
                return schema.getEnumSymbols().contains(datum.toString());
            }
            case ARRAY: {
                if (!this.isArray(datum)) {
                    return false;
                }
                for (Object element : (Collection)datum) {
                    if (this.validate(schema.getElementType(), element)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                if (!this.isMap(datum)) {
                    return false;
                }
                Map map = (Map)datum;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.validate(schema.getValueType(), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                for (Schema type : schema.getTypes()) {
                    if (!this.validate(type, datum)) continue;
                    return true;
                }
                return false;
            }
            case FIXED: {
                return datum instanceof GenericFixed && ((GenericFixed)datum).bytes().length == schema.getFixedSize();
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return this.isInteger(datum);
            }
            case LONG: {
                return this.isLong(datum);
            }
            case FLOAT: {
                return this.isFloat(datum);
            }
            case DOUBLE: {
                return this.isDouble(datum);
            }
            case BOOLEAN: {
                return this.isBoolean(datum);
            }
            case NULL: {
                return datum == null;
            }
        }
        return false;
    }

    public String toString(Object datum) {
        StringBuilder buffer = new StringBuilder();
        this.toString(datum, buffer);
        return buffer.toString();
    }

    protected void toString(Object datum, StringBuilder buffer) {
        if (this.isRecord(datum)) {
            buffer.append("{");
            int count = 0;
            Schema schema = this.getRecordSchema(datum);
            for (Schema.Field f : schema.getFields()) {
                this.toString(f.name(), buffer);
                buffer.append(": ");
                this.toString(this.getField(datum, f.name(), f.pos()), buffer);
                if (++count >= schema.getFields().size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
        } else if (this.isArray(datum)) {
            Collection array = (Collection)datum;
            buffer.append("[");
            long last = array.size() - 1;
            int i = 0;
            for (Object element : array) {
                this.toString(element, buffer);
                if ((long)i++ >= last) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        } else if (this.isMap(datum)) {
            buffer.append("{");
            int count = 0;
            Map map = (Map)datum;
            for (Map.Entry entry : map.entrySet()) {
                this.toString(entry.getKey(), buffer);
                buffer.append(": ");
                this.toString(entry.getValue(), buffer);
                if (++count >= map.size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
        } else if (this.isString(datum) || this.isEnum(datum)) {
            buffer.append("\"");
            this.writeEscapedString(datum.toString(), buffer);
            buffer.append("\"");
        } else if (this.isBytes(datum)) {
            buffer.append("{\"bytes\": \"");
            ByteBuffer bytes = (ByteBuffer)datum;
            for (int i = bytes.position(); i < bytes.limit(); ++i) {
                buffer.append((char)bytes.get(i));
            }
            buffer.append("\"}");
        } else {
            buffer.append(datum);
        }
    }

    private void writeEscapedString(String string, StringBuilder builder) {
        block10: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\"': {
                    builder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    builder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block10;
                }
                case '/': {
                    builder.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String hex = Integer.toHexString(ch);
                        builder.append("\\u");
                        for (int j = 0; j < 4 - hex.length(); ++j) {
                            builder.append('0');
                        }
                        builder.append(hex.toUpperCase());
                        continue block10;
                    }
                    builder.append(ch);
                }
            }
        }
    }

    public Schema induce(Object datum) {
        if (this.isRecord(datum)) {
            return this.getRecordSchema(datum);
        }
        if (this.isArray(datum)) {
            Schema elementType = null;
            for (Object element : (Collection)datum) {
                if (elementType == null) {
                    elementType = this.induce(element);
                    continue;
                }
                if (elementType.equals(this.induce(element))) continue;
                throw new AvroTypeException("No mixed type arrays.");
            }
            if (elementType == null) {
                throw new AvroTypeException("Empty array: " + datum);
            }
            return Schema.createArray(elementType);
        }
        if (this.isMap(datum)) {
            Map map = (Map)datum;
            Schema value = null;
            for (Map.Entry entry : map.entrySet()) {
                if (value == null) {
                    value = this.induce(entry.getValue());
                    continue;
                }
                if (value.equals(this.induce(entry.getValue()))) continue;
                throw new AvroTypeException("No mixed type map values.");
            }
            if (value == null) {
                throw new AvroTypeException("Empty map: " + datum);
            }
            return Schema.createMap(value);
        }
        if (datum instanceof GenericFixed) {
            return Schema.createFixed(null, null, null, ((GenericFixed)datum).bytes().length);
        }
        if (this.isString(datum)) {
            return Schema.create(Schema.Type.STRING);
        }
        if (this.isBytes(datum)) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (this.isInteger(datum)) {
            return Schema.create(Schema.Type.INT);
        }
        if (this.isLong(datum)) {
            return Schema.create(Schema.Type.LONG);
        }
        if (this.isFloat(datum)) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (this.isDouble(datum)) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (this.isBoolean(datum)) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        if (datum == null) {
            return Schema.create(Schema.Type.NULL);
        }
        throw new AvroTypeException("Can't create schema for: " + datum);
    }

    public void setField(Object record, String name, int position, Object o) {
        ((IndexedRecord)record).put(position, o);
    }

    public Object getField(Object record, String name, int position) {
        return ((IndexedRecord)record).get(position);
    }

    protected Object getRecordState(Object record, Schema schema) {
        return null;
    }

    protected void setField(Object r, String n, int p, Object o, Object state) {
        this.setField(r, n, p, o);
    }

    protected Object getField(Object record, String name, int pos, Object state) {
        return this.getField(record, name, pos);
    }

    public int resolveUnion(Schema union, Object datum) {
        Integer i = union.getIndexNamed(this.getSchemaName(datum));
        if (i != null) {
            return i;
        }
        throw new UnresolvedUnionException(union, datum);
    }

    protected String getSchemaName(Object datum) {
        if (datum == null) {
            return Schema.Type.NULL.getName();
        }
        if (this.isRecord(datum)) {
            return this.getRecordSchema(datum).getFullName();
        }
        if (this.isEnum(datum)) {
            return this.getEnumSchema(datum).getFullName();
        }
        if (this.isArray(datum)) {
            return Schema.Type.ARRAY.getName();
        }
        if (this.isMap(datum)) {
            return Schema.Type.MAP.getName();
        }
        if (this.isFixed(datum)) {
            return this.getFixedSchema(datum).getFullName();
        }
        if (this.isString(datum)) {
            return Schema.Type.STRING.getName();
        }
        if (this.isBytes(datum)) {
            return Schema.Type.BYTES.getName();
        }
        if (this.isInteger(datum)) {
            return Schema.Type.INT.getName();
        }
        if (this.isLong(datum)) {
            return Schema.Type.LONG.getName();
        }
        if (this.isFloat(datum)) {
            return Schema.Type.FLOAT.getName();
        }
        if (this.isDouble(datum)) {
            return Schema.Type.DOUBLE.getName();
        }
        if (this.isBoolean(datum)) {
            return Schema.Type.BOOLEAN.getName();
        }
        throw new AvroRuntimeException("Unknown datum type: " + datum);
    }

    protected boolean instanceOf(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                return schema.getFullName() == null ? this.getRecordSchema(datum).getFullName() == null : schema.getFullName().equals(this.getRecordSchema(datum).getFullName());
            }
            case ENUM: {
                if (!this.isEnum(datum)) {
                    return false;
                }
                return schema.getFullName().equals(this.getEnumSchema(datum).getFullName());
            }
            case ARRAY: {
                return this.isArray(datum);
            }
            case MAP: {
                return this.isMap(datum);
            }
            case FIXED: {
                if (!this.isFixed(datum)) {
                    return false;
                }
                return schema.getFullName().equals(this.getFixedSchema(datum).getFullName());
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return this.isInteger(datum);
            }
            case LONG: {
                return this.isLong(datum);
            }
            case FLOAT: {
                return this.isFloat(datum);
            }
            case DOUBLE: {
                return this.isDouble(datum);
            }
            case BOOLEAN: {
                return this.isBoolean(datum);
            }
            case NULL: {
                return datum == null;
            }
        }
        throw new AvroRuntimeException("Unexpected type: " + schema);
    }

    protected boolean isArray(Object datum) {
        return datum instanceof Collection;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof IndexedRecord;
    }

    protected Schema getRecordSchema(Object record) {
        return ((GenericContainer)record).getSchema();
    }

    protected boolean isEnum(Object datum) {
        return datum instanceof GenericEnumSymbol;
    }

    protected Schema getEnumSchema(Object enu) {
        return ((GenericContainer)enu).getSchema();
    }

    protected boolean isMap(Object datum) {
        return datum instanceof Map;
    }

    protected boolean isFixed(Object datum) {
        return datum instanceof GenericFixed;
    }

    protected Schema getFixedSchema(Object fixed) {
        return ((GenericContainer)fixed).getSchema();
    }

    protected boolean isString(Object datum) {
        return datum instanceof CharSequence;
    }

    protected boolean isBytes(Object datum) {
        return datum instanceof ByteBuffer;
    }

    protected boolean isInteger(Object datum) {
        return datum instanceof Integer;
    }

    protected boolean isLong(Object datum) {
        return datum instanceof Long;
    }

    protected boolean isFloat(Object datum) {
        return datum instanceof Float;
    }

    protected boolean isDouble(Object datum) {
        return datum instanceof Double;
    }

    protected boolean isBoolean(Object datum) {
        return datum instanceof Boolean;
    }

    public int hashCode(Object o, Schema s) {
        if (o == null) {
            return 0;
        }
        int hashCode = 1;
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field f : s.getFields()) {
                    if (f.order() == Schema.Field.Order.IGNORE) continue;
                    hashCode = this.hashCodeAdd(hashCode, this.getField(o, f.name(), f.pos()), f.schema());
                }
                return hashCode;
            }
            case ARRAY: {
                Collection a = (Collection)o;
                Schema elementType = s.getElementType();
                for (Object e : a) {
                    hashCode = this.hashCodeAdd(hashCode, e, elementType);
                }
                return hashCode;
            }
            case UNION: {
                return this.hashCode(o, s.getTypes().get(this.resolveUnion(s, o)));
            }
            case ENUM: {
                return s.getEnumOrdinal(o.toString());
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                return (o instanceof Utf8 ? o : new Utf8(o.toString())).hashCode();
            }
        }
        return o.hashCode();
    }

    protected int hashCodeAdd(int hashCode, Object o, Schema s) {
        return 31 * hashCode + this.hashCode(o, s);
    }

    public int compare(Object o1, Object o2, Schema s) {
        return this.compare(o1, o2, s, false);
    }

    protected int compare(Object o1, Object o2, Schema s, boolean equals) {
        if (o1 == o2) {
            return 0;
        }
        switch (s.getType()) {
            case RECORD: {
                for (Schema.Field f : s.getFields()) {
                    if (f.order() == Schema.Field.Order.IGNORE) continue;
                    int pos = f.pos();
                    String name = f.name();
                    int compare = this.compare(this.getField(o1, name, pos), this.getField(o2, name, pos), f.schema(), equals);
                    if (compare == 0) continue;
                    return f.order() == Schema.Field.Order.DESCENDING ? -compare : compare;
                }
                return 0;
            }
            case ENUM: {
                return s.getEnumOrdinal(o1.toString()) - s.getEnumOrdinal(o2.toString());
            }
            case ARRAY: {
                Collection a1 = (Collection)o1;
                Collection a2 = (Collection)o2;
                Iterator e1 = a1.iterator();
                Iterator e2 = a2.iterator();
                Schema elementType = s.getElementType();
                while (e1.hasNext() && e2.hasNext()) {
                    int compare = this.compare(e1.next(), e2.next(), elementType, equals);
                    if (compare == 0) continue;
                    return compare;
                }
                return e1.hasNext() ? 1 : (e2.hasNext() ? -1 : 0);
            }
            case MAP: {
                if (equals) {
                    return ((Map)o1).equals(o2) ? 0 : 1;
                }
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = this.resolveUnion(s, o1);
                int i2 = this.resolveUnion(s, o2);
                return i1 == i2 ? this.compare(o1, o2, s.getTypes().get(i1), equals) : i1 - i2;
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                Utf8 u1 = o1 instanceof Utf8 ? (Utf8)o1 : new Utf8(o1.toString());
                Utf8 u2 = o2 instanceof Utf8 ? (Utf8)o2 : new Utf8(o2.toString());
                return u1.compareTo(u2);
            }
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public Object getDefaultValue(Schema.Field field) {
        JsonNode json = field.defaultValue();
        if (json == null) {
            throw new AvroRuntimeException("Field " + field + " not set and has no default value");
        }
        if (json.isNull() && (field.schema().getType() == Schema.Type.NULL || field.schema().getType() == Schema.Type.UNION && field.schema().getTypes().get(0).getType() == Schema.Type.NULL)) {
            return null;
        }
        Object defaultValue = this.defaultValueCache.get(field);
        if (defaultValue == null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(baos, null);
                ResolvingGrammarGenerator.encode(encoder, field.schema(), json);
                encoder.flush();
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(baos.toByteArray(), null);
                defaultValue = this.createDatumReader(field.schema()).read(null, decoder);
                this.defaultValueCache.put(field, defaultValue);
            }
            catch (IOException e) {
                throw new AvroRuntimeException(e);
            }
        }
        return defaultValue;
    }

    public <T> T deepCopy(Schema schema, T value) {
        if (value == null) {
            return null;
        }
        switch (schema.getType()) {
            case ARRAY: {
                List arrayValue = (List)value;
                Array arrayCopy = new Array(arrayValue.size(), schema);
                for (Object obj : arrayValue) {
                    arrayCopy.add(this.deepCopy(schema.getElementType(), obj));
                }
                return (T)arrayCopy;
            }
            case BOOLEAN: {
                return (T)new Boolean((Boolean)value);
            }
            case BYTES: {
                ByteBuffer byteBufferValue = (ByteBuffer)value;
                int start = byteBufferValue.position();
                int length = byteBufferValue.limit() - start;
                byte[] bytesCopy = new byte[length];
                byteBufferValue.get(bytesCopy, 0, length);
                byteBufferValue.position(start);
                return (T)ByteBuffer.wrap(bytesCopy, 0, length);
            }
            case DOUBLE: {
                return (T)new Double((Double)value);
            }
            case ENUM: {
                return value;
            }
            case FIXED: {
                return (T)this.createFixed(null, ((GenericFixed)value).bytes(), schema);
            }
            case FLOAT: {
                return (T)new Float(((Float)value).floatValue());
            }
            case INT: {
                return (T)new Integer((Integer)value);
            }
            case LONG: {
                return (T)new Long((Long)value);
            }
            case MAP: {
                Map mapValue = (Map)value;
                HashMap mapCopy = new HashMap(mapValue.size());
                for (Map.Entry entry : mapValue.entrySet()) {
                    mapCopy.put((CharSequence)this.deepCopy(STRINGS, entry.getKey()), this.deepCopy(schema.getValueType(), entry.getValue()));
                }
                return (T)mapCopy;
            }
            case NULL: {
                return null;
            }
            case RECORD: {
                Object oldState = this.getRecordState(value, schema);
                Object newRecord = this.newRecord(null, schema);
                Object newState = this.getRecordState(newRecord, schema);
                for (Schema.Field f : schema.getFields()) {
                    int pos = f.pos();
                    String name = f.name();
                    Object newValue = this.deepCopy(f.schema(), this.getField(value, name, pos, oldState));
                    this.setField(newRecord, name, pos, newValue, newState);
                }
                return (T)newRecord;
            }
            case STRING: {
                if (value instanceof String) {
                    return value;
                }
                if (value instanceof Utf8) {
                    return (T)new Utf8((Utf8)value);
                }
                return (T)new Utf8(value.toString());
            }
            case UNION: {
                return this.deepCopy(schema.getTypes().get(this.resolveUnion(schema, value)), value);
            }
        }
        throw new AvroRuntimeException("Deep copy failed for schema \"" + schema + "\" and value \"" + value + "\"");
    }

    public Object createFixed(Object old, Schema schema) {
        if (old instanceof GenericFixed && ((GenericFixed)old).bytes().length == schema.getFixedSize()) {
            return old;
        }
        return new Fixed(schema);
    }

    public Object createFixed(Object old, byte[] bytes, Schema schema) {
        GenericFixed fixed = (GenericFixed)this.createFixed(old, schema);
        System.arraycopy(bytes, 0, fixed.bytes(), 0, schema.getFixedSize());
        return fixed;
    }

    public Object createEnum(String symbol, Schema schema) {
        return new EnumSymbol(schema, symbol);
    }

    public Object newRecord(Object old, Schema schema) {
        IndexedRecord record;
        if (old instanceof IndexedRecord && (record = (IndexedRecord)old).getSchema() == schema) {
            return record;
        }
        return new Record(schema);
    }

    public static class EnumSymbol
    implements GenericEnumSymbol,
    Comparable<GenericEnumSymbol> {
        private Schema schema;
        private String symbol;

        public EnumSymbol(Schema schema, String symbol) {
            this.schema = schema;
            this.symbol = symbol;
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericEnumSymbol && this.symbol.equals(o.toString());
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        @Override
        public String toString() {
            return this.symbol;
        }

        @Override
        public int compareTo(GenericEnumSymbol that) {
            return GenericData.get().compare(this, that, this.schema);
        }
    }

    public static class Fixed
    implements GenericFixed,
    Comparable<Fixed> {
        private Schema schema;
        private byte[] bytes;

        public Fixed(Schema schema) {
            this.setSchema(schema);
        }

        public Fixed(Schema schema, byte[] bytes) {
            this.schema = schema;
            this.bytes = bytes;
        }

        protected Fixed() {
        }

        protected void setSchema(Schema schema) {
            this.schema = schema;
            this.bytes = new byte[schema.getFixedSize()];
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        public void bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] bytes() {
            return this.bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericFixed && Arrays.equals(this.bytes, ((GenericFixed)o).bytes());
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public String toString() {
            return Arrays.toString(this.bytes);
        }

        @Override
        public int compareTo(Fixed that) {
            return BinaryData.compareBytes(this.bytes, 0, this.bytes.length, that.bytes, 0, that.bytes.length);
        }
    }

    public static class Array<T>
    extends AbstractList<T>
    implements GenericArray<T>,
    Comparable<GenericArray<T>> {
        private static final Object[] EMPTY = new Object[0];
        private final Schema schema;
        private int size;
        private Object[] elements = EMPTY;

        public Array(int capacity, Schema schema) {
            if (schema == null || !Schema.Type.ARRAY.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not an array schema: " + schema);
            }
            this.schema = schema;
            if (capacity != 0) {
                this.elements = new Object[capacity];
            }
        }

        public Array(Schema schema, Collection<T> c) {
            if (schema == null || !Schema.Type.ARRAY.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not an array schema: " + schema);
            }
            this.schema = schema;
            if (c != null) {
                this.elements = new Object[c.size()];
                this.addAll(c);
            }
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int position = 0;

                @Override
                public boolean hasNext() {
                    return this.position < Array.this.size;
                }

                @Override
                public T next() {
                    return Array.this.elements[this.position++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public T get(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            return (T)this.elements[i];
        }

        @Override
        public boolean add(T o) {
            if (this.size == this.elements.length) {
                Object[] newElements = new Object[this.size * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
                this.elements = newElements;
            }
            this.elements[this.size++] = o;
            return true;
        }

        @Override
        public void add(int location, T o) {
            if (location > this.size || location < 0) {
                throw new IndexOutOfBoundsException("Index " + location + " out of bounds.");
            }
            if (this.size == this.elements.length) {
                Object[] newElements = new Object[this.size * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
                this.elements = newElements;
            }
            System.arraycopy(this.elements, location, this.elements, location + 1, this.size - location);
            this.elements[location] = o;
            ++this.size;
        }

        @Override
        public T set(int i, T o) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            Object response = this.elements[i];
            this.elements[i] = o;
            return (T)response;
        }

        @Override
        public T remove(int i) {
            if (i >= this.size) {
                throw new IndexOutOfBoundsException("Index " + i + " out of bounds.");
            }
            Object result = this.elements[i];
            --this.size;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.size - i);
            this.elements[this.size] = null;
            return (T)result;
        }

        @Override
        public T peek() {
            return (T)(this.size < this.elements.length ? this.elements[this.size] : null);
        }

        @Override
        public int compareTo(GenericArray<T> that) {
            return GenericData.get().compare(this, that, this.getSchema());
        }

        @Override
        public void reverse() {
            int left = 0;
            for (int right = this.elements.length - 1; left < right; ++left, --right) {
                Object tmp = this.elements[left];
                this.elements[left] = this.elements[right];
                this.elements[right] = tmp;
            }
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            int count = 0;
            for (T e : this) {
                buffer.append(e == null ? "null" : e.toString());
                if (++count >= this.size()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            return buffer.toString();
        }
    }

    public static class Record
    implements GenericRecord,
    Comparable<Record> {
        private final Schema schema;
        private final Object[] values;

        public Record(Schema schema) {
            if (schema == null || !Schema.Type.RECORD.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not a record schema: " + schema);
            }
            this.schema = schema;
            this.values = new Object[schema.getFields().size()];
        }

        public Record(Record other, boolean deepCopy) {
            this.schema = other.schema;
            this.values = new Object[this.schema.getFields().size()];
            if (deepCopy) {
                for (int ii = 0; ii < this.values.length; ++ii) {
                    this.values[ii] = INSTANCE.deepCopy(this.schema.getFields().get(ii).schema(), other.values[ii]);
                }
            } else {
                System.arraycopy(other.values, 0, this.values, 0, other.values.length);
            }
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public void put(String key, Object value) {
            Schema.Field field = this.schema.getField(key);
            if (field == null) {
                throw new AvroRuntimeException("Not a valid schema field: " + key);
            }
            this.values[field.pos()] = value;
        }

        @Override
        public void put(int i, Object v) {
            this.values[i] = v;
        }

        @Override
        public Object get(String key) {
            Schema.Field field = this.schema.getField(key);
            if (field == null) {
                return null;
            }
            return this.values[field.pos()];
        }

        @Override
        public Object get(int i) {
            return this.values[i];
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record that = (Record)o;
            if (!this.schema.equals(that.schema)) {
                return false;
            }
            return GenericData.get().compare(this, that, this.schema, true) == 0;
        }

        public int hashCode() {
            return GenericData.get().hashCode(this, this.schema);
        }

        @Override
        public int compareTo(Record that) {
            return GenericData.get().compare(this, that, this.schema);
        }

        public String toString() {
            return GenericData.get().toString(this);
        }
    }

    public static enum StringType {
        CharSequence,
        String,
        Utf8;

    }
}

