/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.kdcReqBody.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.kdcReqBody.KdcReqBodyContainer;
import org.apache.directory.shared.kerberos.codec.ticket.TicketContainer;
import org.apache.directory.shared.kerberos.components.KdcReqBody;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.apache.spark-project.org.slf4j.Logger;
import org.apache.spark-project.org.slf4j.LoggerFactory;

public class AddTicket
extends GrammarAction<KdcReqBodyContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddTicket.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AddTicket() {
        super("KDC-REQ-BODY Add Ticket");
    }

    public void action(KdcReqBodyContainer kdcReqBodyContainer) throws DecoderException {
        TLV tlv = kdcReqBodyContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder ticketDecoder = new Asn1Decoder();
        TicketContainer ticketContainer = new TicketContainer(kdcReqBodyContainer.getStream());
        kdcReqBodyContainer.rewind();
        ticketDecoder.decode(kdcReqBodyContainer.getStream(), (Asn1Container)ticketContainer);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        kdcReqBodyContainer.updateParent();
        Ticket ticket = ticketContainer.getTicket();
        KdcReqBody kdcReqBody = kdcReqBodyContainer.getKdcReqBody();
        kdcReqBody.addAdditionalTicket(ticket);
        kdcReqBodyContainer.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Added ticket:  {}", (Object)ticket);
        }
    }
}

