/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.shared.kerberos.codec.principalName.PrincipalNameContainer;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.spark-project.org.slf4j.Logger;
import org.apache.spark-project.org.slf4j.LoggerFactory;

public abstract class AbstractReadPrincipalName<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadPrincipalName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadPrincipalName(String name) {
        super(name);
    }

    protected abstract void setPrincipalName(PrincipalName var1, E var2);

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        Asn1Decoder principalNameDecoder = new Asn1Decoder();
        PrincipalNameContainer principalNameContainer = new PrincipalNameContainer();
        principalNameDecoder.decode(container.getStream(), (Asn1Container)principalNameContainer);
        PrincipalName principalName = principalNameContainer.getPrincipalName();
        if (IS_DEBUG) {
            LOG.debug("PrincipalName : " + principalName);
        }
        this.setPrincipalName(principalName, container);
        tlv.setExpectedLength(tlv.getExpectedLength() - tlv.getLength());
        container.updateParent();
    }
}

