/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.codec.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.codec.kdcRep.KdcRepContainer;
import org.apache.directory.shared.kerberos.codec.kdcReq.KdcReqContainer;
import org.apache.spark-project.org.slf4j.Logger;
import org.apache.spark-project.org.slf4j.LoggerFactory;

public abstract class AbstractReadMsgType<E extends Asn1Container>
extends GrammarAction<E> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadMsgType.class);
    private KerberosMessageType msgType = null;

    public AbstractReadMsgType(String name) {
        super(name);
    }

    public AbstractReadMsgType(String name, KerberosMessageType msgType) {
        super(name);
        this.msgType = msgType;
    }

    public final void action(E container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 1) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        BerValue value = tlv.getValue();
        try {
            int msgTypeValue = IntegerDecoder.parse((BerValue)value);
            if (this.msgType != null) {
                if (this.msgType.getValue() == msgTypeValue) {
                    LOG.debug("msg-type : {}", (Object)this.msgType);
                    return;
                }
                String message = I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value.getData())});
                LOG.error(message);
                throw new DecoderException(message);
            }
            KerberosMessageType messageType = KerberosMessageType.getTypeByValue(msgTypeValue);
            if (container instanceof KdcReqContainer ? ((KdcReqContainer)((Object)container)).getKdcReq().getMessageType() == messageType : container instanceof KdcRepContainer && ((KdcRepContainer)((Object)container)).getKdcRep().getMessageType() == messageType) {
                return;
            }
            String message = I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value.getData())});
            LOG.error(message);
            throw new DecoderException(message);
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes(value.getData()), ide.getLocalizedMessage()}));
            throw new DecoderException(ide.getMessage());
        }
    }
}

