/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.workflow;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.service.AbstractService;

public class WorkflowExecutorService<E extends ExecutorService>
extends AbstractService {
    private E executor;

    public WorkflowExecutorService(String name) {
        this(name, null);
    }

    public WorkflowExecutorService(String name, E executor) {
        super(name);
        this.executor = executor;
    }

    public synchronized E getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(E executor) {
        Preconditions.checkState(this.executor == null, "Executor already set");
        this.executor = executor;
    }

    public void execute(Runnable runnable) {
        this.getExecutor().execute(runnable);
    }

    public <V> Future<V> submit(Callable<V> callable) {
        return this.getExecutor().submit(callable);
    }

    protected void serviceStop() throws Exception {
        this.stopExecutor();
        super.serviceStop();
    }

    protected synchronized void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

