/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.utility;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.slider.core.main.RunService;
import org.apache.slider.server.services.workflow.WorkflowCompositeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchedWorkflowCompositeService
extends WorkflowCompositeService
implements RunService {
    private static final Logger log = LoggerFactory.getLogger(LaunchedWorkflowCompositeService.class);
    private String[] argv;

    public LaunchedWorkflowCompositeService(String name) {
        super(name);
    }

    public LaunchedWorkflowCompositeService(String name, Service ... children) {
        super(name, children);
    }

    protected static boolean isUnset(String s) {
        return StringUtils.isEmpty(s);
    }

    protected static boolean isSet(String s) {
        return StringUtils.isNotEmpty(s);
    }

    protected String[] getArgv() {
        return this.argv;
    }

    @Override
    public Configuration bindArgs(Configuration config, String ... args) throws Exception {
        this.argv = args;
        if (log.isDebugEnabled()) {
            log.debug("Binding {} Arguments:", (Object)args.length);
            StringBuilder builder = new StringBuilder();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                builder.append('\"').append(arg).append("\" ");
                ++n2;
            }
            log.debug(builder.toString());
        }
        return config;
    }

    @Override
    public int runService() throws Throwable {
        return 0;
    }

    @Override
    public synchronized void addService(Service service) {
        Preconditions.checkArgument(service != null, "null service argument");
        super.addService(service);
    }

    protected boolean deployChildService(Service service) {
        service.init(this.getConfig());
        this.addService(service);
        if (this.isInState(Service.STATE.STARTED)) {
            service.start();
            return true;
        }
        return false;
    }
}

