/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.services.security;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.slider.core.conf.MapOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static String CA_CONFIG_CONTENTS = "HOME            = .\nRANDFILE        = $ENV::HOME/.rnd\n\n[ ca ]\ndefault_ca             = CA_CLIENT\n[ CA_CLIENT ]\ndir                    = ${SEC_DIR}/db\ncerts                  = $dir/certs\nnew_certs_dir          = $dir/newcerts\n\ndatabase               = $dir/index.txt\nserial                 = $dir/serial\ndefault_days           = 365    \n\ndefault_crl_days       = 7  \ndefault_md             = md5 \n\npolicy                 = policy_anything \n\n[ policy_anything ]\ncountryName            = optional\nstateOrProvinceName    = optional\nlocalityName           = optional\norganizationName       = optional\norganizationalUnitName = optional\ncommonName             = optional\nemailAddress           = optional\n\n[req]\ndistinguished_name     = req_distinguished_name\n\n[ req_distinguished_name ]\n\n[ jdk7_ca ]\nsubjectKeyIdentifier = hash\nauthorityKeyIdentifier = keyid:always,issuer:always\nbasicConstraints = CA:true\n";
    private static final String PASS_TOKEN = "pass:";
    private static String keystorePass;
    private static String securityDir;

    public static void logOpenSslExitCode(String command, int exitCode) {
        if (exitCode == 0) {
            LOG.info(SecurityUtils.getOpenSslCommandResult(command, exitCode));
        } else {
            LOG.warn(SecurityUtils.getOpenSslCommandResult(command, exitCode));
        }
    }

    public static String hideOpenSslPassword(String command) {
        int start = command.indexOf(PASS_TOKEN);
        while (start >= 0) {
            CharSequence cs = command.subSequence(start += PASS_TOKEN.length(), command.indexOf(" ", start));
            command = command.replace(cs, "****");
            start = command.indexOf(PASS_TOKEN, start + 1);
        }
        return command;
    }

    public static String getOpenSslCommandResult(String command, int exitCode) {
        return "Command " + SecurityUtils.hideOpenSslPassword(command) + " was finished with exit code: " + exitCode + " - " + SecurityUtils.getOpenSslExitCodeDescription(exitCode);
    }

    private static String getOpenSslExitCodeDescription(int exitCode) {
        switch (exitCode) {
            case 0: {
                return "the operation was completed successfully.";
            }
            case 1: {
                return "an error occurred parsing the command options.";
            }
            case 2: {
                return "one of the input files could not be read.";
            }
            case 3: {
                return "an error occurred creating the PKCS#7 file or when reading the MIME message.";
            }
            case 4: {
                return "an error occurred decrypting or verifying the message.";
            }
            case 5: {
                return "the message was verified correctly but an error occurred writing out the signers certificates.";
            }
        }
        return "unsupported code";
    }

    public static void writeCaConfigFile(String path) throws IOException {
        String contents = CA_CONFIG_CONTENTS.replace("${SEC_DIR}", path);
        FileUtils.writeStringToFile((File)new File(path, "ca.config"), (String)contents);
    }

    public static String getKeystorePass() {
        return keystorePass;
    }

    public static String getSecurityDir() {
        return securityDir;
    }

    public static void initializeSecurityParameters(MapOperations configMap) {
        SecurityUtils.initializeSecurityParameters(configMap, false);
    }

    public static void initializeSecurityParameters(MapOperations configMap, boolean persistPassword) {
        File secDirFile;
        block15: {
            String keyStoreLocation = configMap.getOption("ssl.server.keystore.location", SecurityUtils.getDefaultKeystoreLocation());
            secDirFile = new File(keyStoreLocation).getParentFile();
            if (!secDirFile.exists()) {
                File dbDir = new File(secDirFile, "db");
                File newCertsDir = new File(dbDir, "newcerts");
                newCertsDir.mkdirs();
                RawLocalFileSystem fileSystem = null;
                try {
                    try {
                        fileSystem = new RawLocalFileSystem();
                        FsPermission permissions = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
                        fileSystem.setPermission(new Path(dbDir.getAbsolutePath()), permissions);
                        fileSystem.setPermission(new Path(dbDir.getAbsolutePath()), permissions);
                        fileSystem.setPermission(new Path(newCertsDir.getAbsolutePath()), permissions);
                        File indexFile = new File(dbDir, "index.txt");
                        indexFile.createNewFile();
                        SecurityUtils.writeCaConfigFile(secDirFile.getAbsolutePath().replace('\\', '/'));
                    }
                    catch (IOException e) {
                        LOG.error("Unable to create SSL configuration directories/files", e);
                        if (fileSystem != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (IOException e2) {
                                LOG.warn("Unable to close fileSystem", e2);
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (IOException e) {
                            LOG.warn("Unable to close fileSystem", e);
                        }
                    }
                    throw throwable;
                }
                if (fileSystem != null) {
                    try {
                        fileSystem.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to close fileSystem", e);
                    }
                }
            }
        }
        keystorePass = SecurityUtils.getKeystorePassword(secDirFile, persistPassword);
        securityDir = secDirFile.getAbsolutePath();
    }

    private static String getKeystorePassword(File secDirFile, boolean persistPassword) {
        File passFile = new File(secDirFile, "pass.txt");
        String password = null;
        if (!passFile.exists()) {
            LOG.info("Generating keystore password");
            password = RandomStringUtils.randomAlphanumeric(Integer.valueOf("50"));
            if (persistPassword) {
                try {
                    FileUtils.writeStringToFile((File)passFile, (String)password);
                    passFile.setWritable(true);
                    passFile.setReadable(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error creating certificate password file");
                }
            }
        } else {
            LOG.info("Reading password from existing file");
            try {
                password = FileUtils.readFileToString((File)passFile);
                password = password.replaceAll("\\p{Cntrl}", "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return password;
    }

    private static String getDefaultKeystoreLocation() {
        File workDir = null;
        try {
            workDir = new File(String.valueOf(FileUtils.getTempDirectory().getAbsolutePath()) + "/sec" + System.currentTimeMillis());
            if (!workDir.mkdirs()) {
                throw new IOException("Unable to create temporary security directory");
            }
        }
        catch (IOException iOException) {
            LOG.warn("Unable to create security directory");
            return null;
        }
        return workDir.getAbsolutePath() + File.separator + "security" + File.separator + "keystore.p12";
    }
}

