/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.publisher;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.slider.core.registry.docstore.ConfigFormat;
import org.apache.slider.core.registry.docstore.PublishedConfigSet;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.core.registry.docstore.PublishedConfigurationOutputter;
import org.apache.slider.core.registry.docstore.PublishedExports;
import org.apache.slider.core.registry.docstore.PublishedExportsSet;
import org.apache.slider.core.registry.docstore.UriMap;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AbstractSliderResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherResource
extends AbstractSliderResource {
    protected static final Logger log = LoggerFactory.getLogger(PublisherResource.class);
    public static final String EXPORTS_NAME = "exports";
    public static final String EXPORTS_RESOURCES_PATH = "/exports";
    public static final String EXPORT_RESOURCE_PATH = "/exports/{exportname}";
    public static final String SET_NAME = "{setname: [a-z0-9][a-z0-9_.\\+-]*}";
    public static final String SETNAME = "setname";
    public static final String CLASSPATH = "/classpath";
    public static final String CONFIG = "config";
    public static final String SETNAME_PATTERN = "{setname: [a-z0-9][a-z0-9_.\\+-]*}";
    private static final String CONFIG_PATTERN = "{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}";
    private final StateAccessForProviders appState;

    public PublisherResource(WebAppApi slider) {
        super(slider);
        this.appState = slider.getAppState();
    }

    private void init(HttpServletResponse res, UriInfo uriInfo) {
        res.setContentType(null);
        log.debug(uriInfo.getRequestUri().toString());
    }

    private PublishedConfigSet getConfigSet(String setname) {
        PublishedConfigSet configSet = this.appState.getPublishedConfigSet(setname);
        if (configSet == null) {
            throw new NotFoundException("Not found: " + setname);
        }
        return configSet;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public UriMap enumConfigSets(@Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res, uriInfo);
        String baseURL = uriInfo.getRequestUri().toString();
        if (!baseURL.endsWith("/")) {
            baseURL = String.valueOf(baseURL) + "/";
        }
        UriMap uriMap = new UriMap();
        for (String name : this.appState.listConfigSets()) {
            uriMap.put(name, String.valueOf(baseURL) + name);
            log.info("registering config set {} at {}", (Object)name, (Object)baseURL);
        }
        uriMap.put(EXPORTS_NAME, String.valueOf(baseURL) + EXPORTS_NAME);
        return uriMap;
    }

    @GET
    @Path(value="/classpath")
    @Produces(value={"application/json"})
    public Set<URL> getAMClassPath() {
        URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        return new LinkedHashSet<URL>(Arrays.asList(urls));
    }

    @GET
    @Path(value="/exports")
    @Produces(value={"application/json"})
    public PublishedExportsSet gePublishedExports() {
        PublishedExportsSet set = this.appState.getPublishedExportsSet();
        return set.shallowCopy();
    }

    @GET
    @Path(value="/exports/{exportname}")
    @Produces(value={"application/json"})
    public PublishedExports getAMExports2(@PathParam(value="exportname") String exportname, @Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res, uriInfo);
        PublishedExportsSet set = this.appState.getPublishedExportsSet();
        return set.get(exportname);
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}")
    @Produces(value={"application/json"})
    public PublishedConfigSet getPublishedConfiguration(@PathParam(value="setname") String setname, @Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res, uriInfo);
        this.logRequest(uriInfo);
        PublishedConfigSet publishedConfigSet = this.getConfigSet(setname);
        log.debug("Number of configurations: {}", (Object)publishedConfigSet.size());
        return publishedConfigSet.shallowCopy();
    }

    private void logRequest(UriInfo uriInfo) {
        log.info(uriInfo.getRequestUri().toString());
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}")
    @Produces(value={"application/json"})
    public PublishedConfiguration getConfigurationInstance(@PathParam(value="setname") String setname, @PathParam(value="config") String config, @Context UriInfo uriInfo, @Context HttpServletResponse res) {
        this.init(res, uriInfo);
        PublishedConfiguration publishedConfig = this.getPublishedConfiguration(setname, config);
        if (publishedConfig == null) {
            log.info("Configuration {} not found", (Object)config);
            throw new NotFoundException("Not found: " + uriInfo.getAbsolutePath());
        }
        return publishedConfig;
    }

    public PublishedConfiguration getPublishedConfiguration(String setname, String config) {
        return this.getConfigSet(setname).get(config);
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}.json")
    @Produces(value={"application/json"})
    public String getConfigurationContentJson(@PathParam(value="setname") String setname, @PathParam(value="config") String config, @Context UriInfo uriInfo, @Context HttpServletResponse res) throws IOException {
        return this.getStringRepresentation(setname, config, uriInfo, res, ConfigFormat.JSON);
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}.xml")
    @Produces(value={"application/xml"})
    public String getConfigurationContentXML(@PathParam(value="setname") String setname, @PathParam(value="config") String config, @Context UriInfo uriInfo, @Context HttpServletResponse res) throws IOException {
        return this.getStringRepresentation(setname, config, uriInfo, res, ConfigFormat.XML);
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}.properties")
    @Produces(value={"application/xml"})
    public String getConfigurationContentProperties(@PathParam(value="setname") String setname, @PathParam(value="config") String config, @Context UriInfo uriInfo, @Context HttpServletResponse res) throws IOException {
        return this.getStringRepresentation(setname, config, uriInfo, res, ConfigFormat.PROPERTIES);
    }

    public String getStringRepresentation(String setname, String config, UriInfo uriInfo, HttpServletResponse res, ConfigFormat format) throws IOException {
        PublishedConfiguration publishedConfig = this.getConfigurationInstance(setname, config, uriInfo, res);
        PublishedConfigurationOutputter outputter = publishedConfig.createOutputter(format);
        return outputter.asString();
    }

    @GET
    @Path(value="/{setname: [a-z0-9][a-z0-9_.\\+-]*}/{config: [a-z0-9][a-z0-9_\\+-]*}/{propertyName}")
    @Produces(value={"application/json"})
    public Map<String, String> getConfigurationProperty(@PathParam(value="setname") String setname, @PathParam(value="config") String config, @PathParam(value="propertyName") String propertyName, @Context UriInfo uriInfo, @Context HttpServletResponse res) {
        PublishedConfiguration publishedConfig = this.getConfigurationInstance(setname, config, uriInfo, res);
        String propVal = publishedConfig.entries.get(propertyName);
        if (propVal == null) {
            log.debug("Configuration property {} not found in configuration {}", (Object)propertyName, (Object)config);
            throw new NotFoundException("Property not found: " + propertyName);
        }
        HashMap<String, String> rtnVal = new HashMap<String, String>();
        rtnVal.put(propertyName, propVal);
        return rtnVal;
    }
}

