/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.application.resources;

import java.util.Map;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.server.appmaster.state.RoleStatus;
import org.apache.slider.server.appmaster.state.StateAccessForProviders;
import org.apache.slider.server.appmaster.web.rest.application.resources.ResourceRefresher;

public class LiveResourcesRefresher
implements ResourceRefresher<ConfTree> {
    private final StateAccessForProviders state;

    public LiveResourcesRefresher(StateAccessForProviders state) {
        this.state = state;
    }

    @Override
    public ConfTree refresh() throws Exception {
        ConfTreeOperations resources = this.state.getResourcesSnapshot();
        Map<Integer, RoleStatus> roleStatusMap = this.state.getRoleStatusMap();
        for (RoleStatus status : roleStatusMap.values()) {
            String name = status.getName();
            resources.setComponentOpt(name, "yarn.component.instances.requesting", status.getRequested());
            resources.setComponentOpt(name, "yarn.component.instances.actual", status.getActual());
            resources.setComponentOpt(name, "yarn.component.instances.releasing", status.getReleasing());
            resources.setComponentOpt(name, "yarn.component.instances.failed", status.getFailed());
            resources.setComponentOpt(name, "yarn.component.instances.completed", status.getCompleted());
            resources.setComponentOpt(name, "yarn.component.instances.started", status.getStarted());
        }
        return resources.getConfTree();
    }
}

