/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.security;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.exceptions.SliderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfiguration {
    protected static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    private final Configuration configuration;
    private final AggregateConf instanceDefinition;
    private String clusterName;

    public SecurityConfiguration(Configuration configuration, AggregateConf instanceDefinition, String clusterName) throws SliderException {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(instanceDefinition);
        Preconditions.checkNotNull(clusterName);
        this.configuration = configuration;
        this.instanceDefinition = instanceDefinition;
        this.clusterName = clusterName;
        this.validate();
    }

    private void validate() throws SliderException {
        if (this.isSecurityEnabled()) {
            String principal = this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.keytab.principal.name");
            if (SliderUtils.isUnset(principal)) {
                UserGroupInformation loginUser = null;
                try {
                    loginUser = this.getLoginUser();
                }
                catch (IOException e) {
                    throw new SliderException(41, e, "No principal configured for the application and exception raised during retrieval of login user. Unable to proceed with application initialization.  Please ensure a value for %s exists in the application configuration or the login issue is addressed", "slider.keytab.principal.name");
                }
                if (loginUser == null) {
                    throw new SliderException(41, "No principal configured for the application and no login user found. Unable to proceed with application initialization.  Please ensure a value for %s exists in the application configuration or the login issue is addressed", "slider.keytab.principal.name");
                }
            }
            String keytabFullPath = this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.keytab.local.path");
            String keytabName = this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.login.keytab.name");
            if (SliderUtils.isSet(keytabFullPath) && SliderUtils.isSet(keytabName)) {
                throw new SliderException(41, "Both a keytab on the cluster host (%s) and a keytab to be retrieved from HDFS (%s) are specified.  Please configure only one keytab retrieval mechanism.", "slider.am.keytab.local.path", "slider.am.login.keytab.name");
            }
        }
    }

    protected UserGroupInformation getLoginUser() throws IOException {
        return UserGroupInformation.getLoginUser();
    }

    public boolean isSecurityEnabled() {
        return SliderUtils.isHadoopClusterSecure(this.configuration);
    }

    public String getPrincipal() throws IOException {
        String principal = this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.keytab.principal.name");
        if (SliderUtils.isUnset(principal)) {
            principal = UserGroupInformation.getLoginUser().getShortUserName();
            log.info("No principal set in the slider configuration.  Will use AM login identity {} to attempt keytab-based login", (Object)principal);
        }
        return principal;
    }

    public boolean isKeytabProvided() {
        boolean keytabProvided = this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.keytab.local.path") != null || this.instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.login.keytab.name") != null;
        return keytabProvided;
    }

    public File getKeytabFile(AggregateConf instanceDefinition) throws SliderException, IOException {
        File localKeytabFile;
        String keytabFullPath = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.keytab.local.path");
        if (SliderUtils.isUnset(keytabFullPath)) {
            String keytabName = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster").get("slider.am.login.keytab.name");
            log.info("No host keytab file path specified. Will attempt to retrieve keytab file {} as a local resource for the container", (Object)keytabName);
            localKeytabFile = new File("keytabs", keytabName);
        } else {
            log.info("Using host keytab file {} for login", (Object)keytabFullPath);
            localKeytabFile = new File(keytabFullPath);
        }
        return localKeytabFile;
    }
}

