/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.monkey;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.service.AbstractService;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.actions.RenewingAction;
import org.apache.slider.server.appmaster.monkey.ChaosEntry;
import org.apache.slider.server.appmaster.monkey.ChaosTarget;
import org.apache.slider.server.appmaster.monkey.MonkeyPlayAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosMonkeyService
extends AbstractService {
    protected static final Logger log = LoggerFactory.getLogger(ChaosMonkeyService.class);
    private final MetricRegistry metrics;
    private final QueueAccess queues;
    private final Random random = new Random();
    private final List<ChaosEntry> chaosEntries = new ArrayList<ChaosEntry>();

    public ChaosMonkeyService(MetricRegistry metrics, QueueAccess queues) {
        super("ChaosMonkeyService");
        this.metrics = metrics;
        this.queues = queues;
    }

    public synchronized void addTarget(String name, ChaosTarget target, long probability) {
        if (probability > 0L) {
            log.info("Adding {} with probability {}", (Object)name, (Object)((double)probability / 100.0));
            this.chaosEntries.add(new ChaosEntry(name, target, probability, this.metrics));
        } else {
            log.debug("Action {} not enabled", (Object)name);
        }
    }

    public int getTargetCount() {
        return this.chaosEntries.size();
    }

    public void play() {
        for (ChaosEntry chaosEntry : this.chaosEntries) {
            long p = this.randomPercentage();
            chaosEntry.maybeInvokeChaos(p);
        }
    }

    public int randomPercentage() {
        return this.random.nextInt(10000);
    }

    public boolean chaosCheck(long probability) {
        return (long)this.randomPercentage() < probability;
    }

    public boolean schedule(long delay, long interval, TimeUnit timeUnit) {
        if (interval > 0L && !this.chaosEntries.isEmpty()) {
            this.queues.schedule(this.getChaosAction(delay, interval, timeUnit));
            return true;
        }
        return false;
    }

    public RenewingAction<MonkeyPlayAction> getChaosAction(long delay, long interval, TimeUnit timeUnit) {
        RenewingAction<MonkeyPlayAction> action = new RenewingAction<MonkeyPlayAction>(new MonkeyPlayAction(this, 0L, TimeUnit.MILLISECONDS), delay, interval, timeUnit, 0);
        return action;
    }
}

