/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.actions;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.slider.server.appmaster.SliderAppMaster;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.QueueAccess;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.operations.ContainerReleaseOperation;
import org.apache.slider.server.appmaster.operations.RMOperationHandlerActions;
import org.apache.slider.server.appmaster.state.AppState;

public class ActionKillContainer
extends AsyncAction {
    private final ContainerId containerId;
    private final RMOperationHandlerActions operationHandler;

    public ActionKillContainer(ContainerId containerId, long delay, TimeUnit timeUnit, RMOperationHandlerActions operationHandler) {
        super("kill container", delay, timeUnit, 1);
        this.operationHandler = operationHandler;
        Preconditions.checkArgument(containerId != null);
        this.containerId = containerId;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public void execute(SliderAppMaster appMaster, QueueAccess queueService, AppState appState) throws Exception {
        LinkedList<AbstractRMOperation> opsList = new LinkedList<AbstractRMOperation>();
        ContainerReleaseOperation release = new ContainerReleaseOperation(this.containerId);
        opsList.add(release);
        this.operationHandler.execute(opsList);
    }
}

