/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.slider.providers.agent.AgentProviderService;
import org.apache.slider.providers.agent.ComponentInstanceState;
import org.apache.slider.providers.agent.ContainerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatMonitor
implements Runnable {
    protected static final Logger log = LoggerFactory.getLogger(HeartbeatMonitor.class);
    private final int threadWakeupInterval;
    private final AgentProviderService provider;
    private volatile boolean shouldRun = true;
    private Thread monitorThread = null;

    public HeartbeatMonitor(AgentProviderService provider, int threadWakeupInterval) {
        this.provider = provider;
        this.threadWakeupInterval = threadWakeupInterval;
    }

    public void shutdown() {
        this.shouldRun = false;
    }

    public void start() {
        log.info("Starting heartbeat monitor with interval {}", (Object)this.threadWakeupInterval);
        this.monitorThread = new Thread(this);
        this.monitorThread.start();
    }

    void join(long millis) throws InterruptedException {
        if (this.isAlive()) {
            this.monitorThread.join(millis);
        }
    }

    public boolean isAlive() {
        return this.monitorThread != null && this.monitorThread.isAlive();
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                log.debug("Putting monitor to sleep for " + this.threadWakeupInterval + " " + "milliseconds");
                Thread.sleep(this.threadWakeupInterval);
                this.doWork(System.currentTimeMillis());
            }
            catch (InterruptedException ex) {
                log.warn("Scheduler thread is interrupted going to stop", ex);
                this.shouldRun = false;
            }
            catch (Exception ex) {
                log.warn("Exception received", ex);
            }
            catch (Throwable t) {
                log.warn("ERROR", t);
            }
        }
    }

    @VisibleForTesting
    public void doWork(long now) {
        Map<String, ComponentInstanceState> componentStatuses = this.provider.getComponentStatuses();
        if (componentStatuses != null) {
            for (String containerLabel : componentStatuses.keySet()) {
                ComponentInstanceState componentInstanceState = componentStatuses.get(containerLabel);
                long timeSinceLastHeartbeat = now - componentInstanceState.getLastHeartbeat();
                if (timeSinceLastHeartbeat <= (long)this.threadWakeupInterval) continue;
                switch (componentInstanceState.getContainerState()) {
                    case INIT: 
                    case HEALTHY: {
                        componentInstanceState.setContainerState(ContainerState.UNHEALTHY);
                        log.warn("Component {} marked UNHEALTHY. Last heartbeat received at {} approx. {} ms. back.", componentInstanceState, componentInstanceState.getLastHeartbeat(), timeSinceLastHeartbeat);
                        break;
                    }
                    case UNHEALTHY: {
                        if (timeSinceLastHeartbeat <= (long)(this.threadWakeupInterval * 2)) break;
                        componentInstanceState.setContainerState(ContainerState.HEARTBEAT_LOST);
                        log.warn("Component {} marked HEARTBEAT_LOST. Last heartbeat received at {} approx. {} ms. back.", componentInstanceState, componentInstanceState.getLastHeartbeat(), timeSinceLastHeartbeat);
                        ContainerId containerId = componentInstanceState.getContainerId();
                        this.provider.lostContainer(containerLabel, containerId);
                        break;
                    }
                    case HEARTBEAT_LOST: {
                        log.warn("Heartbeat from lost component: {}", (Object)componentInstanceState);
                    }
                }
            }
        }
    }
}

