/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.providers.agent.application.metadata.AbstractMetainfoParser;
import org.apache.slider.providers.agent.application.metadata.AddonPackageMetainfoParser;
import org.apache.slider.providers.agent.application.metadata.DefaultConfig;
import org.apache.slider.providers.agent.application.metadata.DefaultConfigParser;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.apache.slider.providers.agent.application.metadata.MetainfoParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentUtils {
    private static final Logger log = LoggerFactory.getLogger(AgentUtils.class);

    public static Metainfo getApplicationMetainfo(SliderFileSystem fileSystem, String metainfoPath, boolean metainfoForAddon) throws IOException, BadConfigException {
        log.info("Reading metainfo at {}", (Object)metainfoPath);
        FileSystem fs = fileSystem.getFileSystem();
        Path appPath = new Path(metainfoPath);
        Metainfo metainfo = null;
        AbstractMetainfoParser metainfoParser = null;
        metainfoParser = metainfoForAddon ? new AddonPackageMetainfoParser() : new MetainfoParser();
        InputStream metainfoJsonStream = SliderUtils.getApplicationResourceInputStream(fs, appPath, "metainfo.json");
        if (metainfoJsonStream == null) {
            InputStream metainfoXMLStream = SliderUtils.getApplicationResourceInputStream(fs, appPath, "metainfo.xml");
            if (metainfoXMLStream != null) {
                metainfo = metainfoParser.fromXmlStream(metainfoXMLStream);
            }
        } else {
            metainfo = metainfoParser.fromJsonStream(metainfoJsonStream);
        }
        if (metainfo == null) {
            log.error("metainfo is unavailable at {}.", (Object)metainfoPath);
            throw new FileNotFoundException("metainfo.xml/json is required in app package. " + appPath);
        }
        return metainfo;
    }

    static DefaultConfig getDefaultConfig(SliderFileSystem fileSystem, String appDef, String configFileName) throws IOException {
        String fileToRead = "configuration/" + configFileName;
        log.info("Reading default config file {} at {}", (Object)fileToRead, (Object)appDef);
        InputStream configStream = SliderUtils.getApplicationResourceInputStream(fileSystem.getFileSystem(), new Path(appDef), fileToRead);
        if (configStream == null) {
            log.error("{} is unavailable at {}.", (Object)fileToRead, (Object)appDef);
            throw new IOException("Expected config file " + fileToRead + " is not available.");
        }
        return new DefaultConfigParser().parse(configStream);
    }
}

