/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.RoleKeys;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.exceptions.SliderInternalStateException;
import org.slf4j.Logger;

public class ProviderUtils
implements RoleKeys {
    protected final Logger log;

    public ProviderUtils(Logger log) {
        this.log = log;
    }

    public static boolean addProviderJar(Map<String, LocalResource> providerResources, Object provider, String jarName, SliderFileSystem sliderFileSystem, Path tempPath, String libdir, boolean miniClusterTestRun) throws IOException, SliderException {
        try {
            SliderUtils.putJar(providerResources, sliderFileSystem, provider.getClass(), tempPath, libdir, jarName);
            return true;
        }
        catch (FileNotFoundException e) {
            if (miniClusterTestRun) {
                return false;
            }
            throw e;
        }
    }

    public static boolean addAgentTar(Object provider, String tarName, SliderFileSystem sliderFileSystem, Path agentDir) throws IOException {
        File localFile = SliderUtils.findContainingJar(provider.getClass());
        if (localFile != null) {
            String parentDir = localFile.getParent();
            Path agentTarPath = new Path(parentDir, tarName);
            sliderFileSystem.getFileSystem().copyFromLocalFile(false, true, agentTarPath, agentDir);
            return true;
        }
        return false;
    }

    public static void addDependencyJars(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Path tempPath, String libdir, String[] resources, Class[] classes) throws IOException, SliderException {
        if (resources.length != classes.length) {
            throw new SliderInternalStateException("mismatch in Jar names [%d] and classes [%d]", resources.length, classes.length);
        }
        int size = resources.length;
        int i = 0;
        while (i < size) {
            String jarName = resources[i];
            Class clazz = classes[i];
            SliderUtils.putJar(providerResources, sliderFileSystem, clazz, tempPath, libdir, jarName);
            ++i;
        }
    }

    public static void addAllDependencyJars(Map<String, LocalResource> providerResources, SliderFileSystem sliderFileSystem, Path tempPath, String libDir, String libLocalSrcDir) throws IOException, SliderException {
        File file;
        String libSrcToUse = libLocalSrcDir;
        if (!(!SliderUtils.isSet(libLocalSrcDir) || (file = new File(libLocalSrcDir)).exists() && file.isDirectory())) {
            throw new BadCommandArgumentsException("Supplied lib src dir %s is not valid", libLocalSrcDir);
        }
        SliderUtils.putAllJars(providerResources, sliderFileSystem, tempPath, libDir, libSrcToUse);
    }

    public String getLogdir() throws IOException {
        String logdir = System.getenv("LOGDIR");
        if (logdir == null) {
            logdir = "/tmp/slider-" + UserGroupInformation.getCurrentUser().getShortUserName();
        }
        return logdir;
    }

    public void validateNodeCount(AggregateConf instanceDescription, String name, int min, int max) throws BadCommandArgumentsException {
        MapOperations component = instanceDescription.getResourceOperations().getComponent(name);
        int count = component == null ? 0 : component.getOptionInt("yarn.component.instances", 0);
        this.validateNodeCount(name, count, min, max);
    }

    public void validateNodeCount(String name, int count, int min, int max) throws BadCommandArgumentsException {
        if (count < min) {
            throw new BadCommandArgumentsException("requested no of %s nodes: %d is below the minimum of %d", name, count, min);
        }
        if (max > 0 && count > max) {
            throw new BadCommandArgumentsException("requested no of %s nodes: %d is above the maximum of %d", name, count, max);
        }
    }

    public void propagateSiteOptions(ClusterDescription clusterSpec, Map<String, String> sitexml) {
        Map<String, String> options = clusterSpec.options;
        this.propagateSiteOptions(options, sitexml);
    }

    public void propagateSiteOptions(Map<String, String> options, Map<String, String> sitexml) {
        this.propagateSiteOptions(options, sitexml, "");
    }

    public void propagateSiteOptions(Map<String, String> options, Map<String, String> sitexml, String configName) {
        this.propagateSiteOptions(options, sitexml, configName, null);
    }

    public void propagateSiteOptions(Map<String, String> options, Map<String, String> sitexml, String configName, Map<String, String> tokenMap) {
        String prefix = "site." + (!configName.isEmpty() ? String.valueOf(configName) + "." : "");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String envName;
            String key = entry.getKey();
            if (!key.startsWith(prefix) || (envName = key.substring(prefix.length())).isEmpty()) continue;
            String value = entry.getValue();
            if (tokenMap != null) {
                for (Map.Entry<String, String> token : tokenMap.entrySet()) {
                    value = value.replaceAll(Pattern.quote(token.getKey()), token.getValue());
                }
            }
            sitexml.put(envName, value);
        }
    }

    public void propagateOption(MapOperations global, String optionKey, Map<String, String> sitexml, String siteKey) throws BadConfigException {
        sitexml.put(siteKey, global.getMandatoryOption(optionKey));
    }

    public String buildPathToHomeDir(AggregateConf instanceDefinition, String bindir, String script) throws FileNotFoundException, BadConfigException {
        MapOperations globalOptions = instanceDefinition.getInternalOperations().getGlobalOptions();
        String applicationHome = globalOptions.get("internal.application.home");
        String imagePath = globalOptions.get("internal.application.image.path");
        return this.buildPathToHomeDir(imagePath, applicationHome, bindir, script);
    }

    public String buildPathToHomeDir(String imagePath, String applicationHome, String bindir, String script) throws FileNotFoundException {
        String path;
        if (imagePath != null) {
            File tarball = new File("expandedarchive");
            File scriptFile = this.findBinScriptInExpandedArchive(tarball, bindir, script);
            StringBuilder builder = new StringBuilder();
            builder.append("expandedarchive");
            builder.append("/");
            File archive = scriptFile.getParentFile().getParentFile();
            builder.append(archive.getName());
            path = builder.toString();
        } else {
            File homedir = new File(applicationHome);
            path = homedir.getAbsolutePath();
            SliderUtils.verifyIsDir(homedir, this.log);
            File bin = new File(homedir, bindir);
            SliderUtils.verifyIsDir(bin, this.log);
            File scriptFile = new File(bin, script);
            SliderUtils.verifyFileExists(scriptFile, this.log);
        }
        return path;
    }

    public String buildPathToScript(AggregateConf instance, String bindir, String script) throws FileNotFoundException {
        return this.buildPathToScript(instance.getInternalOperations(), bindir, script);
    }

    public String buildPathToScript(ConfTreeOperations internal, String bindir, String script) throws FileNotFoundException {
        String homedir = this.buildPathToHomeDir(internal.get("internal.application.image.path"), internal.get("internal.application.home"), bindir, script);
        return this.buildScriptPath(bindir, script, homedir);
    }

    public String buildScriptPath(String bindir, String script, String homedir) {
        StringBuilder builder = new StringBuilder(homedir);
        builder.append("/");
        builder.append(bindir);
        builder.append("/");
        builder.append(script);
        return builder.toString();
    }

    public static String convertToAppRelativePath(File file) {
        return ProviderUtils.convertToAppRelativePath(file.getPath());
    }

    public static String convertToAppRelativePath(String path) {
        return String.valueOf(ApplicationConstants.Environment.PWD.$()) + "/" + path;
    }

    public static void validatePathReferencesLocalDir(String meaning, String path) throws BadConfigException {
        File file = new File(path);
        if (!file.exists()) {
            throw new BadConfigException("%s directory %s not found", meaning, file);
        }
        if (!file.isDirectory()) {
            throw new BadConfigException("%s is not a directory: %s", meaning, file);
        }
    }

    public String getUserName() throws IOException {
        return UserGroupInformation.getCurrentUser().getShortUserName();
    }

    public File findBinScriptInExpandedArchive(File base, String bindir, String script) throws FileNotFoundException {
        SliderUtils.verifyIsDir(base, this.log);
        File[] ls = base.listFiles();
        if (ls == null) {
            throw new FileNotFoundException("Failed to list directory " + base);
        }
        this.log.debug("Found {} entries in {}", (Object)ls.length, (Object)base);
        LinkedList<File> directories = new LinkedList<File>();
        StringBuilder dirs = new StringBuilder();
        File[] fileArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.log.debug("{}", (Object)false);
            if (file.isDirectory()) {
                directories.add(file);
                dirs.append(file.getPath()).append(" ");
            }
            ++n2;
        }
        if (directories.size() > 1) {
            throw new FileNotFoundException("Too many directories in archive to identify binary: " + dirs);
        }
        if (directories.isEmpty()) {
            throw new FileNotFoundException("No directory found in archive " + base);
        }
        File archive = (File)directories.get(0);
        File bin = new File(archive, bindir);
        SliderUtils.verifyIsDir(bin, this.log);
        File scriptFile = new File(bin, script);
        SliderUtils.verifyFileExists(scriptFile, this.log);
        return scriptFile;
    }

    public static String getAdditionalArgs(Map<String, String> roleOptions) {
        String additionalArgs;
        if (roleOptions.containsKey("role.additional.args") && (additionalArgs = roleOptions.get("role.additional.args")) != null) {
            return additionalArgs;
        }
        return "";
    }

    public int getRoleResourceRequirement(String val, int defVal, int maxVal) {
        if (val == null) {
            val = Integer.toString(defVal);
        }
        Integer intVal = "max".equals(val) ? Integer.valueOf(maxVal) : Integer.decode(val);
        return intVal;
    }
}

