/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.zk;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingZKWatcher
implements Watcher {
    protected static final Logger log = LoggerFactory.getLogger(BlockingZKWatcher.class);
    private final AtomicBoolean connectedFlag = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        log.info("ZK binding callback received");
        this.connectedFlag.set(true);
        AtomicBoolean atomicBoolean = this.connectedFlag;
        synchronized (atomicBoolean) {
            try {
                this.connectedFlag.notify();
            }
            catch (Exception e) {
                log.warn("failed while waiting for notification", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForZKConnection(int timeout) throws InterruptedException, ConnectException {
        AtomicBoolean atomicBoolean = this.connectedFlag;
        synchronized (atomicBoolean) {
            if (!this.connectedFlag.get()) {
                log.info("waiting for ZK event");
                this.connectedFlag.wait(timeout);
            }
        }
        if (!this.connectedFlag.get()) {
            throw new ConnectException("Unable to connect to ZK quorum");
        }
    }
}

