/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.restclient;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.SSLException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.yarn.webapp.ForbiddenException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.slider.core.restclient.HttpOperationResponse;
import org.apache.slider.core.restclient.HttpVerb;
import org.apache.slider.core.restclient.SliderURLConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlConnectionOperations
extends Configured {
    private static final Logger log = LoggerFactory.getLogger(UrlConnectionOperations.class);
    private SliderURLConnectionFactory connectionFactory;
    private boolean useSpnego = false;

    public UrlConnectionOperations(Configuration conf) {
        super(conf);
        this.connectionFactory = SliderURLConnectionFactory.newInstance(conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            log.debug("SPNEGO is enabled");
            this.setUseSpnego(true);
        }
    }

    public boolean isUseSpnego() {
        return this.useSpnego;
    }

    public void setUseSpnego(boolean useSpnego) {
        this.useSpnego = useSpnego;
    }

    public HttpURLConnection openConnection(URL url) throws IOException, AuthenticationException {
        Preconditions.checkArgument(url.getPort() != 0, "no port");
        return (HttpURLConnection)this.connectionFactory.openConnection(url, this.useSpnego);
    }

    public HttpOperationResponse execGet(URL url) throws IOException, AuthenticationException {
        return this.execHttpOperation(HttpVerb.GET, url, null, "");
    }

    public HttpOperationResponse execHttpOperation(HttpVerb verb, URL url, byte[] payload, String contentType) throws IOException, AuthenticationException {
        int resultCode;
        HttpURLConnection conn = null;
        HttpOperationResponse outcome = new HttpOperationResponse();
        byte[] body = null;
        log.debug("{} {} spnego={}", new Object[]{verb, url, this.useSpnego});
        boolean doOutput = verb.hasUploadBody();
        if (doOutput) {
            Preconditions.checkArgument(payload != null, "Null payload on a verb which expects one");
        }
        try {
            try {
                conn = this.openConnection(url);
                conn.setRequestMethod(verb.getVerb());
                conn.setDoOutput(doOutput);
                if (doOutput) {
                    conn.setRequestProperty("Content-Type", contentType);
                }
                conn.connect();
                if (doOutput) {
                    OutputStream output = conn.getOutputStream();
                    IOUtils.write((byte[])payload, (OutputStream)output);
                    output.close();
                }
                resultCode = conn.getResponseCode();
                outcome.lastModified = conn.getLastModified();
                outcome.contentType = conn.getContentType();
                outcome.headers = conn.getHeaderFields();
                InputStream stream = conn.getErrorStream();
                if (stream == null) {
                    stream = conn.getInputStream();
                }
                if (stream != null) {
                    body = IOUtils.toByteArray((InputStream)stream);
                } else {
                    log.debug("No body in response");
                }
            }
            catch (SSLException e) {
                throw e;
            }
            catch (IOException e) {
                throw NetUtils.wrapException((String)url.toString(), (int)url.getPort(), (String)"localhost", (int)0, (IOException)e);
            }
            catch (AuthenticationException e) {
                throw new AuthenticationException("From " + url + ": " + (Object)((Object)e), (Throwable)e);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        UrlConnectionOperations.uprateFaults(HttpVerb.GET, url.toString(), resultCode, "", body);
        outcome.responseCode = resultCode;
        outcome.data = body;
        return outcome;
    }

    public static void uprateFaults(HttpVerb verb, String url, int resultCode, String bodyAsString, byte[] body) throws IOException {
        if (resultCode < 400) {
            return;
        }
        String msg = String.valueOf(verb.toString()) + " " + url;
        if (resultCode == 404) {
            throw new NotFoundException(msg);
        }
        if (resultCode == 401) {
            throw new ForbiddenException(msg);
        }
        if (bodyAsString == null) {
            bodyAsString = body != null && body.length > 0 ? new String(body) : "";
        }
        String message = String.valueOf(msg) + " failed with exit code " + resultCode + ", body length " + bodyAsString.length() + ":\n" + bodyAsString;
        log.error(message);
        throw new IOException(message);
    }
}

