/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.restclient;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.KerberosUgiAuthenticator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderURLConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(SliderURLConnectionFactory.class);
    public static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private final ConnectionConfigurator connConfigurator;
    private static final ConnectionConfigurator DEFAULT_CONFIGURATOR = new BasicConfigurator();

    public static SliderURLConnectionFactory newInstance(Configuration conf) {
        ConnectionConfigurator conn;
        try {
            conn = SliderURLConnectionFactory.newSslConnConfigurator(60000, conf);
        }
        catch (Exception e) {
            log.debug("Cannot load customized SSL configuration.", e);
            conn = DEFAULT_CONFIGURATOR;
        }
        return new SliderURLConnectionFactory(conn);
    }

    private SliderURLConnectionFactory(ConnectionConfigurator connConfigurator) {
        this.connConfigurator = connConfigurator;
    }

    private static ConnectionConfigurator newSslConnConfigurator(final int timeout, Configuration conf) throws IOException, GeneralSecurityException {
        SSLFactory factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        factory.init();
        final SSLSocketFactory sf = factory.createSSLSocketFactory();
        final HostnameVerifier hv = factory.getHostnameVerifier();
        return new ConnectionConfigurator(){

            public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection c = (HttpsURLConnection)conn;
                    c.setSSLSocketFactory(sf);
                    c.setHostnameVerifier(hv);
                }
                SliderURLConnectionFactory.setupConnection(conn, timeout);
                return conn;
            }
        };
    }

    public URLConnection openConnection(URL url) throws IOException {
        try {
            return this.openConnection(url, false);
        }
        catch (AuthenticationException authenticationException) {
            return null;
        }
    }

    public URLConnection openConnection(URL url, boolean isSpnego) throws IOException, AuthenticationException {
        if (isSpnego) {
            log.debug("open AuthenticatedURL connection {}", (Object)url);
            UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
            AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
            return new AuthenticatedURL((Authenticator)new KerberosUgiAuthenticator(), this.connConfigurator).openConnection(url, authToken);
        }
        log.debug("open URL connection {}", (Object)url);
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection) {
            this.connConfigurator.configure((HttpURLConnection)connection);
        }
        return connection;
    }

    private static void setupConnection(URLConnection connection, int socketTimeout) {
        connection.setConnectTimeout(socketTimeout);
        connection.setReadTimeout(socketTimeout);
        connection.setUseCaches(false);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setInstanceFollowRedirects(true);
        }
    }

    private static class BasicConfigurator
    implements ConnectionConfigurator {
        private BasicConfigurator() {
        }

        public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
            SliderURLConnectionFactory.setupConnection(conn, 60000);
            return conn;
        }
    }
}

