/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.registry.retrieve;

import com.beust.jcommander.Strings;
import com.sun.jersey.api.client.WebResource;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.registry.client.exceptions.RegistryIOException;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.slider.client.ClientRegistryBinder;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.registry.docstore.PublishedConfigSet;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.core.registry.docstore.PublishedExports;
import org.apache.slider.core.registry.docstore.PublishedExportsSet;
import org.apache.slider.core.registry.retrieve.AMWebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryRetriever
extends AMWebClient {
    private static final Logger log = LoggerFactory.getLogger(RegistryRetriever.class);
    private final String externalConfigurationURL;
    private final String internalConfigurationURL;
    private final String externalExportsURL;
    private final String internalExportsURL;

    public RegistryRetriever(Configuration conf, ServiceRecord record) throws RegistryIOException {
        super(conf);
        this.externalConfigurationURL = ClientRegistryBinder.lookupRestAPI(record, "classpath:org.apache.slider.publisher.configurations", true);
        this.internalConfigurationURL = ClientRegistryBinder.lookupRestAPI(record, "classpath:org.apache.slider.publisher.configurations", false);
        this.externalExportsURL = ClientRegistryBinder.lookupRestAPI(record, "classpath:org.apache.slider.publisher.exports", true);
        this.internalExportsURL = ClientRegistryBinder.lookupRestAPI(record, "classpath:org.apache.slider.publisher.exports", false);
    }

    public boolean hasConfigurations(boolean external) {
        return !Strings.isStringEmpty(external ? this.externalConfigurationURL : this.internalConfigurationURL);
    }

    public PublishedConfigSet getConfigurations(boolean external) throws FileNotFoundException, IOException {
        String confURL = this.getConfigurationURL(external);
        WebResource webResource = this.resource(confURL);
        return this.get(webResource, PublishedConfigSet.class);
    }

    protected String getConfigurationURL(boolean external) throws FileNotFoundException {
        String confURL;
        String string = confURL = external ? this.externalConfigurationURL : this.internalConfigurationURL;
        if (Strings.isStringEmpty(confURL)) {
            throw new FileNotFoundException("No configuration URL");
        }
        return confURL;
    }

    protected String getExportURL(boolean external) throws FileNotFoundException {
        String confURL;
        String string = confURL = external ? this.externalExportsURL : this.internalExportsURL;
        if (Strings.isStringEmpty(confURL)) {
            throw new FileNotFoundException("No configuration URL");
        }
        return confURL;
    }

    public PublishedExportsSet getExports(boolean external) throws FileNotFoundException, IOException {
        String exportsUrl = this.getExportURL(external);
        WebResource webResource = this.resource(exportsUrl);
        return this.get(webResource, PublishedExportsSet.class);
    }

    public PublishedConfiguration retrieveConfiguration(PublishedConfigSet configSet, String name, boolean external) throws IOException {
        String confURL = this.getConfigurationURL(external);
        if (!configSet.contains(name)) {
            throw new FileNotFoundException("Unknown configuration " + name);
        }
        confURL = SliderUtils.appendToURL(confURL, name);
        WebResource webResource = this.resource(confURL);
        return this.get(webResource, PublishedConfiguration.class);
    }

    public PublishedExports retrieveExports(PublishedExportsSet exportSet, String name, boolean external) throws IOException {
        if (!exportSet.contains(name)) {
            throw new FileNotFoundException("Unknown export " + name);
        }
        String exportsURL = this.getExportURL(external);
        exportsURL = SliderUtils.appendToURL(exportsURL, name);
        return this.get(this.resource(exportsURL), PublishedExports.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RegistryRetriever{");
        sb.append("externalConfigurationURL='").append(this.externalConfigurationURL).append('\'');
        sb.append(", internalConfigurationURL='").append(this.internalConfigurationURL).append('\'');
        sb.append(", externalExportsURL='").append(this.externalExportsURL).append('\'');
        sb.append(", internalExportsURL='").append(this.internalExportsURL).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

