/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.persist;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.persist.ConfTreeSerDeser;
import org.apache.slider.core.persist.LockAcquireFailedException;
import org.apache.slider.core.persist.LockHeldAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfPersister {
    private static final Logger log = LoggerFactory.getLogger(ConfPersister.class);
    private final ConfTreeSerDeser confTreeSerDeser = new ConfTreeSerDeser();
    private final CoreFileSystem coreFS;
    private final FileSystem fileSystem;
    private final Path persistDir;
    private final Path internal;
    private final Path resources;
    private final Path app_conf;
    private final Path writelock;
    private final Path readlock;

    public ConfPersister(CoreFileSystem coreFS, Path persistDir) {
        this.coreFS = coreFS;
        this.persistDir = persistDir;
        this.internal = new Path(persistDir, "internal.json");
        this.resources = new Path(persistDir, "resources.json");
        this.app_conf = new Path(persistDir, "app_config.json");
        this.writelock = new Path(persistDir, "writelock");
        this.readlock = new Path(persistDir, "readlock");
        this.fileSystem = coreFS.getFileSystem();
    }

    public Path getPersistDir() {
        return this.persistDir;
    }

    public void mkPersistDir() throws IOException {
        this.coreFS.getFileSystem().mkdirs(this.persistDir);
    }

    public String toString() {
        return "Persister to " + this.persistDir;
    }

    @VisibleForTesting
    void acquireWritelock() throws IOException, LockAcquireFailedException {
        boolean lockFailure;
        this.mkPersistDir();
        long now = System.currentTimeMillis();
        try {
            this.coreFS.cat(this.writelock, false, new Date(now).toGMTString());
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw new LockAcquireFailedException(this.writelock);
        }
        catch (IOException e) {
            throw new LockAcquireFailedException(this.writelock, (Throwable)e);
        }
        try {
            lockFailure = this.readLockExists();
        }
        catch (IOException iOException) {
            lockFailure = true;
        }
        if (lockFailure) {
            this.releaseWritelock();
            throw new LockAcquireFailedException(this.readlock);
        }
    }

    @VisibleForTesting
    boolean readLockExists() throws IOException {
        return this.fileSystem.exists(this.readlock);
    }

    @VisibleForTesting
    boolean releaseWritelock() {
        try {
            return this.fileSystem.delete(this.writelock, false);
        }
        catch (IOException e) {
            log.warn("IOException releasing writelock {} ", (Object)this.writelock, (Object)e);
            return false;
        }
    }

    @VisibleForTesting
    boolean acquireReadLock() throws FileNotFoundException, IOException, LockAcquireFailedException {
        boolean lockFailure;
        boolean owner;
        if (!this.coreFS.getFileSystem().exists(this.persistDir)) {
            throw new FileNotFoundException(this.persistDir.toString());
        }
        long now = System.currentTimeMillis();
        try {
            this.coreFS.cat(this.readlock, false, new Date(now).toGMTString());
            owner = true;
        }
        catch (IOException iOException) {
            owner = false;
        }
        try {
            lockFailure = this.writelockExists();
        }
        catch (IOException iOException) {
            lockFailure = true;
        }
        if (lockFailure) {
            this.releaseReadlock(owner);
            throw new LockAcquireFailedException(this.writelock);
        }
        return owner;
    }

    @VisibleForTesting
    boolean writelockExists() throws IOException {
        return this.fileSystem.exists(this.writelock);
    }

    @VisibleForTesting
    boolean releaseReadlock(boolean owner) {
        if (owner) {
            try {
                return this.fileSystem.delete(this.readlock, false);
            }
            catch (IOException e) {
                log.warn("IOException releasing writelock {} ", (Object)this.readlock, (Object)e);
            }
        }
        return false;
    }

    private void saveConf(AggregateConf conf) throws IOException {
        this.confTreeSerDeser.save(this.fileSystem, this.internal, conf.getInternal(), true);
        this.confTreeSerDeser.save(this.fileSystem, this.resources, conf.getResources(), true);
        this.confTreeSerDeser.save(this.fileSystem, this.app_conf, conf.getAppConf(), true);
    }

    private void loadConf(AggregateConf conf) throws IOException {
        conf.setInternal((ConfTree)this.confTreeSerDeser.load(this.fileSystem, this.internal));
        conf.setResources((ConfTree)this.confTreeSerDeser.load(this.fileSystem, this.resources));
        conf.setAppConf((ConfTree)this.confTreeSerDeser.load(this.fileSystem, this.app_conf));
    }

    private void maybeExecLockHeldAction(LockHeldAction action) throws IOException, SliderException {
        if (action != null) {
            action.execute();
        }
    }

    public void save(AggregateConf conf, LockHeldAction action) throws IOException, SliderException, LockAcquireFailedException {
        this.acquireWritelock();
        try {
            this.saveConf(conf);
            this.maybeExecLockHeldAction(action);
        }
        finally {
            this.releaseWritelock();
        }
    }

    public void load(AggregateConf conf) throws FileNotFoundException, IOException, SliderException, LockAcquireFailedException {
        boolean owner = this.acquireReadLock();
        try {
            this.loadConf(conf);
        }
        finally {
            this.releaseReadlock(owner);
        }
    }
}

