/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.main;

import java.io.IOException;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class IrqHandler
implements SignalHandler {
    public static final String CONTROL_C = "INT";
    public static final String SIGTERM = "TERM";
    private final String name;
    private final Interrupted handler;

    public IrqHandler(String name, Interrupted handler) throws IOException {
        this.handler = handler;
        this.name = name;
        try {
            Signal.handle(new Signal(name), this);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Could not set handler for signal \"" + name + "\"." + "This can happen if the JVM has the -Xrs set.", e);
        }
    }

    public String toString() {
        return "IrqHandler for signal " + this.name;
    }

    @Override
    public void handle(Signal signal) {
        InterruptData data = new InterruptData(signal.getName(), signal.getNumber());
        this.handler.interrupted(data);
    }

    public static class InterruptData {
        public final String name;
        public final int number;

        public InterruptData(String name, int number) {
            this.name = name;
            this.number = number;
        }

        public String toString() {
            return "signal " + this.name + '(' + this.number + ')';
        }
    }

    public static interface Interrupted {
        public void interrupted(InterruptData var1);
    }
}

