/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.build;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.build.BuildHelper;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.persist.ConfPersister;
import org.apache.slider.core.persist.InstancePaths;
import org.apache.slider.core.persist.LockAcquireFailedException;
import org.apache.slider.core.persist.LockHeldAction;
import org.apache.slider.core.zk.ZKPathBuilder;
import org.apache.slider.core.zk.ZookeeperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceBuilder {
    private final String clustername;
    private final Configuration conf;
    private final CoreFileSystem coreFS;
    private final InstancePaths instancePaths;
    private AggregateConf instanceDescription;
    private static final Logger log = LoggerFactory.getLogger(InstanceBuilder.class);

    public InstanceBuilder(CoreFileSystem coreFileSystem, Configuration conf, String clustername) {
        this.clustername = clustername;
        this.conf = conf;
        this.coreFS = coreFileSystem;
        Path instanceDir = coreFileSystem.buildClusterDirPath(clustername);
        this.instancePaths = new InstancePaths(instanceDir);
    }

    public AggregateConf getInstanceDescription() {
        return this.instanceDescription;
    }

    public InstancePaths getInstancePaths() {
        return this.instancePaths;
    }

    public String toString() {
        return "Builder working with " + this.clustername + " at " + this.getInstanceDir();
    }

    private Path getInstanceDir() {
        return this.instancePaths.instanceDir;
    }

    public void init(String provider, AggregateConf instanceConf) {
        this.instanceDescription = instanceConf;
        ConfTreeOperations internalOps = instanceConf.getInternalOperations();
        Map<String, Object> md = internalOps.getConfTree().metadata;
        long time = System.currentTimeMillis();
        md.put("create.time", SliderUtils.toGMTString(time));
        md.put("create.time.millis", Long.toString(time));
        internalOps.getGlobalOptions();
        BuildHelper.addBuildMetadata(md, "create");
        SliderUtils.setInfoTime(md, "create.time", "create.time.millis", System.currentTimeMillis());
        internalOps.set("internal.am.tmp.dir", this.instancePaths.tmpPathAM.toUri());
        internalOps.set("internal.tmp.dir", this.instancePaths.tmpPath.toUri());
        internalOps.set("internal.snapshot.conf.path", this.instancePaths.snapshotConfPath.toUri());
        internalOps.set("internal.generated.conf.path", this.instancePaths.generatedConfPath.toUri());
        internalOps.set("internal.data.dir.path", this.instancePaths.dataPath.toUri());
        internalOps.set("internal.appdef.dir.path", this.instancePaths.appDefPath.toUri());
        internalOps.set("internal.addons.dir.path", this.instancePaths.addonsPath.toUri());
        internalOps.set("internal.provider.name", provider);
        internalOps.set("application.name", this.clustername);
    }

    public void setQueue(String queue) throws BadConfigException {
        if (queue != null) {
            if (SliderUtils.isUnset(queue)) {
                throw new BadConfigException("Queue value cannot be empty.");
            }
            this.instanceDescription.getInternalOperations().set("internal.queue", queue);
        }
    }

    public void setImageDetailsIfAvailable(Path appImage, String appHomeDir) throws BadConfigException {
        boolean appHomeUnset = SliderUtils.isUnset(appHomeDir);
        if (appImage != null) {
            if (!appHomeUnset) {
                throw new BadConfigException("Both application image path and home dir have been provided");
            }
            this.instanceDescription.getInternalOperations().set("internal.application.image.path", appImage.toUri());
        } else if (!appHomeUnset) {
            this.instanceDescription.getInternalOperations().set("internal.application.home", appHomeDir);
        }
    }

    public void propagatePrincipals() {
        String dfsPrincipal = this.conf.get("dfs.namenode.kerberos.principal");
        if (dfsPrincipal != null) {
            String siteDfsPrincipal = "site.dfs.namenode.kerberos.principal";
            this.instanceDescription.getAppConfOperations().set(siteDfsPrincipal, dfsPrincipal);
        }
    }

    public void propagateFilename() {
        String fsDefaultName = this.conf.get("fs.defaultFS");
        this.instanceDescription.getAppConfOperations().set("site.fs.defaultFS", fsDefaultName);
        this.instanceDescription.getAppConfOperations().set("site.fs.default.name", fsDefaultName);
    }

    public void takeSnapshotOfConfDir(Path appconfdir) throws IOException, BadConfigException, BadClusterStateException {
        FileSystem srcFS = FileSystem.get((URI)appconfdir.toUri(), (Configuration)this.conf);
        if (!srcFS.isDirectory(appconfdir)) {
            throw new BadConfigException("Source Configuration directory is not valid: %s", appconfdir.toString());
        }
        FsPermission clusterPerms = this.coreFS.getInstanceDirectoryPermissions();
        SliderUtils.copyDirectory(this.conf, appconfdir, this.instancePaths.snapshotConfPath, clusterPerms);
    }

    public void persist(Path appconfdir, boolean overwrite) throws IOException, SliderException, LockAcquireFailedException {
        if (!overwrite) {
            this.coreFS.createClusterDirectories(this.instancePaths);
        }
        ConfPersister persister = new ConfPersister(this.coreFS, this.getInstanceDir());
        ConfDirSnapshotAction action = null;
        if (appconfdir != null) {
            action = new ConfDirSnapshotAction(appconfdir);
        }
        persister.save(this.instanceDescription, action);
    }

    public void addZKBinding(ZKPathBuilder zkBinding) throws BadConfigException {
        String quorum = zkBinding.getAppQuorum();
        if (SliderUtils.isSet(quorum)) {
            MapOperations globalAppOptions = this.instanceDescription.getAppConfOperations().getGlobalOptions();
            globalAppOptions.put("zookeeper.path", zkBinding.getAppPath());
            globalAppOptions.put("zookeeper.quorum", quorum);
            globalAppOptions.put("zookeeper.hosts", ZookeeperUtils.convertToHostsOnlyList(quorum));
        }
    }

    private class ConfDirSnapshotAction
    implements LockHeldAction {
        private final Path appconfdir;

        private ConfDirSnapshotAction(Path appconfdir) {
            this.appconfdir = appconfdir;
        }

        @Override
        public void execute() throws IOException, SliderException {
            InstanceBuilder.this.takeSnapshotOfConfDir(this.appconfdir);
        }
    }
}

