/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.Endpoint;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.security.KerberosDiags;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.ClusterNode;
import org.apache.slider.api.SliderApplicationApi;
import org.apache.slider.api.SliderClusterProtocol;
import org.apache.slider.api.proto.Messages;
import org.apache.slider.api.types.ContainerInformation;
import org.apache.slider.api.types.NodeInformationList;
import org.apache.slider.api.types.SliderInstanceDescription;
import org.apache.slider.client.SliderClientAPI;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.client.ipc.SliderApplicationIpcClient;
import org.apache.slider.client.ipc.SliderClusterOperations;
import org.apache.slider.common.SliderExitCodes;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.common.params.AbstractClusterBuildingActionArgs;
import org.apache.slider.common.params.ActionAMSuicideArgs;
import org.apache.slider.common.params.ActionClientArgs;
import org.apache.slider.common.params.ActionCreateArgs;
import org.apache.slider.common.params.ActionDependencyArgs;
import org.apache.slider.common.params.ActionDestroyArgs;
import org.apache.slider.common.params.ActionDiagnosticArgs;
import org.apache.slider.common.params.ActionEchoArgs;
import org.apache.slider.common.params.ActionExistsArgs;
import org.apache.slider.common.params.ActionFlexArgs;
import org.apache.slider.common.params.ActionFreezeArgs;
import org.apache.slider.common.params.ActionInstallKeytabArgs;
import org.apache.slider.common.params.ActionInstallPackageArgs;
import org.apache.slider.common.params.ActionKDiagArgs;
import org.apache.slider.common.params.ActionKeytabArgs;
import org.apache.slider.common.params.ActionKillContainerArgs;
import org.apache.slider.common.params.ActionListArgs;
import org.apache.slider.common.params.ActionLookupArgs;
import org.apache.slider.common.params.ActionNodesArgs;
import org.apache.slider.common.params.ActionPackageArgs;
import org.apache.slider.common.params.ActionRegistryArgs;
import org.apache.slider.common.params.ActionResolveArgs;
import org.apache.slider.common.params.ActionStatusArgs;
import org.apache.slider.common.params.ActionThawArgs;
import org.apache.slider.common.params.ActionUpgradeArgs;
import org.apache.slider.common.params.ClientArgs;
import org.apache.slider.common.params.CommonArgs;
import org.apache.slider.common.params.LaunchArgsAccessor;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.Duration;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.common.tools.SliderVersionInfo;
import org.apache.slider.core.build.InstanceBuilder;
import org.apache.slider.core.build.InstanceIO;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.conf.ResourcesInputPropertiesValidator;
import org.apache.slider.core.conf.TemplateInputPropertiesValidator;
import org.apache.slider.core.exceptions.BadClusterStateException;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.ErrorStrings;
import org.apache.slider.core.exceptions.NoSuchNodeException;
import org.apache.slider.core.exceptions.NotFoundException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.exceptions.UnknownApplicationInstanceException;
import org.apache.slider.core.exceptions.UsageException;
import org.apache.slider.core.exceptions.WaitTimeoutException;
import org.apache.slider.core.launch.AppMasterLauncher;
import org.apache.slider.core.launch.ClasspathConstructor;
import org.apache.slider.core.launch.JavaCommandLineBuilder;
import org.apache.slider.core.launch.LaunchedApplication;
import org.apache.slider.core.launch.RunningApplication;
import org.apache.slider.core.launch.SerializedApplicationReport;
import org.apache.slider.core.main.RunService;
import org.apache.slider.core.persist.AppDefinitionPersister;
import org.apache.slider.core.persist.ApplicationReportSerDeser;
import org.apache.slider.core.persist.ConfPersister;
import org.apache.slider.core.persist.JsonSerDeser;
import org.apache.slider.core.persist.LockAcquireFailedException;
import org.apache.slider.core.registry.SliderRegistryUtils;
import org.apache.slider.core.registry.YarnAppListClient;
import org.apache.slider.core.registry.docstore.ConfigFormat;
import org.apache.slider.core.registry.docstore.PublishedConfigSet;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.core.registry.docstore.PublishedConfigurationOutputter;
import org.apache.slider.core.registry.docstore.PublishedExports;
import org.apache.slider.core.registry.docstore.PublishedExportsOutputter;
import org.apache.slider.core.registry.docstore.PublishedExportsSet;
import org.apache.slider.core.registry.retrieve.RegistryRetriever;
import org.apache.slider.core.zk.BlockingZKWatcher;
import org.apache.slider.core.zk.ZKIntegration;
import org.apache.slider.core.zk.ZKPathBuilder;
import org.apache.slider.providers.AbstractClientProvider;
import org.apache.slider.providers.SliderProviderFactory;
import org.apache.slider.providers.slideram.SliderAMClientProvider;
import org.apache.slider.server.appmaster.rpc.RpcBinder;
import org.apache.slider.server.services.security.SecurityStore;
import org.apache.slider.server.services.utility.AbstractSliderLaunchedService;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderClient
extends AbstractSliderLaunchedService
implements RunService,
SliderExitCodes,
SliderKeys,
ErrorStrings,
SliderClientAPI {
    private static final Logger log = LoggerFactory.getLogger(SliderClient.class);
    public static final String E_MUST_BE_A_VALID_JSON_FILE = "Invalid configuration. Must be a valid json file.";
    public static final String E_INVALID_INSTALL_LOCATION = "A valid install location must be provided for the client.";
    public static final String E_UNABLE_TO_READ_SUPPLIED_PACKAGE_FILE = "Unable to read supplied package file";
    public static final String E_INVALID_APPLICATION_PACKAGE_LOCATION = "A valid application package location required.";
    public static final String E_INVALID_INSTALL_PATH = "Install path is not a valid directory";
    public static final String E_INSTALL_PATH_DOES_NOT_EXIST = "Install path does not exist";
    public static final String E_INVALID_APPLICATION_TYPE_NAME = "A valid application type name is required (e.g. HBASE).";
    public static final String E_USE_REPLACEPKG_TO_OVERWRITE = "Use --replacepkg to overwrite.";
    public static final String E_PACKAGE_DOES_NOT_EXIST = "Package does not exist";
    public static final String E_NO_ZOOKEEPER_QUORUM = "No Zookeeper quorum defined";
    public static final String E_NO_RESOURCE_MANAGER = "No valid Resource Manager address provided";
    public static final String E_PACKAGE_EXISTS = "Package exists";
    private static PrintStream clientOutputStream = System.out;
    private static final String PASSWORD_PROMPT = "Enter password for";
    private ClientArgs serviceArgs;
    public ApplicationId applicationId;
    private String deployedClusterName;
    private SliderClusterOperations sliderClusterOperations;
    protected SliderFileSystem sliderFileSystem;
    private SliderYarnClientImpl yarnClient;
    private YarnAppListClient yarnAppListClient;
    private AggregateConf launchedInstanceDefinition;
    private RegistryOperations registryOperations;

    public SliderClient() {
        super("Slider Client");
        new HdfsConfiguration();
        new YarnConfiguration();
    }

    @Override
    public Configuration bindArgs(Configuration config, String ... args) throws Exception {
        config = super.bindArgs(config, args);
        this.serviceArgs = new ClientArgs(args);
        this.serviceArgs.parse();
        ConfigHelper.injectSliderXMLResource();
        YarnConfiguration yarnConfiguration = new YarnConfiguration(config);
        return SliderUtils.patchConfiguration((Configuration)yarnConfiguration);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        Configuration clientConf = SliderUtils.loadSliderClientXML();
        ConfigHelper.mergeConfigurations(conf, (Iterable<Map.Entry<String, String>>)clientConf, "slider-client.xml", true);
        this.serviceArgs.applyDefinitions(conf);
        this.serviceArgs.applyFileSystemBinding(conf);
        AbstractActionArgs coreAction = this.serviceArgs.getCoreAction();
        if (!coreAction.disableSecureLogin() && SliderUtils.isHadoopClusterSecure(conf)) {
            SliderUtils.forceLogin();
            SliderUtils.initProcessSecurity(conf);
        }
        if (coreAction.getHadoopServicesRequired()) {
            this.initHadoopBinding();
        }
        super.serviceInit(conf);
    }

    @Override
    public int runService() throws Throwable {
        try {
            return this.exec();
        }
        catch (FileNotFoundException | PathNotFoundException nfe) {
            throw new NotFoundException(nfe, nfe.toString(), new Object[0]);
        }
    }

    public int exec() throws Throwable {
        String action = this.serviceArgs.getAction();
        if (SliderClient.isUnset(action)) {
            throw new SliderException(4, this.serviceArgs.usage());
        }
        int exitCode = 0;
        String clusterName = this.serviceArgs.getClusterName();
        switch (action) {
            case "am-suicide": {
                exitCode = this.actionAmSuicide(clusterName, this.serviceArgs.getActionAMSuicideArgs());
                break;
            }
            case "build": {
                exitCode = this.actionBuild(clusterName, this.serviceArgs.getActionBuildArgs());
                break;
            }
            case "client": {
                exitCode = this.actionClient(this.serviceArgs.getActionClientArgs());
                break;
            }
            case "create": {
                exitCode = this.actionCreate(clusterName, this.serviceArgs.getActionCreateArgs());
                break;
            }
            case "dependency": {
                exitCode = this.actionDependency(this.serviceArgs.getActionDependencyArgs());
                break;
            }
            case "destroy": {
                exitCode = this.actionDestroy(clusterName, this.serviceArgs.getActionDestroyArgs());
                break;
            }
            case "diagnostics": {
                exitCode = this.actionDiagnostic(this.serviceArgs.getActionDiagnosticArgs());
                break;
            }
            case "exists": {
                exitCode = this.actionExists(clusterName, this.serviceArgs.getActionExistsArgs());
                break;
            }
            case "flex": {
                exitCode = this.actionFlex(clusterName, this.serviceArgs.getActionFlexArgs());
                break;
            }
            case "stop": {
                exitCode = this.actionFreeze(clusterName, this.serviceArgs.getActionFreezeArgs());
                break;
            }
            case "help": {
                log.info(this.serviceArgs.usage());
                break;
            }
            case "kdiag": {
                exitCode = this.actionKDiag(this.serviceArgs.getActionKDiagArgs());
                break;
            }
            case "kill-container": {
                exitCode = this.actionKillContainer(clusterName, this.serviceArgs.getActionKillContainerArgs());
                break;
            }
            case "install-keytab": {
                exitCode = this.actionInstallKeytab(this.serviceArgs.getActionInstallKeytabArgs());
                break;
            }
            case "install-package": {
                exitCode = this.actionInstallPkg(this.serviceArgs.getActionInstallPackageArgs());
                break;
            }
            case "keytab": {
                exitCode = this.actionKeytab(this.serviceArgs.getActionKeytabArgs());
                break;
            }
            case "list": {
                exitCode = this.actionList(clusterName, this.serviceArgs.getActionListArgs());
                break;
            }
            case "lookup": {
                exitCode = this.actionLookup(this.serviceArgs.getActionLookupArgs());
                break;
            }
            case "nodes": {
                exitCode = this.actionNodes("", this.serviceArgs.getActionNodesArgs());
                break;
            }
            case "package": {
                exitCode = this.actionPackage(this.serviceArgs.getActionPackageArgs());
                break;
            }
            case "registry": {
                exitCode = this.actionRegistry(this.serviceArgs.getActionRegistryArgs());
                break;
            }
            case "resolve": {
                exitCode = this.actionResolve(this.serviceArgs.getActionResolveArgs());
                break;
            }
            case "status": {
                exitCode = this.actionStatus(clusterName, this.serviceArgs.getActionStatusArgs());
                break;
            }
            case "start": {
                exitCode = this.actionThaw(clusterName, this.serviceArgs.getActionThawArgs());
                break;
            }
            case "update": {
                exitCode = this.actionUpdate(clusterName, this.serviceArgs.getActionUpdateArgs());
                break;
            }
            case "upgrade": {
                exitCode = this.actionUpgrade(clusterName, this.serviceArgs.getActionUpgradeArgs());
                break;
            }
            case "version": {
                exitCode = this.actionVersion();
                break;
            }
            default: {
                throw new SliderException(51, "Unimplemented: " + action);
            }
        }
        return exitCode;
    }

    protected void initHadoopBinding() throws IOException, SliderException {
        SliderUtils.validateSliderClientEnvironment(null);
        this.yarnClient = new SliderYarnClientImpl();
        this.yarnClient.init(this.getConfig());
        if (this.getServiceState() == Service.STATE.STARTED) {
            this.yarnClient.start();
        }
        this.addService((Service)this.yarnClient);
        this.yarnAppListClient = new YarnAppListClient(this.yarnClient, this.getUsername(), this.getConfig());
        this.sliderFileSystem = new SliderFileSystem(this.getConfig());
    }

    @VisibleForTesting
    public boolean deleteZookeeperNode(String clusterName) throws YarnException, IOException {
        String user = this.getUsername();
        String zkPath = ZKIntegration.mkClusterPath(user, clusterName);
        Object e = null;
        try {
            this.getConfig();
            ZKIntegration client = this.getZkClient(clusterName, user);
            if (client != null) {
                if (client.exists(zkPath)) {
                    log.info("Deleting zookeeper path {}", (Object)zkPath);
                }
                client.deleteRecursive(zkPath);
                return true;
            }
        }
        catch (InterruptedException | BadConfigException | KeeperException ex) {
            e = ex;
        }
        if (e != null) {
            log.warn("Unable to recursively delete zk node {}", (Object)zkPath, e);
        }
        return false;
    }

    @VisibleForTesting
    public String createZookeeperNode(String clusterName, Boolean nameOnly) throws YarnException, IOException {
        try {
            return this.createZookeeperNodeInner(clusterName, nameOnly);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            return null;
        }
        catch (KeeperException keeperException) {
            return null;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
    }

    @VisibleForTesting
    public String createZookeeperNodeInner(String clusterName, Boolean nameOnly) throws YarnException, IOException, KeeperException, InterruptedException {
        String user = this.getUsername();
        String zkPath = ZKIntegration.mkClusterPath(user, clusterName);
        if (nameOnly.booleanValue()) {
            return zkPath;
        }
        ZKIntegration client = this.getZkClient(clusterName, user);
        if (client != null) {
            ArrayList<ACL> zkperms = new ArrayList<ACL>();
            if (UserGroupInformation.isSecurityEnabled()) {
                zkperms.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
                zkperms.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            } else {
                zkperms.add(new ACL(31, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            }
            client.createPath(zkPath, "", zkperms, CreateMode.PERSISTENT);
            return zkPath;
        }
        return null;
    }

    protected ZKIntegration getZkClient(String clusterName, String user) throws YarnException {
        String registryQuorum = this.lookupZKQuorum();
        ZKIntegration client = null;
        try {
            BlockingZKWatcher watcher = new BlockingZKWatcher();
            client = ZKIntegration.newInstance(registryQuorum, user, clusterName, true, false, watcher, ZKIntegration.SESSION_TIMEOUT);
            client.init();
            watcher.waitForZKConnection(2000);
        }
        catch (InterruptedException e) {
            client = null;
            log.warn("Unable to connect to zookeeper quorum {}", (Object)registryQuorum, (Object)e);
        }
        catch (IOException e) {
            log.warn("Unable to connect to zookeeper quorum {}", (Object)registryQuorum, (Object)e);
        }
        return client;
    }

    @Override
    public int actionDestroy(String clustername) throws YarnException, IOException {
        ActionDestroyArgs destroyArgs = new ActionDestroyArgs();
        destroyArgs.force = true;
        return this.actionDestroy(clustername, destroyArgs);
    }

    @Override
    public int actionDestroy(String clustername, ActionDestroyArgs destroyArgs) throws YarnException, IOException {
        SliderUtils.validateClusterName(clustername);
        this.verifyBindingsDefined();
        this.verifyNoLiveClusters(clustername, "Destroy");
        boolean forceDestroy = destroyArgs.force;
        log.debug("actionDestroy({}, force={})", (Object)clustername, (Object)forceDestroy);
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(clustername);
        FileSystem fs = this.sliderFileSystem.getFileSystem();
        boolean exists = fs.exists(clusterDirectory);
        if (exists) {
            log.debug("Application Instance {} found at {}: destroying", (Object)clustername, (Object)clusterDirectory);
            if (!forceDestroy) {
                throw new UsageException("Destroy will permanently delete directories and registries. Reissue this command with the --force option if you want to proceed.", new Object[0]);
            }
            if (!fs.delete(clusterDirectory, true)) {
                log.warn("Filesystem returned false from delete() operation");
            }
            if (!this.deleteZookeeperNode(clustername)) {
                log.warn("Unable to perform node cleanup in Zookeeper.");
            }
            if (fs.exists(clusterDirectory)) {
                log.warn("Failed to delete {}", (Object)clusterDirectory);
            }
        } else {
            log.debug("Application Instance {} already destroyed", (Object)clustername);
        }
        String registryPath = SliderRegistryUtils.registryPathForInstance(clustername);
        try {
            this.getRegistryOperations().delete(registryPath, true);
        }
        catch (IOException e) {
            log.warn("Error deleting registry entry {}: {} ", registryPath, e, e);
        }
        catch (SliderException e) {
            log.warn("Error binding to registry {} ", (Object)e, (Object)e);
        }
        List<ApplicationReport> instances = this.findAllLiveInstances(clustername);
        if (!instances.isEmpty()) {
            throw new SliderException(73, String.valueOf(clustername) + ": " + "created while it was being destroyed" + " :" + instances.get(0));
        }
        log.info("Destroyed cluster {}", (Object)clustername);
        return 0;
    }

    @Override
    public int actionAmSuicide(String clustername, ActionAMSuicideArgs args) throws YarnException, IOException {
        SliderClusterOperations clusterOperations = this.createClusterOperations(clustername);
        clusterOperations.amSuicide(args.message, args.exitcode, args.waittime);
        return 0;
    }

    @Override
    public AbstractClientProvider createClientProvider(String provider) throws SliderException {
        SliderProviderFactory factory = SliderProviderFactory.createSliderProviderFactory(provider);
        return factory.createClientProvider();
    }

    public int actionCreate(String clustername, ActionCreateArgs createArgs) throws YarnException, IOException {
        this.actionBuild(clustername, createArgs);
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(clustername);
        AggregateConf instanceDefinition = this.loadInstanceDefinitionUnresolved(clustername, clusterDirectory);
        try {
            SliderClient.checkForCredentials(this.getConfig(), instanceDefinition.getAppConf());
        }
        catch (IOException e) {
            this.sliderFileSystem.getFileSystem().delete(clusterDirectory, true);
            throw e;
        }
        return this.startCluster(clustername, createArgs);
    }

    @Override
    public int actionUpgrade(String clustername, ActionUpgradeArgs upgradeArgs) throws YarnException, IOException {
        File template = upgradeArgs.template;
        File resources = upgradeArgs.resources;
        List<String> containers = upgradeArgs.containers;
        List<String> components = upgradeArgs.components;
        SliderClient.require(template == null || resources != null, "Option %s must be specified with option %s", "--resources", "--template");
        SliderClient.require(resources == null || template != null, "Option %s must be specified with option %s", "--template", "--resources");
        if (template != null && resources != null) {
            SliderClient.require(CollectionUtils.isEmpty(containers), "Option %s cannot be specified with %s or %s", "--containers", "--template", "--resources");
            SliderClient.require(CollectionUtils.isEmpty(components), "Option %s cannot be specified with %s or %s", "--components", "--template", "--resources");
            if (!this.isAppInRunningState(clustername)) {
                return 0;
            }
            this.buildInstanceDefinition(clustername, upgradeArgs, true, true, true);
            SliderClusterOperations clusterOperations = this.createClusterOperations(clustername);
            clusterOperations.amSuicide("AM restarted for application upgrade", 1, 1000);
            return 0;
        }
        return this.actionUpgradeContainers(clustername, upgradeArgs);
    }

    private int actionUpgradeContainers(String clustername, ActionUpgradeArgs upgradeArgs) throws YarnException, IOException {
        this.verifyBindingsDefined();
        SliderUtils.validateClusterName(clustername);
        int waittime = upgradeArgs.getWaittime();
        String text = "Upgrade containers";
        log.debug("actionUpgradeContainers({}, reason={}, wait={})", clustername, text, waittime);
        if (!this.isAppInRunningState(clustername)) {
            return 0;
        }
        HashSet<String> containers = new HashSet<String>();
        if (upgradeArgs.containers != null) {
            containers.addAll(new ArrayList<String>(upgradeArgs.containers));
        }
        HashSet<String> components = new HashSet<String>();
        if (upgradeArgs.components != null) {
            components.addAll(new ArrayList<String>(upgradeArgs.components));
        }
        List<ContainerInformation> liveContainers = this.getContainers(clustername);
        HashSet<String> validContainers = new HashSet<String>();
        HashSet<String> validComponents = new HashSet<String>();
        for (ContainerInformation liveContainer : liveContainers) {
            boolean allContainersAndComponentsAccountedFor = true;
            if (CollectionUtils.isNotEmpty(containers)) {
                if (containers.contains(liveContainer.containerId)) {
                    containers.remove(liveContainer.containerId);
                    validContainers.add(liveContainer.containerId);
                }
                allContainersAndComponentsAccountedFor = false;
            }
            if (CollectionUtils.isNotEmpty(components)) {
                if (components.contains(liveContainer.component)) {
                    components.remove(liveContainer.component);
                    validComponents.add(liveContainer.component);
                }
                allContainersAndComponentsAccountedFor = false;
            }
            if (allContainersAndComponentsAccountedFor) break;
        }
        if (CollectionUtils.isNotEmpty(containers)) {
            log.warn("Invalid set of containers provided {}", (Object)containers);
        }
        if (CollectionUtils.isNotEmpty(components)) {
            log.warn("Invalid set of components provided {}", (Object)components);
        }
        if (CollectionUtils.isEmpty(validContainers) && CollectionUtils.isEmpty(validComponents)) {
            log.error("Not a single valid container or component specified. Nothing to do.");
            return 44;
        }
        SliderClusterProtocol appMaster = this.connect(this.findInstance(clustername));
        Messages.UpgradeContainersRequestProto r = Messages.UpgradeContainersRequestProto.newBuilder().setMessage(text).addAllContainer(validContainers).addAllComponent(validComponents).build();
        appMaster.upgradeContainers(r);
        log.info("Cluster upgrade issued for -");
        if (CollectionUtils.isNotEmpty(validContainers)) {
            log.info(" Containers (total {}): {}", (Object)validContainers.size(), (Object)validContainers);
        }
        if (CollectionUtils.isNotEmpty(validComponents)) {
            log.info(" Components (total {}): {}", (Object)validComponents.size(), (Object)validComponents);
        }
        return 0;
    }

    private boolean isAppInRunningState(String clustername) throws YarnException, IOException {
        this.sliderFileSystem.locateInstanceDefinition(clustername);
        ApplicationReport app = this.findInstance(clustername);
        if (app == null) {
            log.info("Cluster {} not running", (Object)clustername);
            return false;
        }
        log.debug("App to upgrade was found: {}:\n{}", (Object)clustername, (Object)new SliderUtils.OnDemandReportStringifier(app));
        if (app.getYarnApplicationState().ordinal() >= YarnApplicationState.FINISHED.ordinal()) {
            log.info("Cluster {} is in a terminated state {}. Use command '{}' instead.", clustername, app.getYarnApplicationState(), "update");
            return false;
        }
        if (app.getYarnApplicationState().ordinal() < YarnApplicationState.RUNNING.ordinal()) {
            log.info("Cluster {} is in a pre-running state {}. To upgrade it needs to be RUNNING.", (Object)clustername, (Object)app.getYarnApplicationState());
            return false;
        }
        return true;
    }

    private static void checkForCredentials(Configuration conf, ConfTree tree) throws IOException {
        if (tree.credentials == null || tree.credentials.isEmpty()) {
            log.info("No credentials requested");
            return;
        }
        BufferedReader br = null;
        try {
            for (Map.Entry<String, List<String>> cred : tree.credentials.entrySet()) {
                String provider = cred.getKey();
                List<String> aliases = cred.getValue();
                if (aliases == null || aliases.isEmpty()) continue;
                Configuration c = new Configuration(conf);
                c.set("hadoop.security.credential.provider.path", provider);
                CredentialProvider credentialProvider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)c).get(0);
                HashSet existingAliases = new HashSet(credentialProvider.getAliases());
                for (String alias : aliases) {
                    if (existingAliases.contains(alias.toLowerCase(Locale.ENGLISH))) {
                        log.info("Credentials for " + alias + " found in " + provider);
                        continue;
                    }
                    if (br == null) {
                        br = new BufferedReader(new InputStreamReader(System.in));
                    }
                    char[] pass = SliderClient.readPassword(alias, br);
                    credentialProvider.createCredentialEntry(alias, pass);
                    credentialProvider.flush();
                    Arrays.fill(pass, ' ');
                }
            }
        }
        finally {
            IOUtils.closeStream(br);
        }
    }

    private static char[] readOnePassword(String alias) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in));){
            return SliderClient.readPassword(alias, br);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static char[] readPassword(String alias, BufferedReader br) throws IOException {
        boolean noMatch;
        char[] cred = null;
        do {
            log.info(String.format("%s %s: ", PASSWORD_PROMPT, alias));
            char[] newPassword1 = br.readLine().toCharArray();
            log.info(String.format("%s %s again: ", PASSWORD_PROMPT, alias));
            char[] newPassword2 = br.readLine().toCharArray();
            boolean bl = noMatch = !Arrays.equals(newPassword1, newPassword2);
            if (noMatch) {
                if (newPassword1 != null) {
                    Arrays.fill(newPassword1, ' ');
                }
                log.info(String.format("Passwords don't match. Try again.", new Object[0]));
            } else {
                cred = newPassword1;
            }
            if (newPassword2 == null) continue;
            Arrays.fill(newPassword2, ' ');
        } while (noMatch);
        if (cred == null) {
            throw new IOException("Could not read credentials for " + alias + " from stdin");
        }
        return cred;
    }

    @Override
    public int actionBuild(String clustername, AbstractClusterBuildingActionArgs buildInfo) throws YarnException, IOException {
        this.buildInstanceDefinition(clustername, buildInfo, false, false);
        return 0;
    }

    @Override
    public int actionKeytab(ActionKeytabArgs keytabInfo) throws YarnException, IOException {
        if (keytabInfo.install) {
            return this.actionInstallKeytab(keytabInfo);
        }
        if (keytabInfo.delete) {
            return this.actionDeleteKeytab(keytabInfo);
        }
        if (keytabInfo.list) {
            return this.actionListKeytab(keytabInfo);
        }
        throw new BadCommandArgumentsException("Keytab option specified not found.\n" + CommonArgs.usage(this.serviceArgs, "keytab"), new Object[0]);
    }

    private int actionListKeytab(ActionKeytabArgs keytabInfo) throws IOException {
        String folder = keytabInfo.folder != null ? keytabInfo.folder : "";
        Path keytabPath = this.sliderFileSystem.buildKeytabInstallationDirPath(folder);
        RemoteIterator files = this.sliderFileSystem.getFileSystem().listFiles(keytabPath, true);
        log.info("Keytabs:");
        while (files.hasNext()) {
            log.info("\t" + ((LocatedFileStatus)files.next()).getPath().toString());
        }
        return 0;
    }

    private int actionDeleteKeytab(ActionKeytabArgs keytabInfo) throws BadCommandArgumentsException, IOException {
        if (StringUtils.isEmpty(keytabInfo.folder)) {
            throw new BadCommandArgumentsException("A valid destination keytab sub-folder name is required (e.g. 'security').\n" + CommonArgs.usage(this.serviceArgs, "keytab"), new Object[0]);
        }
        if (StringUtils.isEmpty(keytabInfo.keytab)) {
            throw new BadCommandArgumentsException("A keytab name is required.", new Object[0]);
        }
        Path pkgPath = this.sliderFileSystem.buildKeytabInstallationDirPath(keytabInfo.folder);
        Path fileInFs = new Path(pkgPath, keytabInfo.keytab);
        log.info("Deleting keytab {}", (Object)fileInFs);
        FileSystem sfs = this.sliderFileSystem.getFileSystem();
        SliderClient.require(sfs.exists(fileInFs), "No keytab to delete found at %s", fileInFs.toUri());
        sfs.delete(fileInFs, false);
        return 0;
    }

    private int actionInstallKeytab(ActionKeytabArgs keytabInfo) throws BadCommandArgumentsException, IOException {
        Path srcFile = null;
        SliderClient.require(SliderClient.isSet(keytabInfo.folder), "A valid destination keytab sub-folder name is required (e.g. 'security').\n" + CommonArgs.usage(this.serviceArgs, "keytab"), new Object[0]);
        SliderClient.requireArgumentSet("--keytab", keytabInfo.keytab);
        File keytabFile = new File(keytabInfo.keytab);
        SliderClient.require(keytabFile.isFile(), "Unable to access supplied keytab file at %s", keytabFile.getAbsolutePath());
        srcFile = new Path(keytabFile.toURI());
        Path pkgPath = this.sliderFileSystem.buildKeytabInstallationDirPath(keytabInfo.folder);
        FileSystem sfs = this.sliderFileSystem.getFileSystem();
        sfs.mkdirs(pkgPath);
        sfs.setPermission(pkgPath, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        Path fileInFs = new Path(pkgPath, srcFile.getName());
        log.info("Installing keytab {} at {} and overwrite is {}.", srcFile, fileInFs, keytabInfo.overwrite);
        SliderClient.require(!sfs.exists(fileInFs) || keytabInfo.overwrite, "Keytab exists at %s. Use --overwrite to overwrite.", fileInFs.toUri());
        sfs.copyFromLocalFile(false, keytabInfo.overwrite, srcFile, fileInFs);
        sfs.setPermission(fileInFs, new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE));
        return 0;
    }

    @Override
    public int actionInstallKeytab(ActionInstallKeytabArgs installKeytabInfo) throws YarnException, IOException {
        log.warn("The 'install-keytab' option has been deprecated.  Please use 'keytab --install'.");
        return this.actionKeytab(new ActionKeytabArgs(installKeytabInfo));
    }

    @Override
    public int actionInstallPkg(ActionInstallPackageArgs installPkgInfo) throws YarnException, IOException {
        log.warn("The install-package option has been deprecated. Please use 'package --install'.");
        if (StringUtils.isEmpty(installPkgInfo.name)) {
            throw new BadCommandArgumentsException("A valid application type name is required (e.g. HBASE).\n" + CommonArgs.usage(this.serviceArgs, "install-package"), new Object[0]);
        }
        Path srcFile = this.extractPackagePath(installPkgInfo.packageURI);
        Path pkgPath = this.sliderFileSystem.buildPackageDirPath(installPkgInfo.name, null);
        FileSystem sfs = this.sliderFileSystem.getFileSystem();
        sfs.mkdirs(pkgPath);
        Path fileInFs = new Path(pkgPath, srcFile.getName());
        log.info("Installing package {} at {} and overwrite is {}.", srcFile, fileInFs, installPkgInfo.replacePkg);
        SliderClient.require(!sfs.exists(fileInFs) || installPkgInfo.replacePkg, "Package exists at %s. : %s", fileInFs.toUri(), E_USE_REPLACEPKG_TO_OVERWRITE);
        sfs.copyFromLocalFile(false, installPkgInfo.replacePkg, srcFile, fileInFs);
        return 0;
    }

    @Override
    public int actionClient(ActionClientArgs clientInfo) throws YarnException, IOException {
        if (clientInfo.install) {
            return this.doClientInstall(clientInfo);
        }
        if (clientInfo.getCertStore) {
            return this.doCertificateStoreRetrieval(clientInfo);
        }
        throw new BadCommandArgumentsException("Only install, keystore, and truststore commands are supported for the client.\n" + CommonArgs.usage(this.serviceArgs, "client"), new Object[0]);
    }

    private int doCertificateStoreRetrieval(ActionClientArgs clientInfo) throws YarnException, IOException {
        String password;
        SecurityStore.StoreType type;
        if (clientInfo.keystore != null && clientInfo.truststore != null) {
            throw new BadCommandArgumentsException("Only one of either keystore or truststore can be retrieved at one time.  Retrieval of both should be done separately\n" + CommonArgs.usage(this.serviceArgs, "client"), new Object[0]);
        }
        SliderClient.requireArgumentSet("--name", clientInfo.name);
        File storeFile = null;
        if (clientInfo.keystore != null) {
            storeFile = clientInfo.keystore;
            type = SecurityStore.StoreType.keystore;
        } else {
            storeFile = clientInfo.truststore;
            type = SecurityStore.StoreType.truststore;
        }
        SliderClient.require(!storeFile.exists(), "File %s already exists.  Please remove that file or select a different file name.", storeFile.getAbsolutePath());
        String hostname = null;
        if (type == SecurityStore.StoreType.keystore && (hostname = clientInfo.hostname) == null) {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
            log.info("No hostname specified via command line. Using {}", (Object)hostname);
        }
        if ((password = clientInfo.password) == null) {
            String provider = clientInfo.provider;
            String alias = clientInfo.alias;
            if (provider != null && alias != null) {
                Configuration conf = new Configuration(this.getConfig());
                conf.set("hadoop.security.credential.provider.path", provider);
                char[] chars = conf.getPassword(alias);
                if (chars == null) {
                    CredentialProvider credentialProvider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
                    chars = SliderClient.readOnePassword(alias);
                    credentialProvider.createCredentialEntry(alias, chars);
                    credentialProvider.flush();
                }
                password = String.valueOf(chars);
                Arrays.fill(chars, ' ');
            } else {
                log.info("No password and no provider/alias pair were provided, prompting for password");
                password = String.valueOf(SliderClient.readOnePassword(type.name()));
            }
        }
        byte[] keystore = this.createClusterOperations(clientInfo.name).getClientCertificateStore(hostname, "client", password, type.name());
        org.apache.commons.io.IOUtils.write((byte[])keystore, (OutputStream)new FileOutputStream(storeFile));
        return 0;
    }

    private int doClientInstall(ActionClientArgs clientInfo) throws IOException, SliderException {
        SliderClient.require(clientInfo.installLocation != null, "A valid install location must be provided for the client.\n" + CommonArgs.usage(this.serviceArgs, "client"), new Object[0]);
        SliderClient.require(clientInfo.installLocation.exists(), "Install path does not exist: " + clientInfo.installLocation.getAbsolutePath(), new Object[0]);
        SliderClient.require(clientInfo.installLocation.isDirectory(), "Install path is not a valid directory: " + clientInfo.installLocation.getAbsolutePath(), new Object[0]);
        SliderClient.require(SliderClient.isSet(clientInfo.packageURI), E_INVALID_APPLICATION_PACKAGE_LOCATION, new Object[0]);
        File pkgFile = new File(clientInfo.packageURI);
        SliderClient.require(pkgFile.isFile(), "Unable to read supplied package file at %s", pkgFile.getAbsolutePath());
        JSONObject config = null;
        if (clientInfo.clientConfig != null) {
            try {
                byte[] encoded = Files.toByteArray(clientInfo.clientConfig);
                config = new JSONObject(new String(encoded, Charset.defaultCharset()));
            }
            catch (JSONException jsonEx) {
                log.error("Unable to read supplied configuration at {}: {}", (Object)clientInfo.clientConfig, (Object)jsonEx);
                log.debug("Unable to read supplied configuration at {}: {}", new Object[]{clientInfo.clientConfig, jsonEx, jsonEx});
                throw new BadConfigException(E_MUST_BE_A_VALID_JSON_FILE, new Object[]{jsonEx});
            }
        }
        AbstractClientProvider provider = this.createClientProvider("agent");
        provider.processClientOperation(this.sliderFileSystem, "INSTALL", clientInfo.installLocation, pkgFile, config, clientInfo.name);
        return 0;
    }

    @Override
    public int actionPackage(ActionPackageArgs actionPackageInfo) throws YarnException, IOException {
        this.initializeOutputStream(actionPackageInfo.out);
        int exitCode = -1;
        if (actionPackageInfo.help) {
            exitCode = this.actionHelp("package");
        }
        if (actionPackageInfo.install) {
            exitCode = this.actionPackageInstall(actionPackageInfo);
        }
        if (actionPackageInfo.delete) {
            exitCode = this.actionPackageDelete(actionPackageInfo);
        }
        if (actionPackageInfo.list) {
            exitCode = this.actionPackageList();
        }
        if (actionPackageInfo.instances) {
            exitCode = this.actionPackageInstances();
        }
        this.finalizeOutputStream(actionPackageInfo.out);
        if (exitCode != -1) {
            return exitCode;
        }
        throw new BadCommandArgumentsException("Select valid package operation option", new Object[0]);
    }

    private void initializeOutputStream(String outFile) throws FileNotFoundException {
        clientOutputStream = outFile != null ? new PrintStream(new FileOutputStream(outFile)) : System.out;
    }

    private void finalizeOutputStream(String outFile) {
        if (outFile != null && clientOutputStream != null) {
            clientOutputStream.flush();
            clientOutputStream.close();
        }
        clientOutputStream = System.out;
    }

    private int actionPackageInstances() throws YarnException, IOException {
        Map<String, Path> persistentInstances = this.sliderFileSystem.listPersistentInstances();
        if (persistentInstances.isEmpty()) {
            log.info("No slider cluster specification available");
            return 0;
        }
        String pkgPathValue = this.sliderFileSystem.buildPackageDirPath("", "").toUri().getPath();
        FileSystem fs = this.sliderFileSystem.getFileSystem();
        Iterator<Map.Entry<String, Path>> instanceItr = persistentInstances.entrySet().iterator();
        log.info("List of applications with its package name and path");
        SliderClient.println("%-25s  %15s  %30s  %s", "Cluster Name", "Package Name", "Package Version", "Application Location");
        while (instanceItr.hasNext()) {
            Map.Entry<String, Path> entry = instanceItr.next();
            String clusterName = entry.getKey();
            Path clusterPath = entry.getValue();
            AggregateConf instanceDefinition = this.loadInstanceDefinitionUnresolved(clusterName, clusterPath);
            Path appDefPath = null;
            try {
                appDefPath = new Path(SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations()));
            }
            catch (BadConfigException badConfigException) {
                continue;
            }
            if (!appDefPath.isUriPathAbsolute()) {
                appDefPath = new Path(fs.getHomeDirectory(), appDefPath);
            }
            String appDefPathStr = appDefPath.toUri().toString();
            try {
                if (!appDefPathStr.contains(pkgPathValue) || !fs.isFile(appDefPath)) continue;
                String packageName = appDefPath.getParent().getName();
                String packageVersion = "";
                if (instanceDefinition.isVersioned()) {
                    packageVersion = packageName;
                    packageName = appDefPath.getParent().getParent().getName();
                }
                SliderClient.println("%-25s  %15s  %30s  %s", clusterName, packageName, packageVersion, appDefPathStr);
            }
            catch (IOException iOException) {
                log.debug("{} application definition path {} is not found.", (Object)clusterName, (Object)appDefPathStr);
            }
        }
        return 0;
    }

    private int actionPackageList() throws IOException {
        Path pkgPath = this.sliderFileSystem.buildPackageDirPath("", "");
        log.info("Package install path : {}", (Object)pkgPath);
        FileSystem sfs = this.sliderFileSystem.getFileSystem();
        if (!sfs.isDirectory(pkgPath)) {
            log.info("No package(s) installed");
            return 0;
        }
        FileStatus[] fileStatus = sfs.listStatus(pkgPath);
        boolean hasPackage = false;
        StringBuilder sb = new StringBuilder();
        sb.append("List of installed packages:\n");
        FileStatus[] fileStatusArray = fileStatus;
        int n = fileStatus.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus fstat = fileStatusArray[n2];
            if (fstat.isDirectory()) {
                sb.append("\t").append(fstat.getPath().getName());
                sb.append("\n");
                hasPackage = true;
            }
            ++n2;
        }
        if (hasPackage) {
            SliderClient.println(sb.toString());
        } else {
            log.info("No package(s) installed");
        }
        return 0;
    }

    private int actionPackageInstall(ActionPackageArgs actionPackageArgs) throws YarnException, IOException {
        String destPathWithoutHomeDir;
        SliderClient.requireArgumentSet("--name", actionPackageArgs.name);
        Path srcFile = this.extractPackagePath(actionPackageArgs.packageURI);
        Path pkgPath = this.sliderFileSystem.buildPackageDirPath(actionPackageArgs.name, actionPackageArgs.version);
        FileSystem fs = this.sliderFileSystem.getFileSystem();
        if (!fs.exists(pkgPath)) {
            fs.mkdirs(pkgPath);
        }
        Path fileInFs = new Path(pkgPath, srcFile.getName());
        SliderClient.require(actionPackageArgs.replacePkg || !fs.exists(fileInFs), "Package exists at  %s. Use --replacepkg to overwrite.", fileInFs.toUri());
        log.info("Installing package {} to {} (overwrite set to {})", srcFile, fileInFs, actionPackageArgs.replacePkg);
        fs.copyFromLocalFile(false, actionPackageArgs.replacePkg, srcFile, fileInFs);
        String destPathWithHomeDir = Path.getPathWithoutSchemeAndAuthority((Path)fileInFs).toString();
        String destHomeDir = Path.getPathWithoutSchemeAndAuthority((Path)fs.getHomeDirectory()).toString();
        if (destPathWithHomeDir.startsWith(destHomeDir)) {
            destPathWithoutHomeDir = destPathWithHomeDir.substring(destHomeDir.length());
            if (destPathWithoutHomeDir.startsWith("/") || destPathWithoutHomeDir.startsWith("\\")) {
                destPathWithoutHomeDir = destPathWithoutHomeDir.substring(1);
            }
        } else {
            destPathWithoutHomeDir = destPathWithHomeDir;
        }
        log.info("Set application.def in your app config JSON to {}", (Object)destPathWithoutHomeDir);
        return 0;
    }

    private Path extractPackagePath(String packageURI) throws BadCommandArgumentsException {
        SliderClient.require(SliderClient.isSet(packageURI), E_INVALID_APPLICATION_PACKAGE_LOCATION, new Object[0]);
        File pkgFile = new File(packageURI);
        SliderClient.require(pkgFile.isFile(), "Unable to read supplied package file:  " + pkgFile.getAbsolutePath(), new Object[0]);
        return new Path(pkgFile.toURI());
    }

    private int actionPackageDelete(ActionPackageArgs actionPackageArgs) throws YarnException, IOException {
        SliderClient.requireArgumentSet("--name", actionPackageArgs.name);
        Path pkgPath = this.sliderFileSystem.buildPackageDirPath(actionPackageArgs.name, actionPackageArgs.version);
        FileSystem fs = this.sliderFileSystem.getFileSystem();
        SliderClient.require(fs.exists(pkgPath), "Package does not exist: %s ", pkgPath.toUri());
        log.info("Deleting package {} at {}.", (Object)actionPackageArgs.name, (Object)pkgPath);
        if (fs.delete(pkgPath, true)) {
            log.info("Deleted package {} " + actionPackageArgs.name);
            return 0;
        }
        log.warn("Package deletion failed.");
        return 44;
    }

    @Override
    public int actionUpdate(String clustername, AbstractClusterBuildingActionArgs buildInfo) throws YarnException, IOException {
        this.buildInstanceDefinition(clustername, buildInfo, true, true);
        return 0;
    }

    public void buildInstanceDefinition(String clustername, AbstractClusterBuildingActionArgs buildInfo, boolean overwrite, boolean liveClusterAllowed) throws YarnException, IOException {
        this.buildInstanceDefinition(clustername, buildInfo, overwrite, liveClusterAllowed, false);
    }

    public void buildInstanceDefinition(String clustername, AbstractClusterBuildingActionArgs buildInfo, boolean overwrite, boolean liveClusterAllowed, boolean isUpgradeFlow) throws YarnException, IOException {
        SliderUtils.validateClusterName(clustername);
        this.verifyBindingsDefined();
        if (!liveClusterAllowed) {
            this.verifyNoLiveClusters(clustername, "Create");
        }
        Configuration conf = this.getConfig();
        String registryQuorum = this.lookupZKQuorum();
        Path appconfdir = buildInfo.getConfdir();
        String providerName = buildInfo.getProvider();
        SliderClient.requireArgumentSet("--provider", providerName);
        log.debug("Provider is {}", (Object)providerName);
        SliderAMClientProvider sliderAM = new SliderAMClientProvider(conf);
        AbstractClientProvider provider = this.createClientProvider(providerName);
        InstanceBuilder builder = new InstanceBuilder(this.sliderFileSystem, this.getConfig(), clustername);
        AggregateConf instanceDefinition = new AggregateConf();
        ConfTreeOperations appConf = instanceDefinition.getAppConfOperations();
        ConfTreeOperations resources = instanceDefinition.getResourceOperations();
        ConfTreeOperations internal = instanceDefinition.getInternalOperations();
        sliderAM.prepareInstanceConfiguration(instanceDefinition);
        provider.prepareInstanceConfiguration(instanceDefinition);
        if (buildInfo.resources != null) {
            try {
                resources.mergeFile(buildInfo.resources, new ResourcesInputPropertiesValidator());
            }
            catch (IOException e) {
                throw new BadConfigException(e, "incorrect argument to %s: \"%s\" : %s ", "--resources", buildInfo.resources, e.toString());
            }
        }
        if (buildInfo.template != null) {
            try {
                appConf.mergeFile(buildInfo.template, new TemplateInputPropertiesValidator());
            }
            catch (IOException e) {
                throw new BadConfigException(e, "incorrect argument to %s: \"%s\" : %s ", "--template", buildInfo.template, e.toString());
            }
        }
        if (isUpgradeFlow) {
            ActionUpgradeArgs upgradeInfo = (ActionUpgradeArgs)buildInfo;
            if (!upgradeInfo.force) {
                this.validateClientAndClusterResource(clustername, resources);
            }
        }
        ConfTree cmdLineAppOptions = buildInfo.buildAppOptionsConfTree();
        ConfTree cmdLineResourceOptions = buildInfo.buildResourceOptionsConfTree();
        appConf.merge(cmdLineAppOptions);
        AppDefinitionPersister appDefinitionPersister = new AppDefinitionPersister(this.sliderFileSystem);
        appDefinitionPersister.processSuppliedDefinitions(clustername, buildInfo, appConf);
        Map<String, String> argsRoleMap = buildInfo.getComponentMap();
        for (Map.Entry<String, String> roleEntry : argsRoleMap.entrySet()) {
            String count = roleEntry.getValue();
            String key = roleEntry.getKey();
            log.info("{} => {}", (Object)key, (Object)count);
            resources.getOrAddComponent(key).put("yarn.component.instances", count);
        }
        Map<String, Map<String, String>> appOptionMap = buildInfo.getCompOptionMap();
        appConf.mergeComponents(appOptionMap);
        internal.propagateGlobalKeys(appConf, "slider.");
        internal.propagateGlobalKeys(appConf, "internal.");
        resources.propagateGlobalKeys(appConf, "component.");
        resources.propagateGlobalKeys(appConf, "role.");
        resources.propagateGlobalKeys(appConf, "yarn.");
        resources.mergeComponentsPrefix(appOptionMap, "component.", true);
        resources.mergeComponentsPrefix(appOptionMap, "yarn.", true);
        resources.mergeComponentsPrefix(appOptionMap, "role.", true);
        appConf.merge(cmdLineResourceOptions);
        resources.merge(cmdLineResourceOptions);
        resources.mergeComponents(buildInfo.getResourceCompOptionMap());
        builder.init(providerName, instanceDefinition);
        builder.propagateFilename();
        builder.propagatePrincipals();
        builder.setImageDetailsIfAvailable(buildInfo.getImage(), buildInfo.getAppHomeDir());
        builder.setQueue(buildInfo.queue);
        String quorum = buildInfo.getZKhosts();
        if (SliderClient.isUnset(quorum)) {
            quorum = registryQuorum;
        }
        if (SliderClient.isUnset(quorum)) {
            throw new BadConfigException(E_NO_ZOOKEEPER_QUORUM);
        }
        ZKPathBuilder zkPaths = new ZKPathBuilder(this.getAppName(), this.getUsername(), clustername, registryQuorum, quorum);
        String zookeeperRoot = buildInfo.getAppZKPath();
        if (SliderClient.isSet(zookeeperRoot)) {
            zkPaths.setAppPath(zookeeperRoot);
        } else {
            String createDefaultZkNode = appConf.getGlobalOptions().getOption("create.default.zookeeper.node", "false");
            if (createDefaultZkNode.equals("true")) {
                String defaultZKPath = this.createZookeeperNode(clustername, false);
                log.debug("ZK node created for application instance: {}", (Object)defaultZKPath);
                if (defaultZKPath != null) {
                    zkPaths.setAppPath(defaultZKPath);
                }
            } else {
                String defaultZKPath = this.createZookeeperNode(clustername, true);
                log.debug("ZK node assigned to application instance: {}", (Object)defaultZKPath);
                zkPaths.setAppPath(defaultZKPath);
            }
        }
        builder.addZKBinding(zkPaths);
        if (buildInfo.packageURI != null) {
            appConf.set("agent.package.root", buildInfo.packageURI);
        }
        this.propagatePythonExecutable(conf, instanceDefinition);
        SliderClient.replaceTokens(appConf.getConfTree(), this.getUsername(), clustername);
        try {
            this.persistInstanceDefinition(overwrite, appconfdir, builder);
            appDefinitionPersister.persistPackages();
        }
        catch (LockAcquireFailedException e) {
            log.warn("Failed to get a Lock on {} : {}", builder, e, e);
            throw new BadClusterStateException("Failed to save " + clustername + ": " + e, new Object[0]);
        }
        AggregateConf instanceDescription = builder.getInstanceDescription();
        this.validateInstanceDefinition(sliderAM, instanceDescription, this.sliderFileSystem);
        this.validateInstanceDefinition(provider, instanceDescription, this.sliderFileSystem);
    }

    private void validateClientAndClusterResource(String clustername, ConfTreeOperations clientResources) throws BadClusterStateException, SliderException, IOException {
        log.info("Validating upgrade resource definition with current cluster state (components and instance count)");
        HashMap<String, Integer> clientComponentInstances = new HashMap<String, Integer>();
        for (String componentName : clientResources.getComponentNames()) {
            if ("slider-appmaster".equals(componentName)) continue;
            clientComponentInstances.put(componentName, clientResources.getComponentOptInt(componentName, "yarn.component.instances", -1));
        }
        AggregateConf clusterConf = null;
        try {
            clusterConf = this.loadPersistedClusterDescription(clustername);
        }
        catch (LockAcquireFailedException e) {
            log.warn("Failed to get a Lock on cluster resource : {}", (Object)e, (Object)e);
            throw new BadClusterStateException("Failed to load client resource definition " + clustername + ": " + e, new Object[]{e});
        }
        HashMap<String, Integer> clusterComponentInstances = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<String, String>> component : clusterConf.getResources().components.entrySet()) {
            if ("slider-appmaster".equals(component.getKey())) continue;
            clusterComponentInstances.put(component.getKey(), Integer.decode(component.getValue().get("yarn.component.instances")));
        }
        Iterator clientComponentInstanceIt = clientComponentInstances.entrySet().iterator();
        while (clientComponentInstanceIt.hasNext()) {
            Map.Entry clientComponentInstanceEntry = clientComponentInstanceIt.next();
            if (!clusterComponentInstances.containsKey(clientComponentInstanceEntry.getKey()) || clusterComponentInstances.get(clientComponentInstanceEntry.getKey()) != clientComponentInstanceEntry.getValue()) continue;
            clusterComponentInstances.remove(clientComponentInstanceEntry.getKey());
            clientComponentInstanceIt.remove();
        }
        if (!clientComponentInstances.isEmpty() || !clusterComponentInstances.isEmpty()) {
            log.error("Mismatch found in upgrade resource definition and cluster resource state");
            if (!clientComponentInstances.isEmpty()) {
                log.info("The upgrade resource definitions that do not match are:");
                for (Map.Entry clientComponentInstanceEntry : clientComponentInstances.entrySet()) {
                    log.info("    Component Name: {}, Instance count: {}", clientComponentInstanceEntry.getKey(), clientComponentInstanceEntry.getValue());
                }
            }
            if (!clusterComponentInstances.isEmpty()) {
                log.info("The cluster resources that do not match are:");
                for (Map.Entry clusterComponentInstanceEntry : clusterComponentInstances.entrySet()) {
                    log.info("    Component Name: {}, Instance count: {}", clusterComponentInstanceEntry.getKey(), clusterComponentInstanceEntry.getValue());
                }
            }
            throw new BadConfigException("Resource definition provided for upgrade does not match with that of the currently running cluster.\nIf you are aware of what you are doing, rerun the command with --force option.");
        }
    }

    protected void persistInstanceDefinition(boolean overwrite, Path appconfdir, InstanceBuilder builder) throws IOException, SliderException, LockAcquireFailedException {
        builder.persist(appconfdir, overwrite);
    }

    @VisibleForTesting
    public static void replaceTokens(ConfTree conf, String userName, String clusterName) throws IOException {
        HashMap<String, String> newglobal = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : conf.global.entrySet()) {
            newglobal.put(entry.getKey(), SliderClient.replaceTokens(entry.getValue(), userName, clusterName));
        }
        conf.global.putAll(newglobal);
        HashMap newcred = new HashMap();
        for (Map.Entry<String, List<String>> entry : conf.credentials.entrySet()) {
            ArrayList<String> resultList = new ArrayList<String>();
            for (String v : entry.getValue()) {
                resultList.add(SliderClient.replaceTokens(v, userName, clusterName));
            }
            newcred.put(SliderClient.replaceTokens(entry.getKey(), userName, clusterName), resultList);
        }
        conf.credentials.clear();
        conf.credentials.putAll(newcred);
    }

    private static String replaceTokens(String s, String userName, String clusterName) throws IOException {
        return s.replaceAll(Pattern.quote("${USER}"), userName).replaceAll(Pattern.quote("${USER_NAME}"), userName).replaceAll(Pattern.quote("${CLUSTER_NAME}"), clusterName);
    }

    public FsPermission getClusterDirectoryPermissions(Configuration conf) {
        String clusterDirPermsOct = conf.get("slider.cluster.directory.permissions", "750");
        return new FsPermission(clusterDirPermsOct);
    }

    public void verifyBindingsDefined() throws BadCommandArgumentsException {
        InetSocketAddress rmAddr = SliderUtils.getRmAddress(this.getConfig());
        if (!this.getConfig().getBoolean("yarn.resourcemanager.ha.enabled", false) && !SliderUtils.isAddressDefined(rmAddr)) {
            throw new BadCommandArgumentsException("No valid Resource Manager address provided in the argument --manager or the configuration property yarn.resourcemanager.address value :" + rmAddr, new Object[0]);
        }
    }

    private int startCluster(String clustername, LaunchArgsAccessor launchArgs) throws YarnException, IOException {
        int waittime;
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(clustername);
        AggregateConf instanceDefinition = this.loadInstanceDefinitionUnresolved(clustername, clusterDirectory);
        LaunchedApplication launchedApplication = this.launchApplication(clustername, clusterDirectory, instanceDefinition, this.serviceArgs.isDebug());
        this.applicationId = launchedApplication.getApplicationId();
        if (launchArgs.getOutputFile() != null) {
            ApplicationReport report = launchedApplication.getApplicationReport();
            SerializedApplicationReport sar = new SerializedApplicationReport(report);
            sar.submitTime = System.currentTimeMillis();
            ApplicationReportSerDeser serDeser = new ApplicationReportSerDeser();
            serDeser.save(sar, launchArgs.getOutputFile());
        }
        if ((waittime = launchArgs.getWaittime()) > 0) {
            return this.waitForAppRunning(launchedApplication, waittime, waittime);
        }
        return 0;
    }

    public AggregateConf loadInstanceDefinitionUnresolved(String name, Path clusterDirectory) throws IOException, SliderException {
        try {
            AggregateConf definition = InstanceIO.loadInstanceDefinitionUnresolved(this.sliderFileSystem, clusterDirectory);
            definition.setName(name);
            return definition;
        }
        catch (FileNotFoundException e) {
            throw UnknownApplicationInstanceException.unknownInstance(name, e);
        }
    }

    public AggregateConf loadInstanceDefinition(String name, boolean resolved) throws IOException, SliderException {
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(name);
        AggregateConf instanceDefinition = this.loadInstanceDefinitionUnresolved(name, clusterDirectory);
        if (resolved) {
            instanceDefinition.resolve();
        }
        return instanceDefinition;
    }

    public LaunchedApplication launchApplication(String clustername, Path clusterDirectory, AggregateConf instanceDefinition, boolean debugAM) throws YarnException, IOException {
        InetSocketAddress rmSchedulerAddress;
        this.deployedClusterName = clustername;
        SliderUtils.validateClusterName(clustername);
        this.verifyNoLiveClusters(clustername, "Launch");
        Configuration config = this.getConfig();
        this.lookupZKQuorum();
        boolean clusterSecure = SliderUtils.isHadoopClusterSecure(config);
        SliderAMClientProvider sliderAM = new SliderAMClientProvider(config);
        instanceDefinition.resolve();
        this.launchedInstanceDefinition = instanceDefinition;
        ConfTreeOperations internalOperations = instanceDefinition.getInternalOperations();
        MapOperations internalOptions = internalOperations.getGlobalOptions();
        ConfTreeOperations resourceOperations = instanceDefinition.getResourceOperations();
        ConfTreeOperations appOperations = instanceDefinition.getAppConfOperations();
        Path generatedConfDirPath = this.createPathThatMustExist(internalOptions.getMandatoryOption("internal.generated.conf.path"));
        Path snapshotConfPath = this.createPathThatMustExist(internalOptions.getMandatoryOption("internal.snapshot.conf.path"));
        AbstractClientProvider provider = this.createClientProvider(internalOptions.getMandatoryOption("internal.provider.name"));
        if (log.isDebugEnabled()) {
            log.debug(instanceDefinition.toString());
        }
        MapOperations sliderAMResourceComponent = resourceOperations.getOrAddComponent("slider-appmaster");
        MapOperations resourceGlobalOptions = resourceOperations.getGlobalOptions();
        Set<String> applicationTags = provider.getApplicationTags(this.sliderFileSystem, SliderUtils.getApplicationDefinitionPath(appOperations));
        AppMasterLauncher amLauncher = new AppMasterLauncher(clustername, "org-apache-slider", config, this.sliderFileSystem, this.yarnClient, clusterSecure, sliderAMResourceComponent, resourceGlobalOptions, applicationTags);
        ApplicationId appId = amLauncher.getApplicationId();
        amLauncher.setKeepContainersOverRestarts(true);
        int maxAppAttempts = config.getInt("slider.yarn.restart.limit", 0);
        amLauncher.setMaxAppAttempts(maxAppAttempts);
        this.sliderFileSystem.purgeAppInstanceTempFiles(clustername);
        Path tempPath = this.sliderFileSystem.createAppInstanceTempPath(clustername, String.valueOf(appId.toString()) + "/am");
        String libdir = "lib";
        Path libPath = new Path(tempPath, libdir);
        this.sliderFileSystem.getFileSystem().mkdirs(libPath);
        log.debug("FS={}, tempPath={}, libdir={}", this.sliderFileSystem, tempPath, libPath);
        Map<String, LocalResource> localResources = amLauncher.getLocalResources();
        boolean hasServerLog4jProperties = false;
        Path remoteConfPath = null;
        String relativeConfDir = null;
        String confdirProp = System.getProperty("slider.confdir");
        if (SliderClient.isUnset(confdirProp)) {
            log.debug("No local configuration directory provided as system property");
        } else {
            File confDir = new File(confdirProp);
            if (!confDir.exists()) {
                throw new BadConfigException("Configuration directory \"%s\" not found", confDir);
            }
            Path localConfDirPath = SliderUtils.createLocalPath(confDir);
            remoteConfPath = new Path(clusterDirectory, "confdir");
            log.debug("Slider configuration directory is {}; remote to be {}", (Object)localConfDirPath, (Object)remoteConfPath);
            SliderUtils.copyDirectory(config, localConfDirPath, remoteConfPath, null);
            File log4jserver = new File(confDir, "log4j-server.properties");
            hasServerLog4jProperties = log4jserver.isFile();
        }
        boolean usingMiniMRCluster = this.getUsingMiniMRCluster();
        if (!usingMiniMRCluster) {
            log.debug("Destination is not a MiniYARNCluster -copying full classpath");
            if (remoteConfPath != null) {
                relativeConfDir = "confdir";
                Map<String, LocalResource> submittedConfDir = this.sliderFileSystem.submitDirectory(remoteConfPath, relativeConfDir);
                SliderUtils.mergeMaps(localResources, submittedConfDir);
            }
        }
        this.propagatePrincipals(config, instanceDefinition);
        Configuration clientConfExtras = new Configuration(false);
        FsPermission clusterPerms = this.getClusterDirectoryPermissions(config);
        SliderUtils.copyDirectory(config, snapshotConfPath, generatedConfDirPath, clusterPerms);
        sliderAM.prepareAMAndConfigForLaunch(this.sliderFileSystem, config, amLauncher, instanceDefinition, snapshotConfPath, generatedConfDirPath, clientConfExtras, libdir, tempPath, usingMiniMRCluster);
        provider.prepareAMAndConfigForLaunch(this.sliderFileSystem, config, amLauncher, instanceDefinition, snapshotConfPath, generatedConfDirPath, clientConfExtras, libdir, tempPath, usingMiniMRCluster);
        log.debug("Preflight validation of cluster configuration");
        sliderAM.preflightValidateClusterConfiguration(this.sliderFileSystem, clustername, config, instanceDefinition, clusterDirectory, generatedConfDirPath, clusterSecure);
        provider.preflightValidateClusterConfiguration(this.sliderFileSystem, clustername, config, instanceDefinition, clusterDirectory, generatedConfDirPath, clusterSecure);
        Path imagePath = SliderUtils.extractImagePath(this.sliderFileSystem, internalOptions);
        if (this.sliderFileSystem.maybeAddImagePath(localResources, imagePath)) {
            log.debug("Registered image path {}", (Object)imagePath);
        }
        amLauncher.putEnv(SliderUtils.buildEnvMap(sliderAMResourceComponent));
        ClasspathConstructor classpath = SliderUtils.buildClasspath(relativeConfDir, libdir, this.getConfig(), this.sliderFileSystem, usingMiniMRCluster);
        amLauncher.setClasspath(classpath);
        amLauncher.setEnv("LANG", "en_US.UTF-8");
        amLauncher.setEnv("LC_ALL", "en_US.UTF-8");
        amLauncher.setEnv("LANGUAGE", "en_US.UTF-8");
        amLauncher.putEnv(this.getAmLaunchEnv(config));
        for (Map.Entry<String, String> envs : SliderUtils.getSystemEnv().entrySet()) {
            log.debug("System env {}={}", (Object)envs.getKey(), (Object)envs.getValue());
        }
        if (log.isDebugEnabled()) {
            log.debug("AM classpath={}", (Object)classpath);
            log.debug("Environment Map:\n{}", (Object)SliderUtils.stringifyMap(amLauncher.getEnv()));
            log.debug("Files in lib path\n{}", (Object)this.sliderFileSystem.listFSDir(libPath));
        }
        try {
            rmSchedulerAddress = SliderUtils.getRmSchedulerAddress(config);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadConfigException("%s Address invalid: %s", "yarn.resourcemanager.scheduler.address", config.get("yarn.resourcemanager.scheduler.address"));
        }
        String rmAddr = NetUtils.getHostPortString((InetSocketAddress)rmSchedulerAddress);
        JavaCommandLineBuilder commandLine = new JavaCommandLineBuilder();
        sliderAM.addJVMOptions(instanceDefinition, commandLine);
        commandLine.enableJavaAssertions();
        if (hasServerLog4jProperties) {
            commandLine.sysprop("log4j.configuration", "log4j-server.properties");
            commandLine.sysprop("LOG_DIR", "<LOG_DIR>");
        }
        commandLine.add("org.apache.slider.server.appmaster.SliderAppMaster");
        commandLine.add("create", clustername);
        if (debugAM) {
            commandLine.add("--debug");
        }
        commandLine.add("-cluster-uri", clusterDirectory.toUri());
        if (!SliderClient.isUnset(rmAddr)) {
            commandLine.add("--rm", rmAddr);
        }
        if (this.serviceArgs.getFilesystemBinding() != null) {
            commandLine.add("--fs", this.serviceArgs.getFilesystemBinding());
        }
        commandLine.addConfOptionToCLI(config, "hadoop.registry.zk.root", "/registry");
        commandLine.addMandatoryConfOption(config, "hadoop.registry.zk.quorum");
        if (clusterSecure) {
            commandLine.addConfOption(config, "dfs.namenode.kerberos.principal");
        }
        commandLine.addConfOptions(config, "yarn.resourcemanager.address", "yarn.resourcemanager.cluster-id", "yarn.resourcemanager.hostname", "yarn.resourcemanager.principal");
        commandLine.addOutAndErrFiles("slider-out.txt", "slider-err.txt");
        String cmdStr = commandLine.build();
        log.debug("Completed setting up app master command {}", (Object)cmdStr);
        amLauncher.addCommandLine(commandLine);
        sliderAM.prepareAMResourceRequirements(sliderAMResourceComponent, amLauncher.getResource());
        amLauncher.setPriority(config.getInt("slider.yarn.queue.priority", 1));
        String amQueue = config.get("slider.yarn.queue", DEFAULT_YARN_QUEUE);
        String suppliedQueue = internalOperations.getGlobalOptions().get("internal.queue");
        if (!SliderClient.isUnset(suppliedQueue)) {
            amQueue = suppliedQueue;
            log.info("Using queue {} for the application instance.", (Object)amQueue);
        }
        if (SliderClient.isSet(amQueue)) {
            amLauncher.setQueue(amQueue);
        }
        LaunchedApplication launchedApplication = amLauncher.submitApplication();
        return launchedApplication;
    }

    protected Map<String, String> getAmLaunchEnv(Configuration config) {
        Object[] envs;
        String sliderAmLaunchEnv = config.get("slider.am.launch.env");
        log.debug("{} = {}", (Object)"slider.am.launch.env", (Object)sliderAmLaunchEnv);
        Object[] objectArray = envs = StringUtils.isEmpty(sliderAmLaunchEnv) ? null : sliderAmLaunchEnv.split(",");
        if (ArrayUtils.isEmpty(envs)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> amLaunchEnv = new HashMap<String, String>();
        Object[] objectArray2 = envs;
        int n = envs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] tokens;
            Object env = objectArray2[n2];
            if (StringUtils.isNotEmpty((String)env) && (tokens = ((String)env).split("=")) != null && tokens.length == 2) {
                String envKey = tokens[0];
                String envValue = tokens[1];
                for (Map.Entry<String, String> placeholder : this.generatePlaceholderKeyValueMap((String)env).entrySet()) {
                    if (!StringUtils.isNotEmpty(placeholder.getValue())) continue;
                    envValue = envValue.replaceAll(Pattern.quote(placeholder.getKey()), placeholder.getValue());
                }
                envValue = Shell.WINDOWS ? "%" + envKey + "%;" + envValue : "$" + envKey + ":" + envValue;
                log.info("Setting AM launch env {}={}", (Object)envKey, (Object)envValue);
                amLaunchEnv.put(envKey, envValue);
            }
            ++n2;
        }
        return amLaunchEnv;
    }

    protected Map<String, String> generatePlaceholderKeyValueMap(String env) {
        String PLACEHOLDER_PATTERN = "\\$\\{[^{]+\\}";
        Pattern placeholderPattern = Pattern.compile(PLACEHOLDER_PATTERN);
        Matcher placeholderMatcher = placeholderPattern.matcher(env);
        HashMap<String, String> placeholderKeyValueMap = new HashMap<String, String>();
        if (placeholderMatcher.find()) {
            String placeholderKey = placeholderMatcher.group();
            String systemKey = placeholderKey.substring(2, placeholderKey.length() - 1).toUpperCase(Locale.ENGLISH).replaceAll("\\.", "_");
            String placeholderValue = SliderUtils.getSystemEnv(systemKey);
            log.debug("Placeholder {}={}", (Object)placeholderKey, (Object)placeholderValue);
            placeholderKeyValueMap.put(placeholderKey, placeholderValue);
        }
        return placeholderKeyValueMap;
    }

    private void propagatePythonExecutable(Configuration config, AggregateConf instanceDefinition) {
        String pythonExec = config.get("agent.python.exec.path");
        if (pythonExec != null) {
            instanceDefinition.getAppConfOperations().getGlobalOptions().putIfUnset("agent.python.exec.path", pythonExec);
        }
    }

    public int waitForAppRunning(LaunchedApplication launchedApplication, int acceptWaitMillis, int runWaitMillis) throws YarnException, IOException {
        int exitCode;
        assert (launchedApplication != null);
        ApplicationReport report = launchedApplication.monitorAppToState(YarnApplicationState.ACCEPTED, new Duration(acceptWaitMillis));
        if (SliderUtils.hasAppFinished(report)) {
            exitCode = this.buildExitCode(report);
        } else if (runWaitMillis != 0) {
            Duration duration = new Duration(runWaitMillis * 1000);
            duration.start();
            report = launchedApplication.monitorAppToState(YarnApplicationState.RUNNING, duration);
            exitCode = report != null && report.getYarnApplicationState() == YarnApplicationState.RUNNING ? 0 : this.buildExitCode(report);
        } else {
            exitCode = 0;
        }
        return exitCode;
    }

    private void propagatePrincipals(Configuration config, AggregateConf clusterSpec) {
        String dfsPrincipal = config.get("dfs.namenode.kerberos.principal");
        if (dfsPrincipal != null) {
            String siteDfsPrincipal = "site.dfs.namenode.kerberos.principal";
            clusterSpec.getAppConfOperations().getGlobalOptions().putIfUnset(siteDfsPrincipal, dfsPrincipal);
        }
    }

    public Path createPathThatMustExist(String uri) throws SliderException, IOException {
        return this.sliderFileSystem.createPathThatMustExist(uri);
    }

    public void verifyNoLiveClusters(String clustername, String action) throws IOException, YarnException {
        List<ApplicationReport> existing = this.findAllLiveInstances(clustername);
        if (!existing.isEmpty()) {
            throw new SliderException(73, String.valueOf(action) + " failed for " + clustername + ": " + "Application Instance running" + " :" + existing.get(0));
        }
    }

    public String getUsername() throws IOException {
        return RegistryUtils.currentUser();
    }

    public String getDeployedClusterName() {
        return this.deployedClusterName;
    }

    @VisibleForTesting
    public void setDeployedClusterName(String deployedClusterName) {
        this.deployedClusterName = deployedClusterName;
    }

    private boolean getUsingMiniMRCluster() {
        return this.getConfig().getBoolean("yarn.is.minicluster", false);
    }

    private String getAppName() {
        return "slider";
    }

    @VisibleForTesting
    public ApplicationReport monitorAppToRunning(Duration duration) throws YarnException, IOException {
        return this.monitorAppToState(YarnApplicationState.RUNNING, duration);
    }

    private int buildExitCode(ApplicationReport report) throws IOException, YarnException {
        if (report == null) {
            return 67;
        }
        YarnApplicationState state = report.getYarnApplicationState();
        FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
        switch (state) {
            case FINISHED: {
                if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                    log.info("Application has completed successfully");
                    return 0;
                }
                log.info("Application finished unsuccessfully.YarnState = {}, DSFinalStatus = {} Breaking monitoring loop", (Object)state, (Object)dsStatus);
                return 68;
            }
            case KILLED: {
                log.info("Application did not finish. YarnState={}, DSFinalStatus={}", (Object)state, (Object)dsStatus);
                return 66;
            }
            case FAILED: {
                log.info("Application Failed. YarnState={}, DSFinalStatus={}", (Object)state, (Object)dsStatus);
                return 65;
            }
        }
        return 0;
    }

    @VisibleForTesting
    public ApplicationReport monitorAppToState(YarnApplicationState desiredState, Duration duration) throws YarnException, IOException {
        LaunchedApplication launchedApplication = new LaunchedApplication(this.applicationId, this.yarnClient);
        return launchedApplication.monitorAppToState(desiredState, duration);
    }

    @Override
    public ApplicationReport getApplicationReport() throws IOException, YarnException {
        return this.getApplicationReport(this.applicationId);
    }

    @Override
    public boolean forceKillApplication(String reason) throws YarnException, IOException {
        if (this.applicationId != null) {
            new LaunchedApplication(this.applicationId, this.yarnClient).forceKill(reason);
            return true;
        }
        return false;
    }

    public List<ApplicationReport> listSliderInstances(String user) throws YarnException, IOException {
        return this.yarnAppListClient.listInstances(user);
    }

    public int actionList(String clustername) throws IOException, YarnException {
        ActionListArgs args = new ActionListArgs();
        args.live = true;
        return this.actionList(clustername, args);
    }

    @Override
    public int actionList(String clustername, ActionListArgs args) throws IOException, YarnException {
        Set<String> appInstances = this.getApplicationList(clustername, args);
        return !appInstances.isEmpty() ? 0 : (appInstances.isEmpty() && SliderClient.isUnset(clustername) ? 0 : -1);
    }

    public Set<String> getApplicationList(String clustername) throws IOException, YarnException {
        ActionListArgs args = new ActionListArgs();
        args.live = true;
        return this.getApplicationList(clustername, args);
    }

    public Set<String> getApplicationList(String clustername, ActionListArgs args) throws IOException, YarnException {
        YarnApplicationState max;
        YarnApplicationState min;
        boolean listOnlyInState;
        if (args.help) {
            this.actionHelp("list");
            return Collections.emptySet();
        }
        this.verifyBindingsDefined();
        boolean live = args.live;
        String state = args.state;
        boolean listContainers = args.containers;
        boolean verbose = args.verbose;
        String version = args.version;
        Set<String> components = args.components;
        if (live && !state.isEmpty()) {
            throw new BadCommandArgumentsException("--live and --state are exclusive", new Object[0]);
        }
        if (listContainers && SliderClient.isUnset(clustername)) {
            throw new BadCommandArgumentsException("Should specify an application instance with --containers", new Object[0]);
        }
        if (StringUtils.isNotEmpty(version) && !listContainers) {
            throw new BadCommandArgumentsException("--version can be specified only with --containers", new Object[0]);
        }
        if (!components.isEmpty() && !listContainers) {
            throw new BadCommandArgumentsException("--components can be specified only with --containers", new Object[0]);
        }
        boolean bl = listOnlyInState = live || !state.isEmpty();
        if (live) {
            min = YarnApplicationState.NEW;
            max = YarnApplicationState.RUNNING;
        } else if (!state.isEmpty()) {
            YarnApplicationState stateVal;
            min = max = (stateVal = this.extractYarnApplicationState(state));
        } else {
            min = YarnApplicationState.NEW;
            max = YarnApplicationState.KILLED;
        }
        Map<String, Path> persistentInstances = this.sliderFileSystem.listPersistentInstances();
        if (persistentInstances.isEmpty() && SliderClient.isUnset(clustername)) {
            log.debug("No application instances found");
            return Collections.emptySet();
        }
        List<ApplicationReport> instances = this.listSliderInstances(null);
        SliderUtils.sortApplicationsByMostRecent(instances);
        Map<String, ApplicationReport> reportMap = SliderUtils.buildApplicationReportMap(instances, min, max);
        log.debug("Persisted {} deployed {} filtered[{}-{}] & de-duped to {}", persistentInstances.size(), instances.size(), min, max, reportMap.size());
        List<ContainerInformation> containers = null;
        if (SliderClient.isSet(clustername)) {
            Path persistent = persistentInstances.get(clustername);
            if (persistent == null) {
                throw this.unknownClusterException(clustername);
            }
            persistentInstances = new HashMap<String, Path>();
            persistentInstances.put(clustername, persistent);
            if (listContainers) {
                containers = this.getContainers(clustername);
            }
        }
        HashSet<String> listedInstances = new HashSet<String>();
        for (String name : persistentInstances.keySet()) {
            ApplicationReport report = reportMap.get(name);
            if (listOnlyInState && report == null) continue;
            listedInstances.add(name);
            String details = SliderUtils.instanceDetailsToString(name, report, containers, version, components, verbose);
            SliderClient.print(details);
        }
        return listedInstances;
    }

    public List<ContainerInformation> getContainers(String name) throws YarnException, IOException {
        SliderClusterOperations clusterOps = new SliderClusterOperations(this.bondToCluster(name));
        try {
            return clusterOps.getContainers();
        }
        catch (NoSuchNodeException noSuchNodeException) {
            throw new BadClusterStateException("Containers not found for application instance %s", name);
        }
    }

    @Override
    public Map<String, SliderInstanceDescription> enumSliderInstances(boolean listOnlyInState, YarnApplicationState minAppState, YarnApplicationState maxAppState) throws IOException, YarnException {
        return this.yarnAppListClient.enumSliderInstances(listOnlyInState, minAppState, maxAppState);
    }

    private YarnApplicationState extractYarnApplicationState(String state) throws BadCommandArgumentsException {
        YarnApplicationState stateVal;
        try {
            stateVal = YarnApplicationState.valueOf((String)state.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BadCommandArgumentsException("Unknown state: " + state, new Object[0]);
        }
        return stateVal;
    }

    public boolean isApplicationActive(ApplicationReport report) {
        return report.getYarnApplicationState() == YarnApplicationState.RUNNING || report.getYarnApplicationState() == YarnApplicationState.ACCEPTED;
    }

    @Override
    @VisibleForTesting
    public int actionFlex(String name, ActionFlexArgs args) throws YarnException, IOException {
        SliderUtils.validateClusterName(name);
        Map<String, String> roleMap = args.getComponentMap();
        if (roleMap.size() == 0) {
            this.actionHelp("flex");
        }
        this.verifyBindingsDefined();
        log.debug("actionFlex({})", (Object)name);
        HashMap<String, Integer> roleInstances = new HashMap<String, Integer>();
        for (Map.Entry<String, String> roleEntry : roleMap.entrySet()) {
            String key = roleEntry.getKey();
            String val = roleEntry.getValue();
            try {
                roleInstances.put(key, Integer.valueOf(val));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BadCommandArgumentsException("Requested count of role %s is not a number: \"%s\"", key, val);
            }
        }
        return this.flex(name, roleInstances);
    }

    @Override
    public int actionExists(String name, boolean checkLive) throws YarnException, IOException {
        ActionExistsArgs args = new ActionExistsArgs();
        args.live = checkLive;
        return this.actionExists(name, args);
    }

    public int actionExists(String name, ActionExistsArgs args) throws YarnException, IOException {
        this.verifyBindingsDefined();
        SliderUtils.validateClusterName(name);
        boolean checkLive = args.live;
        log.debug("actionExists({}, {}, {})", name, checkLive, args.state);
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(name);
        if (!this.sliderFileSystem.getFileSystem().exists(clusterDirectory)) {
            throw this.unknownClusterException(name);
        }
        String state = args.state;
        if (!checkLive && SliderClient.isUnset(state)) {
            log.info("Application {} exists", (Object)name);
            return 0;
        }
        boolean inDesiredState = false;
        ApplicationReport instance = this.findInstance(name);
        if (instance == null) {
            log.info("Application {} not running", (Object)name);
            return -1;
        }
        if (checkLive) {
            YarnApplicationState appstate = instance.getYarnApplicationState();
            log.debug(" current app state = {}", (Object)appstate);
            inDesiredState = appstate.ordinal() < YarnApplicationState.FINISHED.ordinal();
        } else {
            YarnApplicationState desiredState;
            List<ApplicationReport> userInstances = this.yarnClient.listDeployedInstances("");
            ApplicationReport foundInstance = this.yarnClient.findAppInInstanceList(userInstances, name, desiredState = this.extractYarnApplicationState(state = state.toUpperCase(Locale.ENGLISH)));
            if (foundInstance != null) {
                inDesiredState = true;
                instance = foundInstance;
            }
        }
        SliderUtils.OnDemandReportStringifier report = new SliderUtils.OnDemandReportStringifier(instance);
        if (!inDesiredState) {
            log.info("Application {} found but is in wrong state {}", (Object)name, (Object)instance.getYarnApplicationState());
            log.debug("State {}", (Object)report);
            return -1;
        }
        log.debug("Application instance is in desired state");
        log.info("Application {} is {}\n{}", name, instance.getYarnApplicationState(), report);
        return 0;
    }

    @Override
    public int actionKillContainer(String name, ActionKillContainerArgs args) throws YarnException, IOException {
        String id = args.id;
        if (SliderClient.isUnset(id)) {
            throw new BadCommandArgumentsException("Missing container id", new Object[0]);
        }
        log.info("killingContainer {}:{}", (Object)name, (Object)id);
        SliderClusterOperations clusterOps = new SliderClusterOperations(this.bondToCluster(name));
        try {
            clusterOps.killContainer(id);
        }
        catch (NoSuchNodeException noSuchNodeException) {
            throw new BadClusterStateException("Container %s not found in cluster %s", id, name);
        }
        return 0;
    }

    @Override
    public String actionEcho(String name, ActionEchoArgs args) throws YarnException, IOException {
        String message = args.message;
        if (message == null) {
            throw new BadCommandArgumentsException("missing message", new Object[0]);
        }
        SliderClusterOperations clusterOps = new SliderClusterOperations(this.bondToCluster(name));
        return clusterOps.echo(message);
    }

    public YarnAppListClient getYarnAppListClient() {
        return this.yarnAppListClient;
    }

    private ApplicationReport findInstance(String appname) throws YarnException, IOException {
        return this.yarnAppListClient.findInstance(appname);
    }

    private RunningApplication findApplication(String appname) throws YarnException, IOException {
        ApplicationReport applicationReport = this.findInstance(appname);
        return applicationReport != null ? new RunningApplication(this.yarnClient, applicationReport) : null;
    }

    private List<ApplicationReport> findAllLiveInstances(String appname) throws YarnException, IOException {
        return this.yarnAppListClient.findAllLiveInstances(appname);
    }

    private SliderClusterProtocol connect(ApplicationReport app) throws YarnException, IOException {
        try {
            return RpcBinder.getProxy(this.getConfig(), this.yarnClient.getRmClient(), app, 10000, 15000);
        }
        catch (InterruptedException e) {
            throw new SliderException(67, e, "Interrupted waiting for communications with the Slider AM", new Object[0]);
        }
    }

    @Override
    @VisibleForTesting
    public int actionStatus(String clustername, ActionStatusArgs statusArgs) throws YarnException, IOException {
        this.verifyBindingsDefined();
        SliderUtils.validateClusterName(clustername);
        String outfile = statusArgs.getOutput();
        ClusterDescription status = this.getClusterDescription(clustername);
        String text = status.toJsonString();
        if (outfile == null) {
            log.info(text);
        } else {
            status.save(new File(outfile).getAbsoluteFile());
        }
        return 0;
    }

    @Override
    public int actionVersion() {
        SliderVersionInfo.loadAndPrintVersionInfo(log);
        return 0;
    }

    @Override
    public int actionFreeze(String clustername, ActionFreezeArgs freezeArgs) throws YarnException, IOException {
        this.verifyBindingsDefined();
        SliderUtils.validateClusterName(clustername);
        int waittime = freezeArgs.getWaittime();
        String text = freezeArgs.message;
        boolean forcekill = freezeArgs.force;
        log.debug("actionFreeze({}, reason={}, wait={}, force={})", clustername, text, waittime, forcekill);
        this.sliderFileSystem.locateInstanceDefinition(clustername);
        ApplicationReport app = this.findInstance(clustername);
        if (app == null) {
            log.info("Cluster {} not running", (Object)clustername);
            return 0;
        }
        log.debug("App to stop was found: {}:\n{}", (Object)clustername, (Object)new SliderUtils.OnDemandReportStringifier(app));
        if (app.getYarnApplicationState().ordinal() >= YarnApplicationState.FINISHED.ordinal()) {
            log.info("Cluster {} is in a terminated state {}", (Object)clustername, (Object)app.getYarnApplicationState());
            return 0;
        }
        if (!forcekill && app.getYarnApplicationState().ordinal() < YarnApplicationState.RUNNING.ordinal()) {
            log.info("Cluster {} is in a pre-running state {}. Force killing it", (Object)clustername, (Object)app.getYarnApplicationState());
            forcekill = true;
        }
        LaunchedApplication application = new LaunchedApplication(this.yarnClient, app);
        this.applicationId = application.getApplicationId();
        if (forcekill) {
            application.kill("Forced stop of " + clustername + ": " + text);
        } else {
            try {
                SliderClusterProtocol appMaster = this.connect(app);
                Messages.StopClusterRequestProto r = Messages.StopClusterRequestProto.newBuilder().setMessage(text).build();
                appMaster.stopCluster(r);
                log.debug("Cluster stop command issued");
            }
            catch (YarnException e) {
                log.warn("Exception while trying to terminate {}", (Object)clustername, (Object)e);
                return -1;
            }
            catch (IOException e) {
                log.warn("Exception while trying to terminate {}", (Object)clustername, (Object)e);
                return -1;
            }
        }
        try {
            ApplicationReport applicationReport;
            if (waittime > 0 && (applicationReport = application.monitorAppToState(YarnApplicationState.FINISHED, new Duration(waittime * 1000))) == null) {
                log.info("application did not shut down in time");
                return -1;
            }
        }
        catch (IOException | YarnException e) {
            log.warn("Exception while waiting for the application {} to shut down: {}", (Object)clustername, (Object)e);
        }
        return 0;
    }

    @Override
    public int actionThaw(String clustername, ActionThawArgs thaw) throws YarnException, IOException {
        SliderUtils.validateClusterName(clustername);
        this.verifyBindingsDefined();
        this.verifyNoLiveClusters(clustername, "Start");
        return this.startCluster(clustername, thaw);
    }

    public int flex(String clustername, Map<String, Integer> roleInstances) throws YarnException, IOException {
        this.verifyBindingsDefined();
        SliderUtils.validateClusterName(clustername);
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(clustername);
        AggregateConf instanceDefinition = this.loadInstanceDefinitionUnresolved(clustername, clusterDirectory);
        ConfTreeOperations resources = instanceDefinition.getResourceOperations();
        for (Map.Entry<String, Integer> entry : roleInstances.entrySet()) {
            String role = entry.getKey();
            int count = entry.getValue();
            resources.getOrAddComponent(role).put("yarn.component.instances", Integer.toString(count));
            log.debug("Flexed cluster specification ( {} -> {}) : \n{}", role, count, resources);
        }
        SliderAMClientProvider sliderAM = new SliderAMClientProvider(this.getConfig());
        AbstractClientProvider provider = this.createClientProvider(instanceDefinition.getInternalOperations().getGlobalOptions().getMandatoryOption("internal.provider.name"));
        this.validateInstanceDefinition(sliderAM, instanceDefinition, this.sliderFileSystem);
        this.validateInstanceDefinition(provider, instanceDefinition, this.sliderFileSystem);
        int exitCode = -1;
        try {
            InstanceIO.saveInstanceDefinition(this.sliderFileSystem, clusterDirectory, instanceDefinition);
        }
        catch (LockAcquireFailedException e) {
            log.debug("Failed to lock dir {}", (Object)clusterDirectory, (Object)e);
            log.warn("Failed to save new resource definition to {} : {}", (Object)clusterDirectory, (Object)e);
        }
        ApplicationReport instance = this.findInstance(clustername);
        if (instance != null) {
            log.info("Flexing running cluster");
            SliderClusterProtocol appMaster = this.connect(instance);
            SliderClusterOperations clusterOps = new SliderClusterOperations(appMaster);
            clusterOps.flex(instanceDefinition.getResources());
            log.info("application instance size updated");
            exitCode = 0;
        } else {
            log.info("No running instance to update");
        }
        return exitCode;
    }

    protected void validateInstanceDefinition(AbstractClientProvider provider, AggregateConf instanceDefinition, SliderFileSystem fs) throws SliderException {
        try {
            provider.validateInstanceDefinition(instanceDefinition, fs);
        }
        catch (SliderException e) {
            log.info("Error {} validating application instance definition ", (Object)e.getMessage());
            log.debug("Error validating application instance definition ", (Throwable)((Object)e));
            log.info(instanceDefinition.toString());
            throw e;
        }
    }

    @VisibleForTesting
    public AggregateConf loadPersistedClusterDescription(String clustername) throws IOException, SliderException, LockAcquireFailedException {
        Path clusterDirectory = this.sliderFileSystem.buildClusterDirPath(clustername);
        ConfPersister persister = new ConfPersister(this.sliderFileSystem, clusterDirectory);
        AggregateConf instanceDescription = new AggregateConf();
        persister.load(instanceDescription);
        return instanceDescription;
    }

    @VisibleForTesting
    public ClusterDescription getClusterDescription(String clustername) throws YarnException, IOException {
        SliderClusterOperations clusterOperations = this.createClusterOperations(clustername);
        return clusterOperations.getClusterDescription();
    }

    @VisibleForTesting
    public ClusterDescription getClusterDescription() throws YarnException, IOException {
        return this.getClusterDescription(this.getDeployedClusterName());
    }

    @VisibleForTesting
    public String[] listNodeUUIDsByRole(String role) throws IOException, YarnException {
        return this.createClusterOperations().listNodeUUIDsByRole(role);
    }

    @VisibleForTesting
    public List<ClusterNode> listClusterNodesInRole(String role) throws IOException, YarnException {
        return this.createClusterOperations().listClusterNodesInRole(role);
    }

    @VisibleForTesting
    public List<ClusterNode> listClusterNodes(String[] uuids) throws IOException, YarnException {
        if (uuids.length == 0) {
            return new LinkedList<ClusterNode>();
        }
        return this.createClusterOperations().listClusterNodes(uuids);
    }

    @VisibleForTesting
    public AggregateConf getLiveInstanceDefinition() throws IOException, YarnException {
        return this.createClusterOperations().getInstanceDefinition();
    }

    private SliderClusterProtocol bondToCluster(String clustername) throws YarnException, IOException {
        this.verifyBindingsDefined();
        if (clustername == null) {
            throw this.unknownClusterException("(undefined)");
        }
        ApplicationReport instance = this.findInstance(clustername);
        if (instance == null) {
            throw this.unknownClusterException(clustername);
        }
        return this.connect(instance);
    }

    private SliderClusterOperations createClusterOperations(String clustername) throws YarnException, IOException {
        SliderClusterProtocol sliderAM = this.bondToCluster(clustername);
        return new SliderClusterOperations(sliderAM);
    }

    private SliderClusterOperations createClusterOperations() throws YarnException, IOException {
        if (this.sliderClusterOperations == null) {
            this.sliderClusterOperations = this.createClusterOperations(this.getDeployedClusterName());
        }
        return this.sliderClusterOperations;
    }

    @VisibleForTesting
    public int waitForRoleInstanceLive(String role, long timeout) throws WaitTimeoutException, IOException, YarnException {
        return this.createClusterOperations().waitForRoleInstanceLive(role, timeout);
    }

    public UnknownApplicationInstanceException unknownClusterException(String clustername) {
        return UnknownApplicationInstanceException.unknownInstance(clustername);
    }

    public String toString() {
        return "Slider Client in state " + this.getServiceState() + " and Slider Application Instance " + this.deployedClusterName;
    }

    @VisibleForTesting
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        return this.yarnClient.getApplications();
    }

    @VisibleForTesting
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        return new LaunchedApplication(appId, this.yarnClient).getApplicationReport();
    }

    @VisibleForTesting
    public AggregateConf getLaunchedInstanceDefinition() {
        return this.launchedInstanceDefinition;
    }

    @Override
    public int actionResolve(ActionResolveArgs args) throws YarnException, IOException {
        block13: {
            args.validate();
            this.getRegistryOperations();
            String path = SliderRegistryUtils.resolvePath(args.path);
            RegistryUtils.ServiceRecordMarshal serviceRecordMarshal = new RegistryUtils.ServiceRecordMarshal();
            try {
                if (args.list) {
                    HashMap recordMap;
                    HashMap znodes;
                    File destDir = args.destdir;
                    if (destDir != null) {
                        destDir.mkdirs();
                    }
                    try {
                        znodes = RegistryUtils.statChildren((RegistryOperations)this.registryOperations, (String)path);
                        recordMap = RegistryUtils.extractServiceRecords((RegistryOperations)this.registryOperations, (String)path, znodes.values());
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                        if ("/".equals(path)) {
                            znodes = new HashMap(0);
                            recordMap = new HashMap(0);
                        }
                        throw pathNotFoundException;
                    }
                    log.info("Entries: {}", (Object)znodes.size());
                    for (String string : znodes.keySet()) {
                        SliderClient.println("  " + string);
                    }
                    SliderClient.println("");
                    log.info("Service records: {}", (Object)recordMap.size());
                    for (Map.Entry entry : recordMap.entrySet()) {
                        String name = (String)entry.getKey();
                        ServiceRecord instance = (ServiceRecord)entry.getValue();
                        String json = serviceRecordMarshal.toJson((Object)instance);
                        if (destDir == null) {
                            SliderClient.println(name);
                            SliderClient.println(json);
                            continue;
                        }
                        String filename = String.valueOf(RegistryPathUtils.lastPathEntry((String)name)) + ".json";
                        File jsonFile = new File(destDir, filename);
                        SliderUtils.write(jsonFile, serviceRecordMarshal.toBytes((Object)instance), true);
                    }
                    break block13;
                }
                ServiceRecord instance = this.resolve(path);
                File outFile = args.out;
                if (args.destdir != null) {
                    outFile = new File(args.destdir, RegistryPathUtils.lastPathEntry((String)path));
                }
                if (outFile != null) {
                    SliderUtils.write(outFile, serviceRecordMarshal.toBytes((Object)instance), true);
                } else {
                    SliderClient.println(serviceRecordMarshal.toJson((Object)instance));
                }
            }
            catch (PathNotFoundException | NoRecordException e) {
                throw new NotFoundException(e, path, new Object[0]);
            }
        }
        return 0;
    }

    @Override
    public int actionRegistry(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        block8: {
            registryArgs.validate();
            try {
                if (registryArgs.list) {
                    this.actionRegistryList(registryArgs);
                    break block8;
                }
                if (registryArgs.listConf) {
                    this.actionRegistryListConfigsYarn(registryArgs);
                    break block8;
                }
                if (registryArgs.listExports) {
                    this.actionRegistryListExports(registryArgs);
                    break block8;
                }
                if (SliderClient.isSet(registryArgs.getConf)) {
                    PublishedConfiguration publishedConfiguration = this.actionRegistryGetConfig(registryArgs);
                    this.outputConfig(publishedConfiguration, registryArgs);
                    break block8;
                }
                if (SliderClient.isSet(registryArgs.getExport)) {
                    PublishedExports publishedExports = this.actionRegistryGetExport(registryArgs);
                    this.outputExport(publishedExports, registryArgs);
                    break block8;
                }
                log.info(CommonArgs.usage(this.serviceArgs, "diagnostics"));
                return 4;
            }
            catch (FileNotFoundException e) {
                log.info("{}", (Object)e.toString());
                log.debug("{}", (Object)e, (Object)e);
                return 44;
            }
            catch (PathNotFoundException e) {
                log.info("{}", (Object)e.toString());
                log.debug("{}", (Object)e, (Object)e);
                return 44;
            }
        }
        return 0;
    }

    @VisibleForTesting
    public Collection<ServiceRecord> actionRegistryList(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        ArrayList<ServiceRecord> serviceRecords;
        String serviceType = registryArgs.serviceType;
        String name = registryArgs.name;
        RegistryOperations operations = this.getRegistryOperations();
        if (StringUtils.isEmpty(name)) {
            String path = RegistryUtils.serviceclassPath((String)RegistryUtils.currentUser(), (String)serviceType);
            try {
                Map recordMap = RegistryUtils.listServiceRecords((RegistryOperations)operations, (String)path);
                if (recordMap.isEmpty()) {
                    throw new UnknownApplicationInstanceException("No applications registered under " + path);
                }
                serviceRecords = recordMap.values();
            }
            catch (PathNotFoundException e) {
                throw new NotFoundException(path, new Object[]{e});
            }
        } else {
            ServiceRecord instance = this.lookupServiceRecord(registryArgs);
            serviceRecords = new ArrayList<ServiceRecord>(1);
            serviceRecords.add(instance);
        }
        for (ServiceRecord serviceRecord : serviceRecords) {
            this.logInstance(serviceRecord, registryArgs.verbose);
        }
        return serviceRecords;
    }

    @Override
    public int actionDiagnostic(ActionDiagnosticArgs diagnosticArgs) {
        block8: {
            try {
                if (diagnosticArgs.client) {
                    this.actionDiagnosticClient(diagnosticArgs);
                    break block8;
                }
                if (diagnosticArgs.application) {
                    this.actionDiagnosticApplication(diagnosticArgs);
                    break block8;
                }
                if (diagnosticArgs.yarn) {
                    this.actionDiagnosticYarn(diagnosticArgs);
                    break block8;
                }
                if (diagnosticArgs.credentials) {
                    this.actionDiagnosticCredentials();
                    break block8;
                }
                if (diagnosticArgs.all) {
                    this.actionDiagnosticAll(diagnosticArgs);
                    break block8;
                }
                if (diagnosticArgs.level) {
                    this.actionDiagnosticIntelligent(diagnosticArgs);
                    break block8;
                }
                log.info(CommonArgs.usage(this.serviceArgs, "diagnostics"));
                return 4;
            }
            catch (Exception e) {
                log.error(e.toString());
                return -1;
            }
        }
        return 0;
    }

    private void actionDiagnosticIntelligent(ActionDiagnosticArgs diagnosticArgs) throws YarnException, IOException, URISyntaxException {
        String clusterName = diagnosticArgs.name;
        SliderClient.requireArgumentSet("--name", clusterName);
        try {
            SliderUtils.validateClientConfigFile();
            log.info("Slider-client.xml is accessible");
        }
        catch (IOException e) {
            log.error("validation of slider-client.xml fails because: " + e, e);
            return;
        }
        SliderClusterOperations clusterOperations = this.createClusterOperations(clusterName);
        ClusterDescription clusterDescription = clusterOperations.getClusterDescription();
        log.info("Slider AppMaster is accessible");
        if (clusterDescription.state == 3) {
            AggregateConf instanceDefinition = clusterOperations.getInstanceDefinition();
            String imagePath = instanceDefinition.getInternalOperations().get("internal.application.image.path");
            if (imagePath == null) {
                ApplicationReport appReport = this.findInstance(clusterName);
                Path path1 = this.sliderFileSystem.getTempPathForCluster(clusterName);
                Path subPath = new Path(path1, String.valueOf(appReport.getApplicationId().toString()) + "/agent");
                imagePath = subPath.toString();
            }
            String pathStr = String.valueOf(imagePath) + "/" + "slider-agent.tar.gz";
            try {
                SliderUtils.validateHDFSFile(this.sliderFileSystem, pathStr);
                log.info("Slider agent package is properly installed");
            }
            catch (FileNotFoundException e) {
                log.error("can not find agent package: {}", (Object)pathStr);
                log.debug("can not find agent package: {}", (Object)pathStr, (Object)e);
                return;
            }
            catch (IOException e) {
                log.error("can not open agent package: {}", (Object)pathStr, (Object)e);
                return;
            }
            String pkgTarballPath = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations());
            try {
                SliderUtils.validateHDFSFile(this.sliderFileSystem, pkgTarballPath);
                log.info("Application package is properly installed");
            }
            catch (FileNotFoundException e) {
                log.error("can not find application package: {}", (Object)pkgTarballPath, (Object)e);
            }
            catch (IOException e) {
                log.error("can not open application package: {} ", (Object)pkgTarballPath, (Object)e);
            }
        }
    }

    private void actionDiagnosticAll(ActionDiagnosticArgs diagnosticArgs) throws IOException, YarnException {
        this.actionDiagnosticClient(diagnosticArgs);
        this.actionDiagnosticApplication(diagnosticArgs);
        this.actionDiagnosticSlider(diagnosticArgs);
        this.actionDiagnosticYarn(diagnosticArgs);
        this.actionDiagnosticCredentials();
    }

    private void actionDiagnosticCredentials() throws BadConfigException, IOException {
        if (SliderUtils.isHadoopClusterSecure(SliderUtils.loadSliderClientXML())) {
            String credentialCacheFileDescription = null;
            try {
                credentialCacheFileDescription = SliderUtils.checkCredentialCacheFile();
            }
            catch (BadConfigException e) {
                log.error("The credential config is not valid: " + e.toString());
                throw e;
            }
            catch (IOException e) {
                log.error("Unable to read the credential file: " + e.toString());
                throw e;
            }
            log.info("Credential cache file for the current user: " + credentialCacheFileDescription);
        } else {
            log.info("the cluster is not in secure mode");
        }
    }

    private void actionDiagnosticYarn(ActionDiagnosticArgs diagnosticArgs) throws IOException, YarnException {
        List yarnClusterInfo;
        JSONObject converter = null;
        log.info("the node in the YARN cluster has below state: ");
        try {
            yarnClusterInfo = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        }
        catch (YarnException e1) {
            log.error("Exception happened when fetching node report from the YARN cluster: " + e1.toString());
            throw e1;
        }
        catch (IOException e1) {
            log.error("Network problem happened when fetching node report YARN cluster: " + e1.toString());
            throw e1;
        }
        for (NodeReport nodeReport : yarnClusterInfo) {
            log.info(nodeReport.toString());
        }
        if (diagnosticArgs.verbose) {
            StringWriter configWriter = new StringWriter();
            try {
                Configuration.dumpConfiguration((Configuration)this.yarnClient.getConfig(), (Writer)configWriter);
            }
            catch (IOException e1) {
                log.error("Network problem happened when retrieving YARN config from YARN: " + e1.toString());
                throw e1;
            }
            try {
                converter = new JSONObject(((Object)configWriter).toString());
                log.info("the configuration of the YARN cluster is: " + converter.toString(2));
            }
            catch (JSONException e) {
                log.error("JSONException happened during parsing response from YARN: " + e.toString());
            }
        }
    }

    private void actionDiagnosticSlider(ActionDiagnosticArgs diagnosticArgs) throws YarnException, IOException {
        String clusterName = diagnosticArgs.name;
        if (SliderClient.isUnset(clusterName)) {
            throw new BadCommandArgumentsException("application name must be provided with --name option", new Object[0]);
        }
        AggregateConf instanceDefinition = this.fetchInstanceDefinition(clusterName);
        String imagePath = instanceDefinition.getInternalOperations().get("internal.application.image.path");
        if (imagePath == null) {
            ApplicationReport appReport = this.findInstance(clusterName);
            Path path1 = this.sliderFileSystem.getTempPathForCluster(clusterName);
            Path subPath = new Path(path1, String.valueOf(appReport.getApplicationId().toString()) + "/agent");
            imagePath = subPath.toString();
        }
        log.info("The path of slider agent tarball on HDFS is: " + imagePath);
    }

    private AggregateConf fetchInstanceDefinition(String clusterName) throws YarnException, IOException {
        AggregateConf instanceDefinition = null;
        try {
            SliderClusterOperations clusterOperations = this.createClusterOperations(clusterName);
            instanceDefinition = clusterOperations.getInstanceDefinition();
        }
        catch (IOException | YarnException e) {
            log.error("Failed to retrieve instance definition from YARN: " + e.toString());
            throw e;
        }
        return instanceDefinition;
    }

    private void actionDiagnosticApplication(ActionDiagnosticArgs diagnosticArgs) throws YarnException, IOException {
        String clusterName = diagnosticArgs.name;
        SliderClient.requireArgumentSet("--name", clusterName);
        AggregateConf instanceDefinition = this.fetchInstanceDefinition(clusterName);
        String clusterDir = instanceDefinition.getAppConfOperations().getGlobalOptions().get("site.global.app_root");
        String pkgTarball = SliderUtils.getApplicationDefinitionPath(instanceDefinition.getAppConfOperations());
        String runAsUser = instanceDefinition.getAppConfOperations().getGlobalOptions().get("site.global.app_user");
        log.info("The location of the cluster instance directory in HDFS is: {}", (Object)clusterDir);
        log.info("The name of the application package tarball on HDFS is: {}", (Object)pkgTarball);
        log.info("The runas user of the application in the cluster is: {}", (Object)runAsUser);
        if (diagnosticArgs.verbose) {
            log.info("App config of the application:\n{}", (Object)instanceDefinition.getAppConf().toJson());
            log.info("Resource config of the application:\n{}", (Object)instanceDefinition.getResources().toJson());
        }
    }

    private void actionDiagnosticClient(ActionDiagnosticArgs diagnosticArgs) throws SliderException, IOException {
        try {
            String currentCommandPath = SliderUtils.getCurrentCommandPath();
            SliderVersionInfo.loadAndPrintVersionInfo(log);
            String clientConfigPath = SliderUtils.getClientConfigPath();
            String jdkInfo = SliderUtils.getJDKInfo();
            SliderClient.println("The slider command path: %s", currentCommandPath);
            SliderClient.println("The slider-client.xml used by current running command path: %s", clientConfigPath);
            SliderClient.println(jdkInfo);
            Configuration config = this.getConfig();
            if (SliderUtils.isHadoopClusterSecure(config)) {
                SliderClient.println("Hadoop Cluster is secure");
                SliderClient.println("Login user is %s", UserGroupInformation.getLoginUser());
                SliderClient.println("Current user is %s", UserGroupInformation.getCurrentUser());
            } else {
                SliderClient.println("Hadoop Cluster is insecure");
            }
            if (diagnosticArgs.verbose) {
                Map<String, String> env = SliderUtils.getSystemEnv();
                Set<String> envList = ConfigHelper.sortedConfigKeys(env.entrySet());
                StringBuilder builder = new StringBuilder("Environment variables:\n");
                for (String key : envList) {
                    builder.append(key).append("=").append(env.get(key)).append("\n");
                }
                SliderClient.println(builder.toString());
                builder = new StringBuilder("JVM Properties\n");
                Map<String, String> props = SliderUtils.sortedMap(SliderUtils.toMap(System.getProperties()));
                for (Map.Entry<String, String> entry : props.entrySet()) {
                    builder.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                }
                SliderClient.println(builder.toString());
                SliderClient.println("Slider client configuration:\n" + ConfigHelper.dumpConfigToString(config));
            }
            SliderUtils.validateSliderClientEnvironment(log);
        }
        catch (IOException | SliderException e) {
            log.error(((Throwable)e).toString());
            throw e;
        }
    }

    private int actionKDiag(ActionKDiagArgs args) throws Exception {
        PrintWriter out = new PrintWriter(System.err);
        boolean closeStream = false;
        if (args.out != null) {
            out = new PrintWriter(new FileOutputStream(args.out));
            closeStream = true;
        }
        try {
            try {
                KerberosDiags kdiags = new KerberosDiags(this.getConfig(), out, args.services, args.keytab, args.principal);
                kdiags.execute();
            }
            catch (KerberosDiags.KerberosDiagsFailure e) {
                log.error(e.toString());
                log.debug(e.toString(), (Throwable)((Object)e));
                if (args.fail) {
                    throw e;
                }
                if (closeStream) {
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                log.error("Kerberos Diagnostics", e);
                if (args.fail) {
                    throw e;
                }
                if (closeStream) {
                    out.flush();
                    out.close();
                }
            }
        }
        finally {
            if (closeStream) {
                out.flush();
                out.close();
            }
        }
        return 0;
    }

    private void logInstance(ServiceRecord instance, boolean verbose) {
        if (!verbose) {
            log.info("{}", (Object)instance.get("yarn:id", ""));
        } else {
            log.info("{}: ", (Object)instance.get("yarn:id", ""));
            this.logEndpoints(instance);
        }
    }

    private void logEndpoints(ServiceRecord instance) {
        List endpoints = instance.external;
        for (Endpoint endpoint : endpoints) {
            log.info(endpoint.toString());
        }
    }

    public void actionRegistryListConfigsYarn(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        ServiceRecord instance = this.lookupServiceRecord(registryArgs);
        RegistryRetriever retriever = new RegistryRetriever(this.getConfig(), instance);
        PublishedConfigSet configurations = retriever.getConfigurations(!registryArgs.internal);
        PrintStream out = null;
        try {
            out = registryArgs.out != null ? new PrintStream(new FileOutputStream(registryArgs.out)) : System.out;
            for (String configName : configurations.keys()) {
                if (!registryArgs.verbose) {
                    out.println(configName);
                    continue;
                }
                PublishedConfiguration published = configurations.get(configName);
                out.printf("%s: %s\n", configName, published.description);
            }
        }
        finally {
            if (registryArgs.out != null && out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public void actionRegistryListExports(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        ServiceRecord instance = this.lookupServiceRecord(registryArgs);
        RegistryRetriever retriever = new RegistryRetriever(this.getConfig(), instance);
        PublishedExportsSet exports = retriever.getExports(!registryArgs.internal);
        PrintStream out = null;
        boolean streaming = false;
        try {
            if (registryArgs.out != null) {
                out = new PrintStream(new FileOutputStream(registryArgs.out));
                streaming = true;
                log.debug("Saving output to {}", (Object)registryArgs.out);
            } else {
                out = System.out;
            }
            log.debug("Number of exports: {}", (Object)exports.keys().size());
            for (String exportName : exports.keys()) {
                if (streaming) {
                    log.debug(exportName);
                }
                if (!registryArgs.verbose) {
                    out.println(exportName);
                    continue;
                }
                PublishedExports published = exports.get(exportName);
                out.printf("%s: %s\n", exportName, published.description);
            }
        }
        finally {
            if (streaming) {
                out.flush();
                out.close();
            }
        }
    }

    @VisibleForTesting
    public PublishedConfiguration actionRegistryGetConfig(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        ServiceRecord instance = this.lookupServiceRecord(registryArgs);
        RegistryRetriever retriever = new RegistryRetriever(this.getConfig(), instance);
        boolean external = !registryArgs.internal;
        PublishedConfigSet configurations = retriever.getConfigurations(external);
        PublishedConfiguration published = retriever.retrieveConfiguration(configurations, registryArgs.getConf, external);
        return published;
    }

    @VisibleForTesting
    public PublishedExports actionRegistryGetExport(ActionRegistryArgs registryArgs) throws YarnException, IOException {
        ServiceRecord instance = this.lookupServiceRecord(registryArgs);
        RegistryRetriever retriever = new RegistryRetriever(this.getConfig(), instance);
        boolean external = !registryArgs.internal;
        PublishedExportsSet exports = retriever.getExports(external);
        PublishedExports published = retriever.retrieveExports(exports, registryArgs.getExport, external);
        return published;
    }

    private void outputConfig(PublishedConfiguration published, ActionRegistryArgs registryArgs) throws BadCommandArgumentsException, IOException {
        boolean print;
        String entry = registryArgs.getConf;
        String format = registryArgs.format;
        ConfigFormat configFormat = ConfigFormat.resolve(format);
        if (configFormat == null) {
            throw new BadCommandArgumentsException("Unknown/Unsupported format %s ", format);
        }
        PublishedConfigurationOutputter outputter = PublishedConfigurationOutputter.createOutputter(configFormat, published);
        boolean bl = print = registryArgs.out == null;
        if (!print) {
            File outputPath = registryArgs.out;
            if (outputPath.isDirectory()) {
                outputPath = new File(outputPath, String.valueOf(entry) + "." + format);
            }
            log.debug("Destination path: {}", (Object)outputPath);
            outputter.save(outputPath);
        } else {
            SliderClient.print(outputter.asString());
        }
    }

    private void outputExport(PublishedExports published, ActionRegistryArgs registryArgs) throws BadCommandArgumentsException, IOException {
        boolean print;
        String entry = registryArgs.getExport;
        String format = ConfigFormat.JSON.toString();
        ConfigFormat configFormat = ConfigFormat.resolve(format);
        if (configFormat == null || configFormat != ConfigFormat.JSON) {
            throw new BadCommandArgumentsException("Unknown/Unsupported format %s . Only JSON is supported.", format);
        }
        PublishedExportsOutputter outputter = PublishedExportsOutputter.createOutputter(configFormat, published);
        boolean bl = print = registryArgs.out == null;
        if (!print) {
            File destFile = registryArgs.out;
            if (destFile.isDirectory()) {
                destFile = new File(destFile, String.valueOf(entry) + "." + format);
            }
            log.info("Destination path: {}", (Object)destFile);
            outputter.save(destFile);
        } else {
            SliderClient.print(outputter.asString());
        }
    }

    private ServiceRecord lookupServiceRecord(ActionRegistryArgs registryArgs) throws SliderException, IOException {
        String user = StringUtils.isNotEmpty(registryArgs.user) ? RegistryPathUtils.encodeForRegistry((String)registryArgs.user) : RegistryUtils.currentUser();
        String path = RegistryUtils.servicePath((String)user, (String)registryArgs.serviceType, (String)registryArgs.name);
        return this.resolve(path);
    }

    public ServiceRecord lookupServiceRecord(String serviceType, String id) throws IOException, SliderException {
        String path = RegistryUtils.servicePath((String)RegistryUtils.currentUser(), (String)serviceType, (String)id);
        return this.resolve(path);
    }

    public ServiceRecord resolve(String path) throws IOException, SliderException {
        try {
            return this.getRegistryOperations().resolve(path);
        }
        catch (PathNotFoundException | NoRecordException e) {
            throw new NotFoundException(e.getPath().toString(), new Object[]{e});
        }
    }

    public Map<String, ServiceRecord> listRegistryInstances() throws IOException, SliderException {
        Map recordMap = RegistryUtils.listServiceRecords((RegistryOperations)this.getRegistryOperations(), (String)RegistryUtils.serviceclassPath((String)RegistryUtils.currentUser(), (String)"org-apache-slider"));
        return recordMap;
    }

    public List<String> listRegisteredSliderInstances() throws IOException, YarnException {
        try {
            Map recordMap = RegistryUtils.listServiceRecords((RegistryOperations)this.getRegistryOperations(), (String)RegistryUtils.serviceclassPath((String)RegistryUtils.currentUser(), (String)"org-apache-slider"));
            return new ArrayList<String>(recordMap.keySet());
        }
        catch (PathNotFoundException e) {
            log.debug("No registry path for slider instances for current user: {}", (Object)e, (Object)e);
            return new ArrayList<String>(0);
        }
        catch (IOException | YarnException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private synchronized RegistryOperations maybeStartYarnRegistry() throws SliderException, IOException {
        if (this.registryOperations == null) {
            this.registryOperations = this.startRegistryOperationsService();
        }
        return this.registryOperations;
    }

    @Override
    public RegistryOperations getRegistryOperations() throws SliderException, IOException {
        return this.maybeStartYarnRegistry();
    }

    private static void print(CharSequence src) {
        clientOutputStream.append(src);
    }

    private static void println(String message) {
        SliderClient.print(message);
        SliderClient.print("\n");
    }

    private static void println(String message, Object ... args) {
        SliderClient.print(String.format(message, args));
        SliderClient.print("\n");
    }

    @VisibleForTesting
    public int actionLookup(ActionLookupArgs args) throws IOException, YarnException {
        this.verifyBindingsDefined();
        try {
            ApplicationId id = ConverterUtils.toApplicationId((String)args.id);
            ApplicationReport report = this.yarnClient.getApplicationReport(id);
            SerializedApplicationReport sar = new SerializedApplicationReport(report);
            ApplicationReportSerDeser serDeser = new ApplicationReportSerDeser();
            if (args.outputFile != null) {
                serDeser.save(sar, args.outputFile);
            } else {
                SliderClient.println(serDeser.toJson(sar));
            }
        }
        catch (IllegalArgumentException e) {
            throw new BadCommandArgumentsException(e, "%s : %s", args, e);
        }
        catch (ApplicationAttemptNotFoundException | ApplicationNotFoundException notFound) {
            throw new NotFoundException(notFound, notFound.toString(), new Object[0]);
        }
        return 0;
    }

    @Override
    public int actionDependency(ActionDependencyArgs args) throws IOException, YarnException {
        String hdfsUser = "hdfs";
        String currentUser = this.getUsername();
        if (!hdfsUser.equalsIgnoreCase(currentUser)) {
            log.error("Please run this command as user {}", (Object)hdfsUser);
            return -1;
        }
        String version = SliderUtils.getSliderVersion();
        Path dependencyLibTarGzip = this.sliderFileSystem.getDependencyTarGzip();
        if (this.sliderFileSystem.isFile(dependencyLibTarGzip) && !args.overwrite) {
            SliderClient.println(String.format("Dependency libs are already uploaded to %s. Use %s if you want to re-upload", dependencyLibTarGzip.toUri(), "--overwrite"));
            return 0;
        }
        String libDir = System.getProperty("slider.libdir");
        if (SliderClient.isSet(libDir)) {
            File srcFolder = new File(libDir);
            File tempLibTarGzipFile = File.createTempFile("slider_", ".tar.gz");
            SliderUtils.tarGzipFolder(srcFolder, tempLibTarGzipFile, SliderUtils.createJarFilter());
            log.info("Uploading dependency for AM (version {}) from {} to {}", version, tempLibTarGzipFile.toURI(), dependencyLibTarGzip.toUri());
            this.sliderFileSystem.copyLocalFileToHdfs(tempLibTarGzipFile, dependencyLibTarGzip, new FsPermission("755"));
            return 0;
        }
        return -1;
    }

    private int actionHelp(String actionName) throws YarnException, IOException {
        throw new UsageException(CommonArgs.usage(this.serviceArgs, actionName), new Object[0]);
    }

    private int actionHelp(String errMsg, String actionName) throws YarnException, IOException {
        throw new UsageException("%s %s", errMsg, CommonArgs.usage(this.serviceArgs, actionName));
    }

    @Override
    public NodeInformationList listYarnClusterNodes(ActionNodesArgs args) throws YarnException, IOException {
        return this.yarnClient.listNodes(args.label, args.healthy);
    }

    public NodeInformationList listInstanceNodes(String instance, ActionNodesArgs args) throws YarnException, IOException {
        log.info("listInstanceNodes {}", (Object)instance);
        SliderClusterOperations clusterOps = new SliderClusterOperations(this.bondToCluster(instance));
        return clusterOps.getLiveNodes();
    }

    public int actionNodes(String instance, ActionNodesArgs args) throws YarnException, IOException {
        args.instance = instance;
        NodeInformationList nodes = SliderUtils.isUnset(instance) ? this.listYarnClusterNodes(args) : this.listInstanceNodes(instance, args);
        log.debug("Node listing for {} has {} nodes", (Object)args, (Object)nodes.size());
        JsonSerDeser<NodeInformationList> serDeser = NodeInformationList.createSerializer();
        if (args.outputFile != null) {
            serDeser.save(nodes, args.outputFile);
        } else {
            SliderClient.println(serDeser.toJson(nodes));
        }
        return 0;
    }

    public SliderApplicationApi createIpcClient() throws IOException, YarnException {
        return new SliderApplicationIpcClient(this.createClusterOperations());
    }
}

