/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.http.HttpServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4j2ConfiguratorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Log4j2ConfiguratorServlet.class);
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ALLOWED_METHODS = "POST, GET";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String CONTENT_TYPE_JSON_UTF8 = "application/json; charset=utf8";
    private transient LoggerContext context;
    private transient Configuration conf;

    @Override
    public void init() throws ServletException {
        this.context = (LoggerContext)LogManager.getContext(false);
        this.conf = this.context.getConfiguration();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            response.setStatus(401);
            return;
        }
        this.setResponseHeader(response);
        this.listLoggers(response);
    }

    private void setResponseHeader(HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE_JSON_UTF8);
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            response.setStatus(401);
            return;
        }
        this.setResponseHeader(response);
        String dataJson = request.getReader().lines().collect(Collectors.joining());
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ConfLoggers confLoggers = (ConfLoggers)objectMapper.readValue(dataJson, ConfLoggers.class);
            this.configureLogger(confLoggers);
        }
        catch (IOException e) {
            response.setStatus(400);
            LOG.error("Error configuring log4j2 via /conflog endpoint.", e);
            return;
        }
        response.setStatus(200);
    }

    private void configureLogger(ConfLoggers confLoggers) {
        if (confLoggers != null) {
            for (ConfLogger logger : confLoggers.getLoggers()) {
                String loggerName = logger.getLogger();
                Level logLevel = Level.getLevel(logger.getLevel());
                if (logLevel == null) {
                    LOG.warn("Invalid log level: {} for logger: {}. Ignoring reconfiguration.", (Object)loggerName, (Object)logger.getLevel());
                    continue;
                }
                LoggerConfig loggerConfig = this.conf.getLoggerConfig(loggerName);
                if (!loggerName.equals("") && loggerConfig.getName().equals("")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Requested logger ({}) not found. Adding as new logger with {} level", (Object)loggerName, (Object)logLevel);
                    }
                    this.conf.addLogger(loggerName, new LoggerConfig(loggerName, logLevel, true));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating logger ({}) to {} level", (Object)loggerName, (Object)logLevel);
                }
                loggerConfig.setLevel(logLevel);
            }
            this.context.updateLoggers(this.conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listLoggers(HttpServletResponse response) throws IOException {
        try (PrintWriter writer = null;){
            writer = response.getWriter();
            ConfLoggers confLoggers = new ConfLoggers();
            Collection<LoggerConfig> loggerConfigs = this.conf.getLoggers().values();
            loggerConfigs.forEach(lc -> confLoggers.getLoggers().add(new ConfLogger(lc.getName(), lc.getLevel().toString())));
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, (Object)confLoggers);
        }
        response.setStatus(200);
    }

    private static class ConfLogger {
        private String logger;
        private String level;

        public ConfLogger() {
            this(null, null);
        }

        public ConfLogger(String logger, String level) {
            this.logger = logger;
            this.level = level;
        }

        public String getLogger() {
            return this.logger == null ? this.logger : this.logger.trim();
        }

        public void setLogger(String logger) {
            this.logger = logger;
        }

        public String getLevel() {
            return this.level == null ? this.level : this.level.trim().toUpperCase();
        }

        public void setLevel(String level) {
            this.level = level;
        }
    }

    private static class ConfLoggers {
        private List<ConfLogger> loggers = new ArrayList<ConfLogger>();

        public List<ConfLogger> getLoggers() {
            return this.loggers;
        }

        public void setLoggers(List<ConfLogger> loggers) {
            this.loggers = loggers;
        }
    }
}

