/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.io.HdfsUtils;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;

public class FileMetadataManager {
    private static final Log LOG = LogFactory.getLog(FileMetadataManager.class);
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private final HiveMetaStore.ThreadLocalRawStore tlms;
    private final ExecutorService threadPool;
    private final HiveConf conf;

    public FileMetadataManager(HiveMetaStore.ThreadLocalRawStore tlms, HiveConf conf) {
        this.tlms = tlms;
        this.conf = conf;
        int numThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.METASTORE_HBASE_FILE_METADATA_THREADS);
        this.threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("File-Metadata-%d").setDaemon(true).build());
    }

    public void queueCacheMetadata(String location, FileMetadataExprType type) {
        this.threadPool.submit(new CacheUpdateRequest(type, location));
    }

    private void cacheMetadata(FileMetadataExprType type, String location) throws MetaException, IOException, InterruptedException {
        ArrayList<Object> files;
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem((Configuration)this.conf);
        if (!fs.isDirectory(path)) {
            files = Lists.newArrayList(path);
        } else {
            files = new ArrayList();
            RemoteIterator iter = fs.listFiles(path, true);
            while (iter.hasNext()) {
                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)iter.next();
                if (locatedFileStatus.isDirectory()) continue;
                files.add(locatedFileStatus.getPath());
            }
        }
        for (Path path2 : files) {
            long fileId;
            try {
                fileId = SHIMS.getFileId(fs, Path.getPathWithoutSchemeAndAuthority((Path)path2).toString());
            }
            catch (UnsupportedOperationException ex) {
                LOG.error("Cannot cache file metadata for " + location + "; " + fs.getClass().getCanonicalName() + " does not support fileId");
                return;
            }
            LOG.info("Caching file metadata for " + path2 + " (file ID " + fileId + ")");
            Path path3 = HdfsUtils.getFileIdPath(fs, path2, fileId);
            this.tlms.getMS().getFileMetadataHandler(type).cacheFileMetadata(fileId, fs, path3);
        }
    }

    private final class CacheUpdateRequest
    implements Callable<Void> {
        FileMetadataExprType type;
        String location;

        public CacheUpdateRequest(FileMetadataExprType type, String location) {
            this.type = type;
            this.location = location;
        }

        @Override
        public Void call() throws Exception {
            try {
                FileMetadataManager.this.cacheMetadata(this.type, this.location);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                LOG.error("Failed to cache file metadata in background for " + this.type + ", " + this.location, ex);
            }
            return null;
        }
    }
}

