/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx;

import org.apache.hive.druid.org.jboss.netty.channel.ChannelFuture;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.org.jboss.netty.channel.ChannelPipeline;
import org.apache.hive.druid.org.jboss.netty.channel.Channels;
import org.apache.hive.druid.org.jboss.netty.channel.MessageEvent;
import org.apache.hive.druid.org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpVersion;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import org.apache.hive.druid.org.jboss.netty.handler.ssl.SslHandler;
import org.apache.hive.druid.org.jboss.netty.logging.InternalLogger;
import org.apache.hive.druid.org.jboss.netty.logging.InternalLoggerFactory;

public class WebSocketServerProtocolHandshakeHandler
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerProtocolHandshakeHandler.class);
    private final String websocketPath;
    private final String subprotocols;
    private final boolean allowExtensions;

    public WebSocketServerProtocolHandshakeHandler(String websocketPath, String subprotocols, boolean allowExtensions) {
        this.websocketPath = websocketPath;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
    }

    public void messageReceived(final ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)e.getMessage();
            if (req.getMethod() != HttpMethod.GET) {
                WebSocketServerProtocolHandshakeHandler.sendHttpResponse(ctx, req, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                return;
            }
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(ctx.getPipeline(), req, this.websocketPath), this.subprotocols, this.allowExtensions);
            WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
            if (handshaker == null) {
                wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
            } else {
                ChannelFuture handshakeFuture = handshaker.handshake(ctx.getChannel(), req);
                handshakeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            Channels.fireExceptionCaught(ctx, future.getCause());
                        }
                    }
                });
                WebSocketServerProtocolHandler.setHandshaker(ctx, handshaker);
                ctx.getPipeline().replace(this, "WS403Responder", WebSocketServerProtocolHandler.forbiddenHttpRequestResponder());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Exception Caught", cause);
        ctx.getChannel().close();
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        ChannelFuture f = ctx.getChannel().write(res);
        if (!HttpHeaders.isKeepAlive(req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline cp, HttpRequest req, String path) {
        String protocol = "ws";
        if (cp.get(SslHandler.class) != null) {
            protocol = "wss";
        }
        return protocol + "://" + req.headers().get("Host") + path;
    }
}

