/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.jboss.netty.channel.socket.nio;

import java.nio.ByteBuffer;
import org.apache.hive.druid.org.jboss.netty.util.ExternalResourceReleasable;
import org.apache.hive.druid.org.jboss.netty.util.internal.ByteBufferUtil;

final class SocketReceiveBufferAllocator
implements ExternalResourceReleasable {
    private ByteBuffer buf;
    private int exceedCount;
    private final int maxExceedCount;
    private final int percentual;

    SocketReceiveBufferAllocator() {
        this(16, 80);
    }

    SocketReceiveBufferAllocator(int maxExceedCount, int percentual) {
        this.maxExceedCount = maxExceedCount;
        this.percentual = percentual;
    }

    ByteBuffer get(int size) {
        if (this.buf == null) {
            return this.newBuffer(size);
        }
        if (this.buf.capacity() < size) {
            return this.newBuffer(size);
        }
        if (this.buf.capacity() * this.percentual / 100 > size) {
            if (++this.exceedCount == this.maxExceedCount) {
                return this.newBuffer(size);
            }
            this.buf.clear();
        } else {
            this.exceedCount = 0;
            this.buf.clear();
        }
        return this.buf;
    }

    private ByteBuffer newBuffer(int size) {
        if (this.buf != null) {
            this.exceedCount = 0;
            ByteBufferUtil.destroy(this.buf);
        }
        this.buf = ByteBuffer.allocateDirect(SocketReceiveBufferAllocator.normalizeCapacity(size));
        return this.buf;
    }

    private static int normalizeCapacity(int capacity) {
        int q = capacity >>> 10;
        int r = capacity & 0x3FF;
        if (r != 0) {
            ++q;
        }
        return q << 10;
    }

    public void releaseExternalResources() {
        if (this.buf != null) {
            ByteBufferUtil.destroy(this.buf);
        }
    }
}

