/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.embedded;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hive.druid.io.netty.channel.AbstractChannel;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelConfig;
import org.apache.hive.druid.io.netty.channel.ChannelFuture;
import org.apache.hive.druid.io.netty.channel.ChannelFutureListener;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInitializer;
import org.apache.hive.druid.io.netty.channel.ChannelMetadata;
import org.apache.hive.druid.io.netty.channel.ChannelOutboundBuffer;
import org.apache.hive.druid.io.netty.channel.ChannelPipeline;
import org.apache.hive.druid.io.netty.channel.ChannelPromise;
import org.apache.hive.druid.io.netty.channel.DefaultChannelConfig;
import org.apache.hive.druid.io.netty.channel.DefaultChannelPipeline;
import org.apache.hive.druid.io.netty.channel.EventLoop;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedEventLoop;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedSocketAddress;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;
import org.apache.hive.druid.io.netty.util.internal.PlatformDependent;
import org.apache.hive.druid.io.netty.util.internal.RecyclableArrayList;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLogger;
import org.apache.hive.druid.io.netty.util.internal.logging.InternalLoggerFactory;

public class EmbeddedChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            EmbeddedChannel.this.recordException(future);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private int state;

    public EmbeddedChannel(ChannelHandler ... handlers) {
        this(false, handlers);
    }

    public EmbeddedChannel(boolean hasDisconnect, ChannelHandler ... handlers) {
        this(true, hasDisconnect, handlers);
    }

    public EmbeddedChannel(boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        super(null);
        this.metadata = EmbeddedChannel.metadata(hasDisconnect);
        this.config = new DefaultChannelConfig(this);
        this.setup(register, handlers);
    }

    public EmbeddedChannel(boolean hasDisconnect, ChannelConfig config, ChannelHandler ... handlers) {
        super(null);
        this.metadata = EmbeddedChannel.metadata(hasDisconnect);
        this.config = ObjectUtil.checkNotNull(config, "config");
        this.setup(true, handlers);
    }

    private static ChannelMetadata metadata(boolean hasDisconnect) {
        return hasDisconnect ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean register, final ChannelHandler ... handlers) {
        ObjectUtil.checkNotNull(handlers, "handlers");
        ChannelPipeline p = this.pipeline();
        p.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                for (ChannelHandler h : handlers) {
                    if (h == null) break;
                    pipeline.addLast(h);
                }
            }
        });
        if (register) {
            ChannelFuture future = this.loop.register(this);
            assert (future.isDone());
        }
    }

    public void register() throws Exception {
        ChannelFuture future = this.loop.register(this);
        assert (future.isDone());
        Throwable cause = future.cause();
        if (cause != null) {
            PlatformDependent.throwException(cause);
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public Object readInbound() {
        return EmbeddedChannel.poll(this.inboundMessages);
    }

    public Object readOutbound() {
        return EmbeddedChannel.poll(this.outboundMessages);
    }

    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline p = this.pipeline();
        for (Object m : msgs) {
            p.fireChannelRead(m);
        }
        p.fireChannelReadComplete();
        this.runPendingTasks();
        this.checkException();
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList futures = RecyclableArrayList.newInstance(msgs.length);
        try {
            for (Object m : msgs) {
                if (m == null) break;
                futures.add(this.write(m));
            }
            this.runPendingTasks();
            this.flush();
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ChannelFuture future = (ChannelFuture)futures.get(i);
                if (future.isDone()) {
                    this.recordException(future);
                    continue;
                }
                future.addListener(this.recordExceptionListener);
            }
            this.checkException();
            int n = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            futures.recycle();
        }
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean releaseAll) {
        this.close();
        try {
            this.checkException();
            boolean bl = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl;
        }
        finally {
            if (releaseAll) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object msg;
            while ((msg = queue.poll()) != null) {
                ReferenceCountUtil.release(msg);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean cancel) {
        this.runPendingTasks();
        if (cancel) {
            this.loop.cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise promise) {
        this.runPendingTasks();
        ChannelFuture future = super.close(promise);
        this.finishPendingTasks(true);
        return future;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise promise) {
        ChannelFuture future = super.disconnect(promise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return future;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
        try {
            this.loop.runScheduledTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
    }

    public long runScheduledPendingTasks() {
        try {
            return this.loop.runScheduledTasks();
        }
        catch (Exception e) {
            this.recordException(e);
            return this.loop.nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture future) {
        if (!future.isSuccess()) {
            this.recordException(future.cause());
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    public void checkException() {
        Throwable t = this.lastException;
        if (t == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(t);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? this.localAddress : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? this.remoteAddress : null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = 1;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = 2;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    @Override
    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            ReferenceCountUtil.retain(msg);
            this.outboundMessages().add(msg);
            in.remove();
        }
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline(EmbeddedChannel channel) {
            super(channel);
        }

        @Override
        protected void onUnhandledInboundException(Throwable cause) {
            EmbeddedChannel.this.recordException(cause);
        }

        @Override
        protected void onUnhandledInboundMessage(Object msg) {
            EmbeddedChannel.this.inboundMessages().add(msg);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped;

        private EmbeddedUnsafe() {
            super(EmbeddedChannel.this);
            this.wrapped = new Channel.Unsafe(){

                @Override
                public SocketAddress localAddress() {
                    return EmbeddedUnsafe.this.localAddress();
                }

                @Override
                public SocketAddress remoteAddress() {
                    return EmbeddedUnsafe.this.remoteAddress();
                }

                @Override
                public void register(EventLoop eventLoop, ChannelPromise promise) {
                    EmbeddedUnsafe.this.register(eventLoop, promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void bind(SocketAddress localAddress, ChannelPromise promise) {
                    EmbeddedUnsafe.this.bind(localAddress, promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    EmbeddedUnsafe.this.connect(remoteAddress, localAddress, promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void disconnect(ChannelPromise promise) {
                    EmbeddedUnsafe.this.disconnect(promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void close(ChannelPromise promise) {
                    EmbeddedUnsafe.this.close(promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void closeForcibly() {
                    EmbeddedUnsafe.this.closeForcibly();
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void deregister(ChannelPromise promise) {
                    EmbeddedUnsafe.this.deregister(promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void beginRead() {
                    EmbeddedUnsafe.this.beginRead();
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void write(Object msg, ChannelPromise promise) {
                    EmbeddedUnsafe.this.write(msg, promise);
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public void flush() {
                    EmbeddedUnsafe.this.flush();
                    EmbeddedChannel.this.runPendingTasks();
                }

                @Override
                public ChannelPromise voidPromise() {
                    return EmbeddedUnsafe.this.voidPromise();
                }

                @Override
                public ChannelOutboundBuffer outboundBuffer() {
                    return EmbeddedUnsafe.this.outboundBuffer();
                }
            };
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }
}

