/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerConfig;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerSelectorStrategy;

public class PriorityTieredBrokerSelectorStrategy
implements TieredBrokerSelectorStrategy {
    private final int minPriority;
    private final int maxPriority;

    @JsonCreator
    public PriorityTieredBrokerSelectorStrategy(@JsonProperty(value="minPriority") Integer minPriority, @JsonProperty(value="maxPriority") Integer maxPriority) {
        this.minPriority = minPriority == null ? 0 : minPriority;
        this.maxPriority = maxPriority == null ? 1 : maxPriority;
    }

    @Override
    public Optional<String> getBrokerServiceName(TieredBrokerConfig tierConfig, Query query) {
        int priority = QueryContexts.getPriority(query);
        if (priority < this.minPriority) {
            return Optional.of(Iterables.getLast(tierConfig.getTierToBrokerMap().values(), tierConfig.getDefaultBrokerServiceName()));
        }
        if (priority >= this.maxPriority) {
            return Optional.of(Iterables.getFirst(tierConfig.getTierToBrokerMap().values(), tierConfig.getDefaultBrokerServiceName()));
        }
        return Optional.absent();
    }
}

