/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.metrics;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.metrics.AbstractMonitor;
import org.apache.hive.druid.com.metamx.metrics.KeyedDiff;
import org.apache.hive.druid.io.druid.server.metrics.QueryCountStatsProvider;

public class QueryCountStatsMonitor
extends AbstractMonitor {
    private final KeyedDiff keyedDiff = new KeyedDiff();
    private final QueryCountStatsProvider statsProvider;

    @Inject
    public QueryCountStatsMonitor(QueryCountStatsProvider statsProvider) {
        this.statsProvider = statsProvider;
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        Map<String, Long> diff = this.keyedDiff.to("queryCountStats", ImmutableMap.of("query/success/count", this.statsProvider.getSuccessfulQueryCount(), "query/failed/count", this.statsProvider.getFailedQueryCount(), "query/interrupted/count", this.statsProvider.getInterruptedQueryCount()));
        if (diff != null) {
            for (Map.Entry<String, Long> diffEntry : diff.entrySet()) {
                emitter.emit(builder.build(diffEntry.getKey(), diffEntry.getValue()));
            }
        }
        return true;
    }
}

