/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.client.CoordinatorServerView;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.ImmutableSegmentLoadInfo;
import org.apache.hive.druid.io.druid.client.SegmentLoadInfo;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.java.util.common.MapUtils;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.server.http.InventoryViewUtils;
import org.apache.hive.druid.io.druid.server.http.security.DatasourceResourceFilter;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DatasourcesResource {
    private static final Logger log = new Logger(DatasourcesResource.class);
    private final CoordinatorServerView serverInventoryView;
    private final MetadataSegmentManager databaseSegmentManager;
    private final IndexingServiceClient indexingServiceClient;
    private final AuthConfig authConfig;

    @Inject
    public DatasourcesResource(CoordinatorServerView serverInventoryView, MetadataSegmentManager databaseSegmentManager, @Nullable IndexingServiceClient indexingServiceClient, AuthConfig authConfig) {
        this.serverInventoryView = serverInventoryView;
        this.databaseSegmentManager = databaseSegmentManager;
        this.indexingServiceClient = indexingServiceClient;
        this.authConfig = authConfig;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") String full, @QueryParam(value="simple") String simple, @Context HttpServletRequest req) {
        Set<DruidDataSource> datasources;
        Response.ResponseBuilder builder = Response.ok();
        Set<DruidDataSource> set = datasources = this.authConfig.isEnabled() ? InventoryViewUtils.getSecuredDataSources(this.serverInventoryView, (AuthorizationInfo)req.getAttribute("Druid-Auth-Token")) : InventoryViewUtils.getDataSources(this.serverInventoryView);
        if (full != null) {
            return builder.entity(datasources).build();
        }
        if (simple != null) {
            return builder.entity(Lists.newArrayList(Iterables.transform(datasources, new Function<DruidDataSource, Map<String, Object>>(){

                @Override
                public Map<String, Object> apply(DruidDataSource dataSource) {
                    return DatasourcesResource.this.makeSimpleDatasource(dataSource);
                }
            }))).build();
        }
        return builder.entity(Lists.newArrayList(Iterables.transform(datasources, new Function<DruidDataSource, String>(){

            @Override
            public String apply(DruidDataSource dataSource) {
                return dataSource.getName();
            }
        }))).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTheDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDataSource(@PathParam(value="dataSourceName") String dataSourceName) {
        if (!this.databaseSegmentManager.enableDatasource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response deleteDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok(ImmutableMap.of("error", "no indexing service found")).build();
        }
        if (kill != null && Boolean.valueOf(kill).booleanValue()) {
            try {
                this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)interval));
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(ImmutableMap.of("error", "Exception occurred. Probably the interval is invalid", "message", e.toString())).build();
            }
            catch (Exception e) {
                return Response.serverError().entity(ImmutableMap.of("error", "Exception occurred. Are you sure you have an indexing service?", "message", e.toString())).build();
            }
        } else if (!this.databaseSegmentManager.removeDatasource(dataSourceName)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    public Response deleteDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval) {
        if (this.indexingServiceClient == null) {
            return Response.ok(ImmutableMap.of("error", "no indexing service found")).build();
        }
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        try {
            this.indexingServiceClient.killSegments(dataSourceName, new Interval((Object)theInterval));
        }
        catch (Exception e) {
            return Response.serverError().entity(ImmutableMap.of("error", "Exception occurred. Are you sure you have an indexing service?", "message", e.toString())).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Comparator<Interval> comparator = Comparators.inverse(Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap retVal = Maps.newTreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                HashMap segments = (HashMap)retVal.get(dataSegment.getInterval());
                if (segments == null) {
                    segments = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), segments);
                }
                Pair<DataSegment, Set<String>> val = this.getSegment(dataSegment.getIdentifier());
                segments.put(dataSegment.getIdentifier(), ImmutableMap.of("metadata", val.lhs, "servers", val.rhs));
            }
            return Response.ok(retVal).build();
        }
        if (simple != null) {
            TreeMap<Interval, HashMap<String, Object>> retVal = Maps.newTreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                HashMap<String, Object> properties = (HashMap<String, Object>)retVal.get(dataSegment.getInterval());
                if (properties == null) {
                    properties = Maps.newHashMap();
                    properties.put("size", dataSegment.getSize());
                    properties.put("count", 1);
                    retVal.put(dataSegment.getInterval(), properties);
                    continue;
                }
                properties.put("size", MapUtils.getLong(properties, "size", 0L) + dataSegment.getSize());
                properties.put("count", MapUtils.getInt(properties, "count", 0) + 1);
            }
            return Response.ok(retVal).build();
        }
        TreeSet<Interval> intervals = Sets.newTreeSet(comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            intervals.add(dataSegment.getInterval());
        }
        return Response.ok(intervals).build();
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Comparator<Interval> comparator = Comparators.inverse(Comparators.intervalsByStartThenEnd());
        if (full != null) {
            TreeMap retVal = Maps.newTreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                HashMap segments = (HashMap)retVal.get(dataSegment.getInterval());
                if (segments == null) {
                    segments = Maps.newHashMap();
                    retVal.put(dataSegment.getInterval(), segments);
                }
                Pair<DataSegment, Set<String>> val = this.getSegment(dataSegment.getIdentifier());
                segments.put(dataSegment.getIdentifier(), ImmutableMap.of("metadata", val.lhs, "servers", val.rhs));
            }
            return Response.ok(retVal).build();
        }
        if (simple != null) {
            HashMap<Interval, HashMap<String, Object>> retVal = Maps.newHashMap();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                HashMap<String, Object> properties = (HashMap<String, Object>)retVal.get(dataSegment.getInterval());
                if (properties == null) {
                    properties = Maps.newHashMap();
                    properties.put("size", dataSegment.getSize());
                    properties.put("count", 1);
                    retVal.put(dataSegment.getInterval(), properties);
                    continue;
                }
                properties.put("size", MapUtils.getLong(properties, "size", 0L) + dataSegment.getSize());
                properties.put("count", MapUtils.getInt(properties, "count", 0) + 1);
            }
            return Response.ok(retVal).build();
        }
        TreeSet retVal = Sets.newTreeSet(Comparators.inverse(String.CASE_INSENSITIVE_ORDER));
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
            retVal.add(dataSegment.getIdentifier());
        }
        return Response.ok(retVal).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity(Iterables.transform(dataSource.getSegments(), new Function<DataSegment, Object>(){

            @Override
            public Object apply(DataSegment segment) {
                return segment.getIdentifier();
            }
        })).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        DruidDataSource dataSource = this.getDataSource(dataSourceName);
        if (dataSource == null) {
            return Response.noContent().build();
        }
        Pair<DataSegment, Set<String>> retVal = this.getSegment(segmentId);
        if (retVal != null) {
            return Response.ok(ImmutableMap.of("metadata", retVal.lhs, "servers", retVal.rhs)).build();
        }
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response deleteDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.removeSegment(dataSourceName, segmentId)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response enableDatasourceSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        if (!this.databaseSegmentManager.enableSegment(segmentId)) {
            return Response.noContent().build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceTiers(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet<String> retVal = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok(retVal).build();
    }

    private DruidDataSource getDataSource(final String dataSourceName) {
        Iterable<DruidDataSource> dataSources = Iterables.concat(new Iterable[]{Iterables.transform(this.serverInventoryView.getInventory(), new Function<DruidServer, DruidDataSource>(){

            @Override
            public DruidDataSource apply(DruidServer input) {
                return input.getDataSource(dataSourceName);
            }
        })});
        ArrayList<DruidDataSource> validDataSources = Lists.newArrayList();
        for (DruidDataSource dataSource : dataSources) {
            if (dataSource == null) continue;
            validDataSources.add(dataSource);
        }
        if (validDataSources.isEmpty()) {
            return null;
        }
        HashMap<String, DataSegment> segmentMap = Maps.newHashMap();
        for (DruidDataSource dataSource : validDataSources) {
            if (dataSource == null) continue;
            Set<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getIdentifier(), segment);
            }
        }
        return new DruidDataSource(dataSourceName, ImmutableMap.of()).addSegments(segmentMap);
    }

    private Pair<DataSegment, Set<String>> getSegment(String segmentId) {
        DataSegment theSegment = null;
        HashSet<String> servers = Sets.newHashSet();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegments().get(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, servers);
    }

    private Map<String, Object> makeSimpleDatasource(DruidDataSource input) {
        return new ImmutableMap.Builder<String, String>().put("name", input.getName()).put("properties", (String)((Object)this.getSimpleDatasource(input.getName()))).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap<String, HashMap<String, Object>> tiers = Maps.newHashMap();
        HashMap<String, Number> segments = Maps.newHashMap();
        ImmutableMap<String, Map<String, Object>> retVal = ImmutableMap.of("tiers", tiers, "segments", segments);
        HashSet<String> totalDistinctSegments = Sets.newHashSet();
        HashMap tierDistinctSegments = Maps.newHashMap();
        long totalSegmentSize = 0L;
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            if (!tierDistinctSegments.containsKey(tier)) {
                tierDistinctSegments.put(tier, Sets.newHashSet());
            }
            long dataSourceSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getIdentifier())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getIdentifier());
                }
                if (totalDistinctSegments.contains(dataSegment.getIdentifier())) continue;
                totalSegmentSize += dataSegment.getSize();
                totalDistinctSegments.add(dataSegment.getIdentifier());
                if (dataSegment.getInterval().getStartMillis() < minTime) {
                    minTime = dataSegment.getInterval().getStartMillis();
                }
                if (dataSegment.getInterval().getEndMillis() <= maxTime) continue;
                maxTime = dataSegment.getInterval().getEndMillis();
            }
            HashMap<String, Object> tierStats = (HashMap<String, Object>)tiers.get(tier);
            if (tierStats == null) {
                tierStats = Maps.newHashMap();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong(tierStats, "size", 0L);
            tierStats.put("size", segmentSize + dataSourceSegmentSize);
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("minTime", (Number)new DateTime(minTime));
        segments.put("maxTime", (Number)new DateTime(maxTime));
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getSegmentDataSourceSpecificInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline(new TableDataSource(dataSourceName));
        Interval theInterval = new Interval((Object)interval.replace("_", "/"));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", dataSourceName);
            return Response.ok(Lists.newArrayList()).build();
        }
        List lookup = timeline.lookupWithIncompletePartitions(theInterval);
        FunctionalIterable<ImmutableSegmentLoadInfo> retval = FunctionalIterable.create(lookup).transformCat(new Function<TimelineObjectHolder<String, SegmentLoadInfo>, Iterable<ImmutableSegmentLoadInfo>>(){

            @Override
            public Iterable<ImmutableSegmentLoadInfo> apply(TimelineObjectHolder<String, SegmentLoadInfo> input) {
                return Iterables.transform(input.getObject(), new Function<PartitionChunk<SegmentLoadInfo>, ImmutableSegmentLoadInfo>(){

                    @Override
                    public ImmutableSegmentLoadInfo apply(PartitionChunk<SegmentLoadInfo> chunk) {
                        return chunk.getObject().toImmutableSegmentLoadInfo();
                    }
                });
            }
        });
        return Response.ok(retval).build();
    }
}

