/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.client.ServerInventoryView;
import org.apache.hive.druid.io.druid.client.indexing.IndexingServiceClient;
import org.apache.hive.druid.io.druid.common.config.JacksonConfigManager;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.curator.discovery.ServiceAnnouncer;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.annotations.CoordinatorIndexingServiceHelper;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.io.druid.java.util.common.guava.CloseQuietly;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.metadata.MetadataSegmentManager;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategy;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueueTaskMaster;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorCleanupOvershadowed;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorCleanupUnneeded;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorLogger;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorSegmentInfoLoader;
import org.apache.hive.druid.io.druid.server.coordinator.rules.LoadRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;

@ManageLifecycle
public class DruidCoordinator {
    public static final String COORDINATOR_OWNER_NODE = "_COORDINATOR";
    public static Comparator<DataSegment> SEGMENT_COMPARATOR = Ordering.from(Comparators.intervalsByEndThenStart()).onResultOf(new Function<DataSegment, Interval>(){

        @Override
        public Interval apply(DataSegment segment) {
            return segment.getInterval();
        }
    }).compound(Ordering.natural()).reverse();
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinator.class);
    private final Object lock = new Object();
    private final DruidCoordinatorConfig config;
    private final ZkPathsConfig zkPaths;
    private final JacksonConfigManager configManager;
    private final MetadataSegmentManager metadataSegmentManager;
    private final ServerInventoryView serverInventoryView;
    private final MetadataRuleManager metadataRuleManager;
    private final CuratorFramework curator;
    private final ServiceEmitter emitter;
    private final IndexingServiceClient indexingServiceClient;
    private final ScheduledExecutorService exec;
    private final LoadQueueTaskMaster taskMaster;
    private final Map<String, LoadQueuePeon> loadManagementPeons;
    private final AtomicReference<LeaderLatch> leaderLatch;
    private final ServiceAnnouncer serviceAnnouncer;
    private final DruidNode self;
    private final Set<DruidCoordinatorHelper> indexingServiceHelpers;
    private volatile boolean started = false;
    private volatile int leaderCounter = 0;
    private volatile boolean leader = false;
    private volatile SegmentReplicantLookup segmentReplicantLookup = null;
    private final BalancerStrategyFactory factory;
    private final LookupCoordinatorManager lookupCoordinatorManager;

    @Inject
    public DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, @Self DruidNode self, @CoordinatorIndexingServiceHelper Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager) {
        this(config, zkPaths, configManager, metadataSegmentManager, serverInventoryView, metadataRuleManager, curator, emitter, scheduledExecutorFactory, indexingServiceClient, taskMaster, serviceAnnouncer, self, Maps.newConcurrentMap(), indexingServiceHelpers, factory, lookupCoordinatorManager);
    }

    DruidCoordinator(DruidCoordinatorConfig config, ZkPathsConfig zkPaths, JacksonConfigManager configManager, MetadataSegmentManager metadataSegmentManager, ServerInventoryView serverInventoryView, MetadataRuleManager metadataRuleManager, CuratorFramework curator, ServiceEmitter emitter, ScheduledExecutorFactory scheduledExecutorFactory, IndexingServiceClient indexingServiceClient, LoadQueueTaskMaster taskMaster, ServiceAnnouncer serviceAnnouncer, DruidNode self, ConcurrentMap<String, LoadQueuePeon> loadQueuePeonMap, Set<DruidCoordinatorHelper> indexingServiceHelpers, BalancerStrategyFactory factory, LookupCoordinatorManager lookupCoordinatorManager) {
        this.config = config;
        this.zkPaths = zkPaths;
        this.configManager = configManager;
        this.metadataSegmentManager = metadataSegmentManager;
        this.serverInventoryView = serverInventoryView;
        this.metadataRuleManager = metadataRuleManager;
        this.curator = curator;
        this.emitter = emitter;
        this.indexingServiceClient = indexingServiceClient;
        this.taskMaster = taskMaster;
        this.serviceAnnouncer = serviceAnnouncer;
        this.self = self;
        this.indexingServiceHelpers = indexingServiceHelpers;
        this.exec = scheduledExecutorFactory.create(1, "Coordinator-Exec--%d");
        this.leaderLatch = new AtomicReference<Object>(null);
        this.loadManagementPeons = loadQueuePeonMap;
        this.factory = factory;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public Map<String, LoadQueuePeon> getLoadManagementPeons() {
        return this.loadManagementPeons;
    }

    public Map<String, ? extends Object2LongMap<String>> getReplicationStatus() {
        HashMap retVal = Maps.newHashMap();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        DateTime now = new DateTime();
        for (DataSegment segment : this.getAvailableDataSegments()) {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(segment.getDataSource());
            for (Rule rule : rules) {
                if (!(rule instanceof LoadRule) || !rule.appliesTo(segment, now)) continue;
                ((LoadRule)rule).getTieredReplicants().forEach((tier, ruleReplicants) -> {
                    int currentReplicants = this.segmentReplicantLookup.getTotalReplicants(segment.getIdentifier(), (String)tier);
                    retVal.computeIfAbsent(tier, ignored -> new Object2LongOpenHashMap()).addTo(segment.getDataSource(), Math.max(ruleReplicants - currentReplicants, 0));
                });
            }
        }
        return retVal;
    }

    public Object2LongMap<String> getSegmentAvailability() {
        Object2LongOpenHashMap<String> retVal = new Object2LongOpenHashMap<String>();
        if (this.segmentReplicantLookup == null) {
            return retVal;
        }
        for (DataSegment segment : this.getAvailableDataSegments()) {
            if (this.segmentReplicantLookup.getTotalReplicants(segment.getIdentifier()) == 0) {
                retVal.addTo(segment.getDataSource(), 1L);
                continue;
            }
            retVal.addTo(segment.getDataSource(), 0L);
        }
        return retVal;
    }

    boolean hasLoadPending(String dataSource) {
        return this.loadManagementPeons.values().stream().flatMap(peon -> peon.getSegmentsToLoad().stream()).anyMatch(segment -> segment.getDataSource().equals(dataSource));
    }

    public Map<String, Double> getLoadStatus() {
        HashMap<String, Double> loadStatus = Maps.newHashMap();
        for (DruidDataSource dataSource : this.metadataSegmentManager.getInventory()) {
            HashSet<DataSegment> segments = Sets.newHashSet(dataSource.getSegments());
            int availableSegmentSize = segments.size();
            for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
                DruidDataSource loadedView = druidServer.getDataSource(dataSource.getName());
                if (loadedView == null) continue;
                segments.removeAll(loadedView.getSegments());
            }
            int unloadedSegmentSize = segments.size();
            loadStatus.put(dataSource.getName(), 100.0 * ((double)(availableSegmentSize - unloadedSegmentSize) / (double)availableSegmentSize));
        }
        return loadStatus;
    }

    public CoordinatorDynamicConfig getDynamicConfigs() {
        return this.configManager.watch("coordinator.config", CoordinatorDynamicConfig.class, new CoordinatorDynamicConfig.Builder().build()).get();
    }

    public void removeSegment(DataSegment segment) {
        log.info("Removing Segment[%s]", segment);
        this.metadataSegmentManager.removeSegment(segment.getDataSource(), segment.getIdentifier());
    }

    public void removeDatasource(String ds) {
        this.metadataSegmentManager.removeDatasource(ds);
    }

    public void enableDatasource(String ds) {
        this.metadataSegmentManager.enableDatasource(ds);
    }

    public String getCurrentLeader() {
        try {
            LeaderLatch latch = this.leaderLatch.get();
            if (latch == null) {
                return null;
            }
            Participant participant = latch.getLeader();
            if (participant.isLeader()) {
                return participant.getId();
            }
            return null;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public void moveSegment(ImmutableDruidServer fromServer, final ImmutableDruidServer toServer, final DataSegment segment, final LoadPeonCallback callback) {
        block10: {
            if (segment == null) {
                log.makeAlert(new IAE("Can not move null DataSegment", new Object[0]), "Exception moving null segment", new Object[0]).emit();
                if (callback != null) {
                    callback.execute();
                }
            }
            String segmentName = segment.getIdentifier();
            try {
                if (fromServer.getMetadata().equals(toServer.getMetadata())) {
                    throw new IAE("Cannot move [%s] to and from the same server [%s]", segmentName, fromServer.getName());
                }
                DruidDataSource dataSource = this.metadataSegmentManager.getInventoryValue(segment.getDataSource());
                if (dataSource == null) {
                    throw new IAE("Unable to find dataSource for segment [%s] in metadata", segmentName);
                }
                DataSegment segmentToLoad = dataSource.getSegment(segment.getIdentifier());
                if (segmentToLoad == null) {
                    throw new IAE("No segment metadata found for segment Id [%s]", segment.getIdentifier());
                }
                LoadQueuePeon loadPeon = this.loadManagementPeons.get(toServer.getName());
                if (loadPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", toServer.getName());
                }
                final LoadQueuePeon dropPeon = this.loadManagementPeons.get(fromServer.getName());
                if (dropPeon == null) {
                    throw new IAE("LoadQueuePeon hasn't been created yet for path [%s]", fromServer.getName());
                }
                ServerHolder toHolder = new ServerHolder(toServer, loadPeon);
                if (toHolder.getAvailableSize() < segmentToLoad.getSize()) {
                    throw new IAE("Not enough capacity on server [%s] for segment [%s]. Required: %,d, available: %,d.", toServer.getName(), segmentToLoad, segmentToLoad.getSize(), toHolder.getAvailableSize());
                }
                final String toLoadQueueSegPath = ZKPaths.makePath((String)ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)toServer.getName()), (String)segmentName);
                loadPeon.loadSegment(segmentToLoad, new LoadPeonCallback(){

                    @Override
                    public void execute() {
                        try {
                            if (DruidCoordinator.this.serverInventoryView.isSegmentLoadedByServer(toServer.getName(), segment) && DruidCoordinator.this.curator.checkExists().forPath(toLoadQueueSegPath) == null && !dropPeon.getSegmentsToDrop().contains(segment)) {
                                dropPeon.dropSegment(segment, callback);
                            } else if (callback != null) {
                                callback.execute();
                            }
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                });
            }
            catch (Exception e) {
                log.makeAlert(e, "Exception moving segment %s", segmentName).emit();
                if (callback == null) break block10;
                callback.execute();
            }
        }
    }

    public Set<DataSegment> getOrderedAvailableDataSegments() {
        TreeSet<DataSegment> availableSegments = Sets.newTreeSet(SEGMENT_COMPARATOR);
        Iterable<DataSegment> dataSegments = this.getAvailableDataSegments();
        for (DataSegment dataSegment : dataSegments) {
            if (dataSegment.getSize() < 0L) {
                log.makeAlert("No size on Segment, wtf?", new Object[0]).addData("segment", dataSegment).emit();
            }
            availableSegments.add(dataSegment);
        }
        return availableSegments;
    }

    public Iterable<DataSegment> getAvailableDataSegments() {
        return Iterables.concat(Iterables.transform(this.metadataSegmentManager.getInventory(), new Function<DruidDataSource, Iterable<DataSegment>>(){

            @Override
            public Iterable<DataSegment> apply(DruidDataSource input) {
                return input.getSegments();
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.createNewLeaderLatch();
            try {
                this.leaderLatch.get().start();
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private LeaderLatch createNewLeaderLatch() {
        LeaderLatch newLeaderLatch = new LeaderLatch(this.curator, ZKPaths.makePath((String)this.zkPaths.getCoordinatorPath(), (String)COORDINATOR_OWNER_NODE), this.self.getHostAndPort());
        newLeaderLatch.addListener(new LeaderLatchListener(){

            public void isLeader() {
                DruidCoordinator.this.becomeLeader();
            }

            public void notLeader() {
                DruidCoordinator.this.stopBeingLeader();
            }
        }, (Executor)Execs.singleThreaded("CoordinatorLeader-%s"));
        return this.leaderLatch.getAndSet(newLeaderLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.stopBeingLeader();
            try {
                this.leaderLatch.get().close();
            }
            catch (IOException e) {
                log.warn(e, "Unable to close leaderLatch, ignoring", new Object[0]);
            }
            this.started = false;
            this.exec.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void becomeLeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("I am the leader of the coordinators, all must bow!", new Object[0]);
            log.info("Starting coordination in [%s]", this.config.getCoordinatorStartDelay());
            try {
                ++this.leaderCounter;
                this.leader = true;
                this.metadataSegmentManager.start();
                this.metadataRuleManager.start();
                this.serviceAnnouncer.announce(this.self);
                final int startingLeaderCounter = this.leaderCounter;
                ArrayList<Pair<CoordinatorRunnable, Duration>> coordinatorRunnables = Lists.newArrayList();
                coordinatorRunnables.add(Pair.of(new CoordinatorHistoricalManagerRunnable(startingLeaderCounter), this.config.getCoordinatorPeriod()));
                if (this.indexingServiceClient != null) {
                    coordinatorRunnables.add(Pair.of(new CoordinatorIndexingServiceRunnable(this.makeIndexingServiceHelpers(), startingLeaderCounter), this.config.getCoordinatorIndexingPeriod()));
                }
                for (final Pair pair : coordinatorRunnables) {
                    ScheduledExecutors.scheduleWithFixedDelay(this.exec, this.config.getCoordinatorStartDelay(), (Duration)pair.rhs, new Callable<ScheduledExecutors.Signal>(){
                        private final CoordinatorRunnable theRunnable;
                        {
                            this.theRunnable = (CoordinatorRunnable)pair.lhs;
                        }

                        @Override
                        public ScheduledExecutors.Signal call() {
                            if (DruidCoordinator.this.leader && startingLeaderCounter == DruidCoordinator.this.leaderCounter) {
                                this.theRunnable.run();
                            }
                            if (DruidCoordinator.this.leader && startingLeaderCounter == DruidCoordinator.this.leaderCounter) {
                                return ScheduledExecutors.Signal.REPEAT;
                            }
                            return ScheduledExecutors.Signal.STOP;
                        }
                    });
                }
                this.lookupCoordinatorManager.start();
            }
            catch (Exception e) {
                log.makeAlert(e, "Unable to become leader", new Object[0]).emit();
                LeaderLatch oldLatch = this.createNewLeaderLatch();
                CloseQuietly.close((Closeable)oldLatch);
                try {
                    this.leaderLatch.get().start();
                }
                catch (Exception e1) {
                    log.makeAlert(e1, "I am a zombie", new Object[0]).emit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBeingLeader() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ++this.leaderCounter;
                log.info("I am no longer the leader...", new Object[0]);
                for (String server : this.loadManagementPeons.keySet()) {
                    LoadQueuePeon peon = this.loadManagementPeons.remove(server);
                    peon.stop();
                }
                this.loadManagementPeons.clear();
                this.serviceAnnouncer.unannounce(this.self);
                this.metadataRuleManager.stop();
                this.metadataSegmentManager.stop();
                this.lookupCoordinatorManager.stop();
                this.leader = false;
            }
            catch (Exception e) {
                log.makeAlert(e, "Unable to stopBeingLeader", new Object[0]).emit();
            }
        }
    }

    private List<DruidCoordinatorHelper> makeIndexingServiceHelpers() {
        ArrayList<DruidCoordinatorHelper> helpers = Lists.newArrayList();
        helpers.add(new DruidCoordinatorSegmentInfoLoader(this));
        helpers.addAll(this.indexingServiceHelpers);
        log.info("Done making indexing service helpers [%s]", helpers);
        return ImmutableList.copyOf(helpers);
    }

    private class CoordinatorIndexingServiceRunnable
    extends CoordinatorRunnable {
        public CoordinatorIndexingServiceRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            super(helpers, startingLeaderCounter);
        }
    }

    private class CoordinatorHistoricalManagerRunnable
    extends CoordinatorRunnable {
        public CoordinatorHistoricalManagerRunnable(int startingLeaderCounter) {
            super(ImmutableList.of(new DruidCoordinatorSegmentInfoLoader(DruidCoordinator.this), new DruidCoordinatorHelper(){

                @Override
                public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                    FunctionalIterable<ImmutableDruidServer> servers = FunctionalIterable.create(DruidCoordinator.this.serverInventoryView.getInventory()).filter(new Predicate<DruidServer>(){

                        @Override
                        public boolean apply(DruidServer input) {
                            return input.segmentReplicatable();
                        }
                    }).transform(new Function<DruidServer, ImmutableDruidServer>(){

                        @Override
                        public ImmutableDruidServer apply(DruidServer input) {
                            return input.toImmutableDruidServer();
                        }
                    });
                    if (log.isDebugEnabled()) {
                        log.debug("Servers", new Object[0]);
                        for (ImmutableDruidServer immutableDruidServer : servers) {
                            log.debug("  %s", immutableDruidServer);
                            log.debug("    -- DataSources", new Object[0]);
                            for (ImmutableDruidDataSource druidDataSource : immutableDruidServer.getDataSources()) {
                                log.debug("    %s", druidDataSource);
                            }
                        }
                    }
                    DruidCluster cluster = new DruidCluster();
                    for (ImmutableDruidServer server : servers) {
                        if (!DruidCoordinator.this.loadManagementPeons.containsKey(server.getName())) {
                            String basePath = ZKPaths.makePath((String)DruidCoordinator.this.zkPaths.getLoadQueuePath(), (String)server.getName());
                            LoadQueuePeon loadQueuePeon = DruidCoordinator.this.taskMaster.giveMePeon(basePath);
                            loadQueuePeon.start();
                            log.info("Creating LoadQueuePeon for server[%s] at path[%s]", server.getName(), basePath);
                            DruidCoordinator.this.loadManagementPeons.put(server.getName(), loadQueuePeon);
                        }
                        cluster.add(new ServerHolder(server, (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.get(server.getName())));
                    }
                    DruidCoordinator.this.segmentReplicantLookup = SegmentReplicantLookup.make(cluster);
                    HashSet<String> hashSet = Sets.newHashSet(DruidCoordinator.this.loadManagementPeons.keySet());
                    for (ImmutableDruidServer server : servers) {
                        hashSet.remove(server.getName());
                    }
                    for (String name : hashSet) {
                        log.info("Removing listener for server[%s] which is no longer there.", name);
                        LoadQueuePeon peon = (LoadQueuePeon)DruidCoordinator.this.loadManagementPeons.remove(name);
                        peon.stop();
                    }
                    return params.buildFromExisting().withDruidCluster(cluster).withDatabaseRuleManager(DruidCoordinator.this.metadataRuleManager).withLoadManagementPeons(DruidCoordinator.this.loadManagementPeons).withSegmentReplicantLookup(DruidCoordinator.this.segmentReplicantLookup).withBalancerReferenceTimestamp(DateTime.now()).build();
                }
            }, new DruidCoordinatorRuleRunner(DruidCoordinator.this), new DruidCoordinatorCleanupUnneeded(DruidCoordinator.this), new DruidCoordinatorCleanupOvershadowed(DruidCoordinator.this), new DruidCoordinatorBalancer(DruidCoordinator.this), new DruidCoordinatorLogger(DruidCoordinator.this)), startingLeaderCounter);
        }
    }

    public abstract class CoordinatorRunnable
    implements Runnable {
        private final long startTime = System.currentTimeMillis();
        private final List<DruidCoordinatorHelper> helpers;
        private final int startingLeaderCounter;

        protected CoordinatorRunnable(List<DruidCoordinatorHelper> helpers, int startingLeaderCounter) {
            this.helpers = helpers;
            this.startingLeaderCounter = startingLeaderCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ExecutorService balancerExec = null;
            try {
                Object object = DruidCoordinator.this.lock;
                synchronized (object) {
                    LeaderLatch latch = (LeaderLatch)DruidCoordinator.this.leaderLatch.get();
                    if (latch == null || !latch.hasLeadership()) {
                        log.info("LEGGO MY EGGO. [%s] is leader.", latch == null ? null : latch.getLeader().getId());
                        DruidCoordinator.this.stopBeingLeader();
                        return;
                    }
                }
                List<Boolean> allStarted = Arrays.asList(DruidCoordinator.this.metadataSegmentManager.isStarted(), DruidCoordinator.this.serverInventoryView.isStarted());
                for (Boolean aBoolean : allStarted) {
                    if (aBoolean.booleanValue()) continue;
                    log.error("InventoryManagers not started[%s]", allStarted);
                    DruidCoordinator.this.stopBeingLeader();
                    return;
                }
                balancerExec = MoreExecutors.listeningDecorator(Execs.multiThreaded(DruidCoordinator.this.getDynamicConfigs().getBalancerComputeThreads(), "coordinator-cost-balancer-%s"));
                BalancerStrategy balancerStrategy = DruidCoordinator.this.factory.createBalancerStrategy((ListeningExecutorService)balancerExec);
                DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withStartTime(this.startTime).withDatasources(DruidCoordinator.this.metadataSegmentManager.getInventory()).withDynamicConfigs(DruidCoordinator.this.getDynamicConfigs()).withEmitter(DruidCoordinator.this.emitter).withBalancerStrategy(balancerStrategy).build();
                Iterator<DruidCoordinatorHelper> iterator = this.helpers.iterator();
                while (iterator.hasNext()) {
                    DruidCoordinatorHelper helper = iterator.next();
                    if (!DruidCoordinator.this.leader || this.startingLeaderCounter != DruidCoordinator.this.leaderCounter) continue;
                    params = helper.run(params);
                }
                return;
            }
            catch (Exception e) {
                log.makeAlert(e, "Caught exception, ignoring so that schedule keeps going.", new Object[0]).emit();
                return;
            }
            finally {
                if (balancerExec != null) {
                    balancerExec.shutdownNow();
                }
            }
        }
    }
}

